/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.datadistributionlayer;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.datamgr.datadistributionlayer.DDLException;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerFactory;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerMember;
import com.avaya.asm.datamgr.datadistributionlayer.GroupCommIntf;
import com.avaya.common.logging.client.Logger;

public class DDLChannelConnThread
extends Thread {
    private boolean canRun;
    protected int MAX_RETRIES_BEFORE_REJOIN = 10;
    protected long TIME_BETWEEN_RETRIES = 10000L;
    protected long TIME_BETWEEN_AUDITS = 3600000L;
    protected GroupCommIntf wrapper;
    protected final Logger log = AsmLogger.getLogger(DDLChannelConnThread.class);

    public DDLChannelConnThread(GroupCommIntf wrapper) {
        super("DDLChannelConnThread");
        this.wrapper = wrapper;
        this.canRun = true;
    }

    @Override
    public void run() {
        while (this.canRun) {
            try {
                this.waitForChannelDisruption();
                if (!this.canRun) break;
                if (this.wrapper.isConnected()) continue;
                boolean success = false;
                int retries = 0;
                while (++retries <= this.MAX_RETRIES_BEFORE_REJOIN && !success) {
                    Thread.sleep(this.TIME_BETWEEN_RETRIES);
                    this.log.info((Object)("Attempting to reopen and reconnect the " + (Object)((Object)this.wrapper.getGroupType()) + " channel.  This is the " + retries + " attempt (max=" + this.MAX_RETRIES_BEFORE_REJOIN + ")."));
                    success = this.wrapper.reconnectChannel();
                }
                if (!success) {
                    this.rejoinMember();
                    continue;
                }
                this.log.info((Object)"Successful in proactively restoring the channel.");
            }
            catch (DDLException ddle) {
                this.log.info((Object)("Caught DDLException: " + ddle.getMessage()));
                this.rejoinMember();
            }
            catch (Exception e) {
                this.log.error((Object)"Caught exception while monitoring channel.", (Throwable)e);
            }
        }
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)"Destroyed");
        }
    }

    protected void rejoinMember() {
        this.log.error((Object)("Unable to successfully reconnect the channel, trying to fully rejoin the " + (Object)((Object)this.wrapper.getGroupType()) + " member."));
        DataDistLayerMember member = this.wrapper.getGroupType() == GroupCommIntf.DDLGroupType.INTER_SM_CLUSTER ? this.getDDLFactory().getInterClusterMember() : this.getDDLFactory().getIntraClusterMember();
        this.getDDLFactory().rejoinMember(member);
    }

    protected DataDistLayerFactory getDDLFactory() {
        return DataDistLayerFactory.getInstance();
    }

    public synchronized void waitForChannelDisruption() throws Exception {
        this.wait(this.TIME_BETWEEN_AUDITS);
    }

    public synchronized void channelNotConnected() {
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)("Notified that the " + (Object)((Object)this.wrapper.getGroupType()) + " channel was disrupted."));
        }
        this.notify();
    }

    public synchronized void destroy() {
        this.log.info((Object)"Destroying");
        this.canRun = false;
        this.notify();
    }
}

