/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.datadistributionlayer;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.datamgr.ReadWriteLockHandler;
import com.avaya.asm.datamgr.datadistributionlayer.DDLException;
import com.avaya.asm.datamgr.datadistributionlayer.DDLIntraClusterMember;
import com.avaya.asm.datamgr.datadistributionlayer.DDLMessageSender;
import com.avaya.asm.datamgr.datadistributionlayer.DDLRedundancyIntfc;
import com.avaya.asm.datamgr.datadistributionlayer.DDLRetention;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerData;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerDataKey;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerFactory;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerListener;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerMemberAddr;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerMessage;
import com.avaya.asm.datamgr.objectapi.IPAddress;
import com.avaya.common.logging.client.Logger;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.text.ParseException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.PatternSyntaxException;

public class DDLIntraClusterMemberLeader
extends DDLIntraClusterMember {
    private static Logger log = AsmLogger.getLogger(DDLIntraClusterMemberLeader.class);
    protected ReadWriteLockHandler lock = new ReadWriteLockHandler("DDLIntraClusterMemberLeader");
    private DDLRedundancyIntfc redundancyHandler = null;
    private List<DDLRetention> retentionList = null;
    private ConcurrentMap<DataDistLayerMemberAddr, List<DataDistLayerData>> limboList = new ConcurrentHashMap<DataDistLayerMemberAddr, List<DataDistLayerData>>();
    private ConcurrentMap<String, Boolean> limboListBuilt = new ConcurrentHashMap<String, Boolean>();
    private Map<IPAddress, DataDistLayerMemberAddr> blackList = new HashMap<IPAddress, DataDistLayerMemberAddr>();
    protected volatile Map<DataDistLayerMemberAddr, Set<Object>> hostIdKeys = new ConcurrentHashMap<DataDistLayerMemberAddr, Set<Object>>();

    public DDLIntraClusterMemberLeader(String clusterName, String myType, List<DDLRetention> retentionList, DataDistLayerFactory ddlFactory, DDLRedundancyIntfc redundancyHandler) {
        super(clusterName, myType, ddlFactory);
        this.redundancyHandler = redundancyHandler;
        this.retentionList = retentionList != null ? retentionList : new ArrayList<DDLRetention>();
    }

    public void setRetentionList(List<DDLRetention> retentionList) {
        this.retentionList = retentionList;
    }

    @Override
    public Object handleQuery(DataDistLayerMessage message, DataDistLayerMemberAddr srcMember) {
        if (message.getAppId() == DataDistLayerMessage.TargetAppId.INTERNAL) {
            switch (message.getMessageType()) {
                case 19: {
                    return DDLMessageSender.queryOtherMember(this.myGroupType, message);
                }
                case 1: {
                    DataDistLayerMemberAddr host = (DataDistLayerMemberAddr)message.getPayload();
                    return this.retrieveDataByHost(host);
                }
                case 15: {
                    DataDistLayerMemberAddr host = (DataDistLayerMemberAddr)message.getPayload();
                    ArrayList<DataDistLayerData> mHosts = new ArrayList<DataDistLayerData>();
                    try {
                        for (DataDistLayerMemberAddr addr : this.hostIdKeys.keySet()) {
                            if (!addr.getHostId().toString().matches(host.getHostId().toString())) continue;
                            if (log.isFinestEnabled()) {
                                log.finest((Object)(host.getHostId() + " matches " + addr.getHostId()));
                            }
                            mHosts.addAll(this.retrieveDataByHost(addr));
                        }
                    }
                    catch (PatternSyntaxException ex) {
                        log.error((Object)("GetDataByHost: Exception on Regular Expression: " + host), (Throwable)ex);
                    }
                    return mHosts;
                }
                case 14: {
                    DataDistLayerDataKey key = (DataDistLayerDataKey)message.getPayload();
                    return this.retrieveDataByMatchingKey(key);
                }
                case 3: {
                    if (log.isFinestEnabled()) {
                        log.finest((Object)("GET_STORED_HOST_SET returning " + this.hostIdKeys));
                    }
                    HashMap<DataDistLayerMemberAddr, Integer> hostKeys = new HashMap<DataDistLayerMemberAddr, Integer>();
                    for (Map.Entry<DataDistLayerMemberAddr, Set<Object>> e : this.hostIdKeys.entrySet()) {
                        hostKeys.put(e.getKey(), e.getValue().size());
                    }
                    return hostKeys;
                }
            }
        }
        return super.handleQuery(message, srcMember);
    }

    @Override
    protected void sendMyType(DataDistLayerMemberAddr member) {
        super.sendMyType(member);
        if (log.isFineEnabled()) {
            log.fine("sendMyType: Sending SET_LEADER_ID to: " + member + ", myClusterGroup = {" + this.myClusterGroup == null ? null : (this.myClusterGroup.getClusterVersion() + ", " + this.myClusterGroup == null ? null : this.myClusterGroup.getGroupName()));
        }
        this.sendLeaderId(member);
    }

    private void sendLeaderId(DataDistLayerMemberAddr member) {
        DataDistLayerMessage message = new DataDistLayerMessage(DataDistLayerMessage.TargetAppId.INTERNAL, 11, (Serializable)this.myClusterGroup.getThisHostId());
        this.myClusterGroup.sendMessage(member.getHostId(), message);
    }

    @Override
    public void storeData(DataDistLayerData storedData, boolean messageFromPeer) {
        this.storeData(null, storedData, messageFromPeer);
    }

    public void storeData(DataDistLayerMemberAddr sender, DataDistLayerData storedData, boolean messageFromPeer) {
        DataDistLayerData data = storedData;
        this.addDataToList(data.getKey(), data);
        for (WeakReference weakListener : this.listenerMap.values()) {
            DataDistLayerListener listener = (DataDistLayerListener)weakListener.get();
            if (listener == null) continue;
            try {
                listener.dataStored(sender, storedData);
            }
            catch (Exception e) {
                log.error((Object)("Error processing " + listener.getClass().getSimpleName() + "'s dataStored()."), (Throwable)e);
            }
        }
        if (!messageFromPeer) {
            DataDistLayerMessage message = new DataDistLayerMessage(DataDistLayerMessage.TargetAppId.INTERNAL, 12, storedData);
            this.sendMessageToOtherLeaders(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bulkStoreData(List<DataDistLayerData> dataList, boolean messageFromPeer) {
        DataDistLayerMemberAddr owner = null;
        this.lock.acquireWriteLock();
        try {
            if (dataList.size() > 0) {
                owner = dataList.get(0).getOwnerId();
                if (log.isFineEnabled()) {
                    log.fine((Object)("Handling bulk store from " + owner));
                }
                this.removeDataByList(owner, this.retrieveDataByHost(owner));
                for (DataDistLayerData data : dataList) {
                    this.addDataToList(data.getKey(), data);
                }
                if (log.isFineEnabled()) {
                    log.fine((Object)("Completed handling bulk store for " + dataList.size() + " sets of data for " + owner));
                }
            }
        }
        finally {
            this.lock.releaseWriteLock();
        }
        for (WeakReference weakListener : this.listenerMap.values()) {
            DataDistLayerListener listener = (DataDistLayerListener)weakListener.get();
            if (listener == null) continue;
            try {
                listener.bulkStoreReceived(owner, dataList);
            }
            catch (Exception e) {
                log.error((Object)("Error processing " + listener.getClass().getSimpleName() + "'s bulkStoreReceived()."), (Throwable)e);
            }
        }
        if (!messageFromPeer) {
            DataDistLayerMessage message = new DataDistLayerMessage(DataDistLayerMessage.TargetAppId.INTERNAL, 12, (Serializable)((Object)dataList));
            this.sendMessageToOtherLeaders(message);
        }
    }

    @Override
    public void updateData(DataDistLayerData oldData, DataDistLayerData newData, boolean messageFromPeer, boolean updatedByRef, boolean pushData) {
        this.updateData(null, oldData, newData, messageFromPeer, updatedByRef, pushData);
    }

    public void updateData(DataDistLayerMemberAddr sender, DataDistLayerData oldData, DataDistLayerData newData, boolean messageFromPeer, boolean updatedByRef, boolean pushData) {
        DataDistLayerMessage message = new DataDistLayerMessage(DataDistLayerMessage.TargetAppId.INTERNAL, 13, null);
        if (!updatedByRef) {
            this.updateDataInList(oldData.getKey(), oldData, newData);
            if (log.isFinestEnabled()) {
                log.finest((Object)("DataDistCluster leader updated data: " + oldData.toString() + " to : " + newData.toString()));
            }
        } else if (log.isFinestEnabled()) {
            log.finest((Object)("DataDistCluster leader updated data, by reference, to: " + newData.toString()));
        }
        for (WeakReference weakListener : this.listenerMap.values()) {
            DataDistLayerListener listener = (DataDistLayerListener)weakListener.get();
            if (listener == null) continue;
            try {
                listener.dataUpdated(sender, oldData, newData);
            }
            catch (Exception e) {
                log.error((Object)("Error processing " + listener.getClass().getSimpleName() + "'s dataUpdated()."), (Throwable)e);
            }
        }
        if (!messageFromPeer) {
            if (oldData.getUserCommId() != null && !oldData.getUserCommId().equals(newData.getUserCommId())) {
                message.setMessageType(7);
                message.setPayload(oldData);
                this.sendMessageToOtherLeaders(message);
                message.setMessageType(12);
                message.setPayload(newData);
                this.sendMessageToOtherLeaders(message);
            } else {
                message.setMessageType(13);
                ArrayList<DataDistLayerData> tempList = new ArrayList<DataDistLayerData>();
                tempList.add(oldData);
                tempList.add(newData);
                message.setPayload(tempList);
                if (log.isFinestEnabled()) {
                    log.finest((Object)("DataDistCluster sent updateData to leader, oldData: " + oldData.toString() + " newData: " + newData.toString()));
                }
                this.sendMessageToOtherLeaders(message);
            }
        }
    }

    public void updateData(DataDistLayerMemberAddr sender, DataDistLayerData newData, boolean messageFromPeer, boolean updatedByRef) {
        DataDistLayerMessage message = new DataDistLayerMessage(DataDistLayerMessage.TargetAppId.INTERNAL, 27, null);
        if (!updatedByRef) {
            this.updateDataInList(newData);
            if (log.isFinestEnabled()) {
                log.finest((Object)("DataDistCluster leader updated data: " + newData.toString()));
            }
        } else if (log.isFinestEnabled()) {
            log.finest((Object)("DataDistCluster leader updated data, by reference, to: " + newData.toString()));
        }
        for (WeakReference weakListener : this.listenerMap.values()) {
            DataDistLayerListener listener = (DataDistLayerListener)weakListener.get();
            if (listener == null) continue;
            try {
                listener.dataUpdated(sender, null, newData);
            }
            catch (Exception e) {
                log.error((Object)("Error processing " + listener.getClass().getSimpleName() + "'s dataUpdated()."), (Throwable)e);
            }
        }
        if (!messageFromPeer) {
            message.setMessageType(27);
            ArrayList<DataDistLayerData> tempList = new ArrayList<DataDistLayerData>();
            tempList.add(newData);
            message.setPayload(tempList);
            if (log.isFinestEnabled()) {
                log.finest((Object)("DataDistCluster sent updateData to leader,  newData: " + newData.toString()));
            }
            this.sendMessageToOtherLeaders(message);
        }
    }

    @Override
    public void updateDataByKey(DataDistLayerData oldData, DataDistLayerData newData, boolean messageFromPeer, boolean updatedByRef, boolean pushData) {
        this.updateDataByKey(null, oldData, newData, messageFromPeer, updatedByRef, pushData);
    }

    public void updateDataByKey(DataDistLayerMemberAddr sender, DataDistLayerData oldData, DataDistLayerData newData, boolean messageFromPeer, boolean updatedByRef, boolean pushData) {
        DataDistLayerMessage message = new DataDistLayerMessage(DataDistLayerMessage.TargetAppId.INTERNAL, 27, null);
        if (!updatedByRef) {
            this.updateDataInList(newData.getKey(), oldData, newData);
            if (log.isFinestEnabled()) {
                log.finest((Object)("DataDistCluster leader updated data: " + newData.toString()));
            }
        } else if (log.isFinestEnabled()) {
            log.finest((Object)("DataDistCluster leader updated data, by reference, to: " + newData.toString()));
        }
        for (WeakReference weakListener : this.listenerMap.values()) {
            DataDistLayerListener listener = (DataDistLayerListener)weakListener.get();
            if (listener == null) continue;
            try {
                listener.dataUpdated(sender, oldData, newData);
            }
            catch (Exception e) {
                log.error((Object)("Error processing " + listener.getClass().getSimpleName() + "'s dataUpdated()."), (Throwable)e);
            }
        }
        if (!messageFromPeer) {
            message.setMessageType(27);
            ArrayList<DataDistLayerData> tempList = new ArrayList<DataDistLayerData>();
            tempList.add(newData);
            message.setPayload(tempList);
            if (log.isFinestEnabled()) {
                log.finest((Object)("DataDistCluster sent updateData to leader,  newData: " + newData.toString()));
            }
            this.sendMessageToOtherLeaders(message);
        }
    }

    @Override
    public void removeDataByKey(DataDistLayerData actualData, boolean messageFromPeer) {
        this.removeDataByKey(null, actualData, messageFromPeer);
    }

    public void removeDataByKey(DataDistLayerMemberAddr sender, DataDistLayerData actualData, boolean messageFromPeer) {
        if (actualData == null) {
            return;
        }
        DataDistLayerData data = actualData;
        this.removeDataFromList(data.getKey(), data);
        for (WeakReference weakListener : this.listenerMap.values()) {
            DataDistLayerListener listener = (DataDistLayerListener)weakListener.get();
            if (listener == null) continue;
            try {
                listener.dataRemoved(sender, actualData);
            }
            catch (Exception e) {
                log.error((Object)("Error processing " + listener.getClass().getSimpleName() + "'s dataRemoved()."), (Throwable)e);
            }
        }
        if (!messageFromPeer) {
            DataDistLayerData msgData = new DataDistLayerData(data.getKey(), data.getUserCommId());
            DataDistLayerMessage message = new DataDistLayerMessage(DataDistLayerMessage.TargetAppId.INTERNAL, 9, msgData);
            this.sendMessageToOtherLeaders(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bulkRemoveData(DataDistLayerMemberAddr sender, List<DataDistLayerData> dataList, boolean messageFromPeer) {
        try {
            this.lock.acquireWriteLock();
            ArrayList ownDataList = new ArrayList();
            for (DataDistLayerData data : dataList) {
                if (messageFromPeer && this.myClusterName.equals(data.getOwnerId().getClusterName())) {
                    ownDataList.add(data);
                    continue;
                }
                this.removeDataFromList(data.getKey(), data);
            }
            if (ownDataList.size() > 0) {
                log.warn((Object)("removeDataInternal: Were asked to remove " + ownDataList.size() + " sets of data that we own from another member."));
                if (log.isFinerEnabled()) {
                    log.finer((Object)("removeDataInternal: The entries that we own and were told to remove are: " + ownDataList));
                }
            }
        }
        finally {
            this.lock.releaseWriteLock();
        }
        for (WeakReference weakListener : this.listenerMap.values()) {
            DataDistLayerListener listener = (DataDistLayerListener)weakListener.get();
            if (listener == null) continue;
            try {
                listener.bulkRemoveReceived(sender, dataList);
            }
            catch (Exception e) {
                log.error((Object)("Error processing " + listener.getClass().getSimpleName() + "'s bulkRemoveReceived()."), (Throwable)e);
            }
        }
        if (!messageFromPeer) {
            DataDistLayerMessage message = new DataDistLayerMessage(DataDistLayerMessage.TargetAppId.INTERNAL, 7, (Serializable)((Object)dataList));
            this.sendMessageToOtherLeaders(message);
        }
    }

    @Override
    public void removeData(DataDistLayerData removedData, boolean messageFromPeer) {
        this.removeData(null, removedData, messageFromPeer);
    }

    public void removeData(DataDistLayerMemberAddr sender, DataDistLayerData removedData, boolean messageFromPeer) {
        DataDistLayerData data = removedData;
        this.removeDataFromList(data.getKey(), data);
        for (WeakReference weakListener : this.listenerMap.values()) {
            DataDistLayerListener listener = (DataDistLayerListener)weakListener.get();
            if (listener == null) continue;
            try {
                listener.dataRemoved(sender, removedData);
            }
            catch (Exception e) {
                log.error((Object)("Error processing " + listener.getClass().getSimpleName() + "'s dataRemoved()."), (Throwable)e);
            }
        }
        if (!messageFromPeer) {
            DataDistLayerMessage message = new DataDistLayerMessage(DataDistLayerMessage.TargetAppId.INTERNAL, 7, removedData);
            this.sendMessageToOtherLeaders(message);
        }
    }

    @Override
    public List<DataDistLayerData> retrieveDataByKey(DataDistLayerDataKey key) {
        List<DataDistLayerData> data = this.retrieveDataFromMap(key);
        if (log.isFinestEnabled()) {
            log.finest((Object)("retrieveDataByKey key=" + key + " retrieved data=" + data));
        }
        return data;
    }

    @Override
    public List<DataDistLayerData> retrieveDataByMatchingKey(DataDistLayerDataKey key) {
        ArrayList<DataDistLayerData> mKeys;
        block4: {
            mKeys = new ArrayList<DataDistLayerData>();
            try {
                for (Object keyFromMap : this.dataMapByKey.keySet()) {
                    DataDistLayerDataKey ddlKey = (DataDistLayerDataKey)keyFromMap;
                    if (ddlKey.getKeyCategory() != key.getKeyCategory() || key.getKeyValue() != null && key.getKeyValue().length() != 0 && !ddlKey.getKeyValue().matches(key.getKeyValue())) continue;
                    if (log.isFinestEnabled()) {
                        log.finest((Object)(key.toString() + " matches " + ddlKey.toString()));
                    }
                    mKeys.addAll((Collection)this.dataMapByKey.get(ddlKey));
                }
            }
            catch (PatternSyntaxException ex) {
                if (!log.isFinestEnabled()) break block4;
                log.finest((Object)("GetDataByKey: Exception on Regular Expression: " + key), (Throwable)ex);
            }
        }
        return mKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DataDistLayerData> retrieveDataByHost(DataDistLayerMemberAddr addr) {
        ArrayList<DataDistLayerData> list = new ArrayList<DataDistLayerData>();
        if (addr == null) {
            log.error((Object)"retrieveDataByHost: member address is null");
            return list;
        }
        Set<Object> ownedKeys = this.hostIdKeys.get(addr);
        if (ownedKeys != null) {
            Set<Object> set = ownedKeys;
            synchronized (set) {
                for (Object ownedKey : ownedKeys) {
                    for (DataDistLayerData data : (List)this.dataMapByKey.get(ownedKey)) {
                        if (data == null || !addr.equals(data.getOwnerId())) continue;
                        list.add(data);
                    }
                }
            }
        }
        if (log.isFinestEnabled()) {
            log.finest((Object)("returning data for host " + addr + ": " + list));
        }
        return list;
    }

    @Override
    protected boolean handleNewMember(DataDistLayerMemberAddr member, String newName) {
        this.removeBlackListEntry(member);
        boolean isFullyResolved = super.handleNewMember(member, newName);
        if (isFullyResolved && this.myClusterGroup != null && this.myClusterGroup.isConnected()) {
            Object currentHostId = this.myClusterGroup.getThisHostId();
            if (this.myClusterLeaderId != null) {
                if (member.getHostId().equals(currentHostId) && !currentHostId.equals(this.myClusterLeaderId)) {
                    DataDistLayerMemberAddr oldAddr = new DataDistLayerMemberAddr(this.myClusterName, this.myClusterLeaderId);
                    DataDistLayerMemberAddr newAddr = new DataDistLayerMemberAddr(this.getMyId());
                    this.updateOwnedData(oldAddr, newAddr, false);
                    this.myClusterLeaderId = currentHostId;
                }
            } else {
                this.myClusterLeaderId = currentHostId;
                if (log.isFineEnabled()) {
                    log.fine((Object)("Leader joined the group with ID " + this.myClusterLeaderId));
                }
            }
        }
        return isFullyResolved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOwnedData(DataDistLayerMemberAddr oldHostAddr, DataDistLayerMemberAddr newHostAddr, boolean messageFromPeer) {
        if (oldHostAddr.getHostId() == null) {
            return;
        }
        if (newHostAddr.getHostId() == null) {
            log.error((Object)("updateOwnedData: Received null newHostId, oldHostId was " + oldHostAddr));
            return;
        }
        log.info((Object)("updateOwnedData: " + (messageFromPeer ? "Another " : "Our ") + "intra cluster node's Address changed from " + oldHostAddr + " to " + newHostAddr));
        List<DataDistLayerData> dataToUpdate = this.retrieveDataByHost(oldHostAddr);
        if (dataToUpdate != null) {
            try {
                this.lock.acquireWriteLock();
                newHostAddr.setIsMutable(false);
                Set<Object> prevData = this.hostIdKeys.remove(oldHostAddr);
                if (prevData != null) {
                    this.hostIdKeys.put(newHostAddr, prevData);
                }
                for (DataDistLayerData d : dataToUpdate) {
                    d.getOwnerId().setHostId(newHostAddr.getHostId());
                }
            }
            finally {
                this.lock.releaseWriteLock();
            }
            if (log.isFineEnabled()) {
                log.fine((Object)("updateOwnedData: Updated " + dataToUpdate.size() + (messageFromPeer ? "." : ".  Sending updates to other inter cluster members.")));
            }
            if (!messageFromPeer) {
                DataDistLayerMessage message = new DataDistLayerMessage(DataDistLayerMessage.TargetAppId.INTERNAL, 24, (Serializable)new DataDistLayerMemberAddr[]{oldHostAddr, newHostAddr});
                this.ddlFactory.getInterClusterMember().sendMessageToAll(message);
            }
        }
    }

    @Override
    protected void newMemberFullyResolved(DataDistLayerMemberAddr addr) {
        if (this.limboList.size() > 0) {
            this.auditLimboList();
        }
    }

    @Override
    protected void processInternalMessage(DataDistLayerMessage message, DataDistLayerMemberAddr sender) throws DDLException {
        List dataList = null;
        boolean messageFromPeer = !this.myClusterName.equals(sender.getClusterName());
        switch (message.getMessageType()) {
            case 5: {
                break;
            }
            case 12: {
                if (message.getPayload() instanceof List) {
                    this.bulkStoreData((List)((Object)message.getPayload()), messageFromPeer);
                    break;
                }
                this.storeData(sender, (DataDistLayerData)message.getPayload(), messageFromPeer);
                break;
            }
            case 7: {
                if (message.getPayload() instanceof List) {
                    this.bulkRemoveData(sender, (List)((Object)message.getPayload()), messageFromPeer);
                    break;
                }
                this.removeData(sender, (DataDistLayerData)message.getPayload(), messageFromPeer);
                break;
            }
            case 13: {
                List tempList = (List)((Object)message.getPayload());
                DataDistLayerData oldData = (DataDistLayerData)tempList.get(0);
                DataDistLayerData newData = (DataDistLayerData)tempList.get(1);
                this.updateData(sender, oldData, newData, messageFromPeer, false, false);
                break;
            }
            case 27: {
                List tempListBykey = (List)((Object)message.getPayload());
                DataDistLayerData newDataByKey = (DataDistLayerData)tempListBykey.get(0);
                dataList = (List)this.dataMapByKey.get(newDataByKey.getKey());
                this.updateDataByKey(sender, dataList != null && dataList.size() != 0 ? (DataDistLayerData)dataList.get(0) : null, newDataByKey, messageFromPeer, false, false);
                break;
            }
            case 6: {
                log.warn((Object)"Received a REMOVE_ALL_DATA message");
                this.hostIdKeys.clear();
                this.dataMapByKey.clear();
                break;
            }
            case 9: {
                DataDistLayerData data = (DataDistLayerData)message.getPayload();
                if (log.isFinestEnabled()) {
                    log.finest((Object)("Host got REMOVE_DATA_BY_KEY for key " + data.getKey()));
                }
                this.removeDataByKey(sender, (dataList = (List)this.dataMapByKey.get(data.getKey())) != null && dataList.size() != 0 ? (DataDistLayerData)dataList.get(0) : null, messageFromPeer);
                break;
            }
            case 8: {
                Serializable host = message.getPayload();
                if (log.isFinestEnabled()) {
                    log.finest((Object)("Host got REMOVE_DATA_BY_HOST for host " + host));
                }
                this.removeDataByList(sender, this.retrieveDataByHost((DataDistLayerMemberAddr)host));
                break;
            }
            case 24: {
                DataDistLayerMemberAddr[] oldNewAddr = (DataDistLayerMemberAddr[])message.getPayload();
                if (oldNewAddr.length != 2) {
                    log.error((Object)("Incorrect size of message array for: " + message));
                    break;
                }
                this.updateOwnedData(oldNewAddr[0], oldNewAddr[1], true);
                break;
            }
            default: {
                super.processInternalMessage(message, sender);
            }
        }
    }

    @Override
    public void sendMessage(DataDistLayerMemberAddr member, DataDistLayerMessage message) throws DDLException {
        DDLMessageSender.sendMessage(member, message, true);
    }

    @Override
    public Object queryHost(DataDistLayerMemberAddr member, DataDistLayerMessage message, int timeout) {
        return DDLMessageSender.queryHost(member, message, timeout, true);
    }

    private Collection<DataDistLayerMemberAddr> getRedundantAddrs(Long userCommId) {
        if (this.redundancyHandler == null) {
            log.warn((Object)"No redundant member specified.");
            return null;
        }
        Collection<DataDistLayerMemberAddr> otherAddrs = this.redundancyHandler.getRedundantMemberAddrs(userCommId);
        if (otherAddrs == null) {
            otherAddrs = this.redundancyHandler.getRedundantMemberAddrs(this.getMyId());
        }
        return otherAddrs;
    }

    protected void sendMessageToOtherLeaders(DataDistLayerMessage message) {
        try {
            HashMap<DataDistLayerMemberAddr, Serializable> redundancyMap = new HashMap<DataDistLayerMemberAddr, Serializable>();
            if (message.getPayload() instanceof DataDistLayerData) {
                Long userCommId = ((DataDistLayerData)message.getPayload()).getUserCommId();
                Collection<DataDistLayerMemberAddr> redundantAddrs = this.getRedundantAddrs(userCommId);
                if (redundantAddrs != null) {
                    for (DataDistLayerMemberAddr redundantAddr : redundantAddrs) {
                        if (redundantAddr.getHostId() == null) continue;
                        if (log.isFinestEnabled()) {
                            log.finest((Object)("sendMessageToOtherLeaders: Determined redundant member is " + redundantAddr + ", userCommId=" + userCommId));
                        }
                        redundancyMap.put(redundantAddr, (DataDistLayerData)message.getPayload());
                    }
                }
            } else if (message.getPayload() instanceof List) {
                List dataList = (List)((Object)message.getPayload());
                for (DataDistLayerData data : dataList) {
                    Collection<DataDistLayerMemberAddr> redundantAddrs = this.getRedundantAddrs(data.getUserCommId());
                    if (redundantAddrs == null) continue;
                    for (DataDistLayerMemberAddr redundantAddr : redundantAddrs) {
                        if (redundantAddr.getHostId() == null) continue;
                        ArrayList<DataDistLayerData> curList = (ArrayList<DataDistLayerData>)redundancyMap.get(redundantAddr);
                        if (curList == null) {
                            curList = new ArrayList<DataDistLayerData>();
                            redundancyMap.put(redundantAddr, curList);
                            if (log.isFinestEnabled()) {
                                log.finest((Object)("sendMessageToOtherLeaders: Determined redundant member is " + redundantAddr + ", userCommId=" + data.getUserCommId()));
                            }
                        }
                        curList.add(data);
                    }
                }
            }
            for (DataDistLayerMemberAddr otherAddr : redundancyMap.keySet()) {
                message.setPayload((Serializable)redundancyMap.get(otherAddr));
                if (otherAddr != null && otherAddr.getHostId() != null) {
                    if (log.isFinerEnabled()) {
                        log.finer((Object)("sendMessageToOtherLeaders: Sending message to redundant member " + otherAddr + ": " + message));
                    }
                    this.sendMessage(otherAddr, message);
                    continue;
                }
                if (!log.isFineEnabled()) continue;
                log.fine((Object)"sendMessageToOtherLeaders: We seem to know about a redundant member, but they are shown as being down or unavailable.");
            }
        }
        catch (Exception e) {
            log.error((Object)"sendMessageToOtherLeaders: Caught exception trying to send to other community leader.", (Throwable)e);
        }
    }

    public void removeBlackListEntry(DataDistLayerMemberAddr member) {
        try {
            String removeIp = member.getIpAddress();
            if (removeIp != null) {
                IPAddress removeIpAddr = IPAddress.parseIPAddr(removeIp);
                DataDistLayerMemberAddr removed = this.blackList.remove(removeIpAddr);
                if (log.isFinestEnabled()) {
                    log.finest((Object)("Removed " + removed + " for (" + removeIp + ") from the black list, now contains: " + this.blackList));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to remove blacklist member: ", (Throwable)e);
        }
    }

    private boolean rejectBlackListedMember(DataDistLayerData data) {
        String ownerIp;
        boolean ret = false;
        if (!this.hostIdKeys.containsKey(data.getOwnerId()) && (ownerIp = data.getOwnerId().getIpAddress()) != null) {
            try {
                IPAddress ownerIpAddr = IPAddress.parseIPAddr(ownerIp);
                DataDistLayerMemberAddr rejectAddr = this.blackList.get(ownerIpAddr);
                if (rejectAddr != null && rejectAddr.equals(data.getOwnerId())) {
                    ret = true;
                }
            }
            catch (Exception e) {
                log.error((Object)("rejectBlackListedMember: bad ownerIp: " + ownerIp));
                ret = true;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClusterData(String clusterName) {
        if (this.myClusterName.equals(clusterName)) {
            log.warn((Object)("Ignored attempt to remove all data for cluster " + clusterName));
            return;
        }
        if (log.isFineEnabled()) {
            log.fine((Object)("removeClusterData: " + clusterName));
        }
        ArrayList<DataDistLayerMemberAddr> lostMembers = new ArrayList<DataDistLayerMemberAddr>();
        Set<DataDistLayerMemberAddr> keySet = this.hostIdKeys.keySet();
        if (keySet != null) {
            Set<DataDistLayerMemberAddr> set = keySet;
            synchronized (set) {
                for (DataDistLayerMemberAddr member : keySet) {
                    if (this.myClusterName.equals(member.getClusterName()) || clusterName != null && !clusterName.equals(member.getClusterName())) continue;
                    lostMembers.add(member);
                }
            }
        }
        for (DataDistLayerMemberAddr member : lostMembers) {
            member.setMemberType("WAS-SM");
            this.handleDroppedMember(member);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void generateBulkStore(DataDistLayerMemberAddr newInterMember) {
        if (this.redundancyHandler.isMemberRedundantToUs(newInterMember)) {
            List<DataDistLayerMemberAddr> members = this.getMembers();
            try {
                this.lock.acquireWriteLock();
                if (log.isFineEnabled()) {
                    log.fine((Object)("generateBulkStore: The inter cluster member that just joined needs all our data, send a bulk store to " + newInterMember));
                }
                for (DataDistLayerMemberAddr member : members) {
                    List<DataDistLayerData> bulkStoreData = this.retrieveDataByHost(member);
                    if (bulkStoreData.size() <= 0) continue;
                    ArrayList<DataDistLayerData> filteredList = new ArrayList<DataDistLayerData>();
                    for (DataDistLayerData redunData : bulkStoreData) {
                        Collection<DataDistLayerMemberAddr> redundantAddrs = this.getRedundantAddrs(redunData.getUserCommId());
                        if (redundantAddrs == null || !redundantAddrs.contains(newInterMember)) continue;
                        filteredList.add(redunData);
                    }
                    DataDistLayerMessage message = new DataDistLayerMessage(DataDistLayerMessage.TargetAppId.INTERNAL, 12, filteredList);
                    this.sendMessageToOtherLeaders(message);
                }
                if (!log.isFineEnabled()) return;
                log.fine((Object)("generateBulkStore: Completed sending bulk store to " + newInterMember));
                return;
            }
            finally {
                this.lock.releaseWriteLock();
            }
        } else {
            if (!log.isFineEnabled()) return;
            log.fine((Object)"generateBulkStore: The inter cluster member that just joined does not need our data, ignoring.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    protected void handleDroppedMember(DataDistLayerMemberAddr member) {
        try {
            void var6_15;
            this.lock.acquireWriteLock();
            List<DataDistLayerData> dataList = this.retrieveDataByHost(member);
            String droppedIp = member.getClusterName();
            Map<DataDistLayerMemberAddr, Set<Object>> map = this.hostIdKeys;
            synchronized (map) {
                for (DataDistLayerMemberAddr dataDistLayerMemberAddr : this.hostIdKeys.keySet()) {
                    if (droppedIp == null || !droppedIp.equals(dataDistLayerMemberAddr.getClusterName())) continue;
                    try {
                        IPAddress droppedIpAddr = IPAddress.parseIPAddr(droppedIp);
                        this.blackList.put(droppedIpAddr, dataDistLayerMemberAddr);
                        if (!log.isFinestEnabled()) continue;
                        log.finest((Object)("Added entry for (" + droppedIp + ") to the black list, now contains: " + this.blackList));
                    }
                    catch (ParseException e) {
                        log.error((Object)("handleDroppedMember: bad droppedIp: " + droppedIp));
                    }
                }
            }
            int listSize = 0;
            ArrayList<DataDistLayerDataKey.Category> categoryList = new ArrayList<DataDistLayerDataKey.Category>();
            if (member.getMemberType() != null) {
                for (DDLRetention retention : this.retentionList) {
                    if (!member.getMemberType().equals(retention.getMemberName())) continue;
                    categoryList.add(retention.getCategory());
                }
            }
            List<DataDistLayerData> list = dataList;
            synchronized (list) {
                listSize = dataList.size();
                for (DataDistLayerData data : dataList) {
                    if (!categoryList.contains((Object)data.getKey().getKeyCategory())) continue;
                    if (!this.limboList.containsKey(member)) {
                        this.limboList.put(member, new ArrayList());
                    }
                    ((List)this.limboList.get(member)).add(data);
                }
            }
            this.bulkRemoveData(member, dataList, true);
            this.hostIdKeys.remove(member);
            if (this.limboList.size() > 0) {
                List list2 = this.myClusterMembers;
                synchronized (list2) {
                    this.limboListBuilt.put(member.getMemberType(), true);
                }
                this.auditLimboList();
            }
            String string = "Departure of " + member.toString() + " resulted in deletion of " + listSize + " data entries.";
            if (this.limboList.containsKey(member)) {
                String string2 = string + " " + ((List)this.limboList.get(member)).size() + " entries were retained for Limbo List processing due to rules saving data of type(s) " + categoryList + " for members of type " + member.getMemberType();
            }
            if (listSize > 0) {
                log.info((Object)var6_15);
            } else if (log.isFinerEnabled()) {
                log.finer((Object)var6_15);
            }
        }
        finally {
            this.lock.releaseWriteLock();
        }
        super.handleDroppedMember(member);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void auditLimboList() {
        if (log.isFinerEnabled()) {
            log.finer((Object)("Limbo List contains the following keys: " + this.limboList.keySet() + ".  Limbo List built=" + this.limboListBuilt));
        }
        for (Map.Entry entry : this.limboList.entrySet()) {
            List list = this.myClusterMembers;
            synchronized (list) {
                for (DataDistLayerMemberAddr member : this.myClusterMembers) {
                    if (member.getMemberType() == null || !member.getMemberType().equals(((DataDistLayerMemberAddr)entry.getKey()).getMemberType()) || this.limboListBuilt.get(member.getMemberType()) == null || !((Boolean)this.limboListBuilt.get(member.getMemberType())).booleanValue()) continue;
                    try {
                        AbstractMap.SimpleEntry simpleEntry = new AbstractMap.SimpleEntry(entry.getKey(), entry.getValue());
                        DataDistLayerMessage message = new DataDistLayerMessage(DataDistLayerMessage.TargetAppId.LIMBO_HANDLER, 22, simpleEntry);
                        if (this.getMyId().equals(member)) {
                            if (log.isFineEnabled()) {
                                log.fine((Object)("Processing Limbo List entry with key " + entry.getKey()));
                            }
                            this.sendMessage(member, message);
                        } else {
                            if (log.isFineEnabled()) {
                                log.fine((Object)("Sending Limbo List entry with key " + entry.getKey() + " to " + member));
                            }
                            this.sendMessage(member, message);
                        }
                        this.limboList.remove(entry.getKey());
                    }
                    catch (DDLException e) {
                        log.error((Object)("Failed to send PROCESS_LIMBO_ENTRY to " + member + " for processing of limbo list entry for member " + entry.getKey()));
                    }
                    this.limboListBuilt.put(member.getMemberType(), false);
                }
            }
        }
    }

    private void removeDataByList(DataDistLayerMemberAddr sender, List<DataDistLayerData> dataList) {
        if (dataList != null) {
            ArrayList<DataDistLayerData> dataListCopy = new ArrayList<DataDistLayerData>(dataList);
            this.bulkRemoveData(sender, dataListCopy, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDataToList(Object dataKey, DataDistLayerData data) {
        try {
            Object object;
            CopyOnWriteArrayList<DataDistLayerData> newEntry;
            this.lock.acquireReadLock();
            if (this.rejectBlackListedMember(data)) {
                log.warn((Object)("Rejected message from recently dropped member: " + data));
                return;
            }
            List<DataDistLayerData> mapEntry = (CopyOnWriteArrayList<DataDistLayerData>)this.dataMapByKey.get(dataKey);
            if (mapEntry == null && (mapEntry = (List)this.dataMapByKey.putIfAbsent(dataKey, newEntry = new CopyOnWriteArrayList<DataDistLayerData>())) == null) {
                mapEntry = newEntry;
            }
            newEntry = mapEntry;
            synchronized (newEntry) {
                if (mapEntry.contains(data)) {
                    if (log.isFinerEnabled()) {
                        log.finer((Object)("Blocked attempt to store duplicate data " + data));
                    }
                } else {
                    mapEntry.add(data);
                }
            }
            Set<Object> ownedKeys = this.hostIdKeys.get(data.getOwnerId());
            if (ownedKeys == null) {
                object = this.hostIdKeys;
                synchronized (object) {
                    ownedKeys = this.hostIdKeys.get(data.getOwnerId());
                    if (ownedKeys == null) {
                        ownedKeys = new HashSet<Object>();
                        DataDistLayerMemberAddr addr = new DataDistLayerMemberAddr(data.getOwnerId().getClusterName(), data.getOwnerId().getHostId());
                        addr.setIsMutable(false);
                        this.hostIdKeys.put(addr, ownedKeys);
                    }
                }
            }
            object = ownedKeys;
            synchronized (object) {
                ownedKeys.add(dataKey);
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDataFromList(Object dataKey, DataDistLayerData data) {
        block19: {
            try {
                Set<Object> ownedKeys;
                this.lock.acquireWriteLock();
                List mapEntry = (List)this.dataMapByKey.get(dataKey);
                if (mapEntry != null) {
                    List list = mapEntry;
                    synchronized (list) {
                        if (mapEntry.remove(data) && log.isFinestEnabled()) {
                            log.finest((Object)("DataDistCluster leader removed data: " + data.toString() + " from dataMapByKey"));
                        }
                    }
                    if (mapEntry.isEmpty()) {
                        this.dataMapByKey.remove(dataKey);
                    }
                }
                if ((ownedKeys = this.hostIdKeys.get(data.getOwnerId())) == null) {
                    log.warn((Object)("removeDataFromList: Told to remove data owned by " + data.getOwnerId() + ", hostIdKeys didn't have a record for the address."));
                    break block19;
                }
                Set<Object> set = ownedKeys;
                synchronized (set) {
                    boolean shouldRem = true;
                    if (mapEntry != null) {
                        List list = mapEntry;
                        synchronized (list) {
                            for (DataDistLayerData tmpData : mapEntry) {
                                if (!tmpData.getOwnerId().equals(data.getOwnerId())) continue;
                                shouldRem = false;
                                break;
                            }
                        }
                    }
                    if (shouldRem) {
                        ownedKeys.remove(dataKey);
                    }
                }
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDataInList(Object dataKey, DataDistLayerData oldData, DataDistLayerData newData) {
        block11: {
            try {
                this.lock.acquireReadLock();
                List mapEntry = (List)this.dataMapByKey.get(dataKey);
                String oldDataCluster = oldData == null ? null : oldData.getOwnerId().getClusterName();
                String newDataCluster = newData.getOwnerId().getClusterName();
                if (mapEntry != null && newDataCluster.equals(oldDataCluster)) {
                    List list = mapEntry;
                    synchronized (list) {
                        if (oldData != null && !mapEntry.remove(oldData) && log.isFinestEnabled()) {
                            log.finest((Object)("updateData() failed to remove old data: " + oldData.toString()));
                            log.finest((Object)("updateData(" + oldData.getKey() + ") contains " + mapEntry.size() + " elements; first is " + ((DataDistLayerData)mapEntry.get(0)).toString()));
                        }
                        mapEntry.add(newData);
                        break block11;
                    }
                }
                if (mapEntry == null) {
                    log.warn((Object)("updateData(" + (oldData == null ? null : oldData.toString()) + ") mapEntry is null, cannot update. Will store instead"));
                } else if (log.isFinerEnabled()) {
                    log.finer((Object)("updateData: Owning members of old and new data are not in the same cluster, we will store the newData.  oldData=" + oldData + ", newData=" + newData));
                }
                this.addDataToList(dataKey, newData);
            }
            finally {
                this.lock.releaseReadLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDataInList(DataDistLayerData newData) {
        block9: {
            try {
                this.lock.acquireReadLock();
                List mapEntry = (List)this.dataMapByKey.get(newData.getKey());
                if (mapEntry != null) {
                    List list = mapEntry;
                    synchronized (list) {
                        if (!mapEntry.remove(newData) && log.isFinestEnabled()) {
                            log.finest((Object)("updateData() failed to remove old data: " + newData.toString()));
                            log.finest((Object)("updateData(" + newData.getKey() + ") contains " + mapEntry.size() + " elements; first is " + ((DataDistLayerData)mapEntry.get(0)).toString()));
                        }
                        mapEntry.add(newData);
                        break block9;
                    }
                }
                if (mapEntry == null) {
                    log.warn((Object)("updateData(" + newData.toString() + ") mapEntry is null, cannot update. Will store instead"));
                }
                this.addDataToList(newData.getKey(), newData);
            }
            finally {
                this.lock.releaseReadLock();
            }
        }
    }

    public void clearRedundancyCache() {
        this.redundancyHandler.clearRedundancyCache();
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    protected void clearBlackList() {
        if (log.isFineEnabled()) {
            log.fine((Object)"Clearing the black list now.");
        }
        this.blackList.clear();
    }
}

