/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.helpers;

import com.avaya.asm.core.AsmLogger;
import com.avaya.common.logging.client.Logger;
import com.avaya.ustore.AADSVersionChecker;
import com.avaya.ustore.SMVersionChecker;

public class ContactHelper {
    private static final Logger log = AsmLogger.getLogger(ContactHelper.class);
    private static ContactHelper contactHelper = null;
    protected SMVersionChecker smVersionChecker = new SMVersionChecker("8.1.11");
    protected AADSVersionChecker aadsVersionChecker = new AADSVersionChecker();
    private static Object mutex = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContactHelper getInstance() {
        ContactHelper tmp = contactHelper;
        if (tmp == null) {
            Object object = mutex;
            synchronized (object) {
                tmp = contactHelper;
                if (tmp == null) {
                    tmp = new ContactHelper();
                }
                contactHelper = tmp;
            }
        }
        return tmp;
    }

    protected ContactHelper() {
    }

    public boolean storeContactsInGlobalUserDCKeyspace() {
        String fcn_name = "storeContactsInGlobalUserDCKeyspace";
        boolean isFiner = log.isFinerEnabled();
        if (isFiner) {
            log.finer((Object)"storeContactsInGlobalUserDCKeyspace: enter ");
        }
        Boolean checkMinimumAADSVersions = this.aadsVersionChecker.checkMinimumAADSVersions();
        Boolean checkMinimumSMVersions = this.smVersionChecker.checkMinimumSMVersions();
        boolean storeContactsInGlobalUserDCKeyspace = false;
        if (Boolean.TRUE.equals(checkMinimumSMVersions) && Boolean.TRUE.equals(checkMinimumAADSVersions)) {
            storeContactsInGlobalUserDCKeyspace = true;
        }
        if (isFiner) {
            log.finer((Object)("storeContactsInGlobalUserDCKeyspace : Leave, storeContactsInGlobalUserDCKeyspace : " + storeContactsInGlobalUserDCKeyspace));
        }
        return storeContactsInGlobalUserDCKeyspace;
    }
}

