/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.helpers;

import com.avaya.asm.core.AsmLogger;
import com.avaya.common.logging.client.Logger;

public class EnvVarUtils {
    private static final Logger log = AsmLogger.getLogger(EnvVarUtils.class);

    public static Integer getEnvInteger(String name, Integer dfltValue) {
        String value = System.getenv(name);
        if (value == null) {
            return dfltValue;
        }
        Integer ivalue = null;
        try {
            ivalue = Integer.decode(value);
        }
        catch (NumberFormatException e) {
            log.error((Object)("getEnvInteger: NumberFormatException thrown retrieving " + name + ", value=" + value));
            return dfltValue;
        }
        return ivalue;
    }

    public static Boolean getEnvBoolean(String name, Boolean dfltValue) {
        String value = System.getenv(name);
        if (value == null) {
            return dfltValue;
        }
        Boolean ivalue = Boolean.valueOf(value);
        return ivalue;
    }

    public static String getEnvString(String name, String dfltValue) {
        String value = System.getenv(name);
        if (value == null) {
            return dfltValue;
        }
        return value;
    }
}

