/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.objectapi;

import com.avaya.asm.datamgr.objectapi.DigitMapRow;
import com.avaya.asm.datamgr.objectapi.DigitTreeNodeMatcher;
import com.avaya.asm.datamgr.objectapi.DigitTreeObjectNode;
import com.avaya.asm.datamgr.objectapi.DigitTreeObjectNodeMatch;

public class DigitMapRouterMatcher
extends DigitTreeNodeMatcher<DigitMapRow> {
    private final DigitMapRow row;

    public DigitMapRouterMatcher(DigitMapRow row) {
        this.row = row;
    }

    @Override
    public boolean matches(DigitMapRow treeRow) {
        return this.row == null || this.row.getId() == treeRow.getId();
    }

    @Override
    public boolean allowInsertion(DigitTreeObjectNode<DigitMapRow> node, String digits, short min, short max, DigitMapRow object) {
        short nodeMin = node.getMinimumDigits();
        short nodeMax = node.getMaximumDigits();
        return !(min >= nodeMin && min <= nodeMax || max >= nodeMin && max <= nodeMax || nodeMin >= min && nodeMin <= max) && (nodeMax < min || nodeMax > max) || object.isRange() || node.getObject().isRange();
    }

    @Override
    public DigitTreeObjectNodeMatch<DigitMapRow> pickBetterMatch(DigitTreeObjectNodeMatch<DigitMapRow> match1, DigitTreeObjectNodeMatch<DigitMapRow> match2) {
        if (match2 == null) {
            return match1;
        }
        if (match1 == null) {
            return match2;
        }
        DigitMapRow row1 = match1.getNode().getObject();
        DigitMapRow row2 = match2.getNode().getObject();
        if (row1.isRange() || row2.isRange()) {
            return row1.compareWidth(row2) <= 0 ? match1 : match2;
        }
        if (match1.getDepth() > match2.getDepth()) {
            return match1;
        }
        if (match1.getDepth() < match2.getDepth()) {
            return match2;
        }
        return match1;
    }
}

