/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.objectapi;

import com.avaya.asm.datamgr.objectapi.DigitPattern;
import java.util.List;

public class DigitMapRow {
    private final long id;
    private final DigitPattern pattern;
    private final Long sipDomainId;
    private final boolean deny;
    private final Long routingOrigId;
    private final Long origPatternSetId;
    private final boolean treatAsEmergency;

    public DigitMapRow(long id, short min, short max, String digits, boolean deny, Long routingOrigId, Long sipDomainId, Long origPatternSetId, boolean treatAsEmergency) {
        this.id = id;
        this.pattern = new DigitPattern(min, max, digits);
        this.deny = deny;
        this.routingOrigId = routingOrigId;
        this.sipDomainId = sipDomainId;
        this.origPatternSetId = origPatternSetId;
        this.treatAsEmergency = treatAsEmergency;
    }

    public DigitMapRow(short length, String digits, DigitMapRow row) {
        this(row.getId(), length, length, digits, row.deny, row.routingOrigId, row.getSipDomainId(), row.origPatternSetId, row.treatAsEmergency);
    }

    public DigitMapRow(DigitPattern pattern, DigitMapRow row) {
        this.id = row.id;
        this.pattern = pattern;
        this.deny = row.deny;
        this.routingOrigId = row.routingOrigId;
        this.sipDomainId = row.sipDomainId;
        this.origPatternSetId = row.origPatternSetId;
        this.treatAsEmergency = row.treatAsEmergency;
    }

    public long getId() {
        return this.id;
    }

    public boolean getDeny() {
        return this.deny;
    }

    public boolean getTreatAsEmergency() {
        return this.treatAsEmergency;
    }

    public Long getSipDomainId() {
        return this.sipDomainId;
    }

    public Long getRoutingOrigId() {
        return this.routingOrigId;
    }

    public Long getOrigPatternSetId() {
        return this.origPatternSetId;
    }

    public boolean isRange() {
        return this.pattern.isRange();
    }

    public int compareWidth(DigitMapRow row) {
        return this.pattern.compareWidth(row.pattern);
    }

    public DigitPattern getPattern() {
        return this.pattern;
    }

    public List<DigitPattern> getDigitPatterns() {
        return this.pattern.getSubPatterns();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DigitMapRow)) {
            return false;
        }
        DigitMapRow other = (DigitMapRow)object;
        if (!this.pattern.equals(other.pattern)) {
            return false;
        }
        if (this.routingOrigId != null && !this.routingOrigId.equals(other.routingOrigId) || this.routingOrigId == null && other.routingOrigId != null) {
            return false;
        }
        if (this.sipDomainId != null && !this.sipDomainId.equals(other.sipDomainId) || this.sipDomainId == null && other.sipDomainId != null) {
            return false;
        }
        return (this.origPatternSetId == null || this.origPatternSetId.equals(other.origPatternSetId)) && (this.origPatternSetId != null || other.origPatternSetId == null);
    }

    public int hashCode() {
        int hash = 23;
        hash = hash * 37 + this.pattern.hashCode();
        hash = hash * 37 + (this.routingOrigId == null ? 0 : (int)(this.routingOrigId ^ this.routingOrigId >>> 32));
        hash = hash * 37 + (this.sipDomainId == null ? 0 : (int)(this.sipDomainId ^ this.sipDomainId >>> 32));
        hash = hash * 37 + (this.origPatternSetId == null ? 0 : (int)(this.origPatternSetId ^ this.origPatternSetId >>> 32));
        return hash;
    }

    public String toString() {
        return this.pattern.toString();
    }
}

