/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.objectapi;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.datamgr.objectapi.EntityLink;
import com.avaya.asm.datamgr.objectapi.IPAddress;
import com.avaya.common.logging.client.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class EntityLinkTable
implements Serializable {
    private static final long serialVersionUID = -7696450494125538242L;
    private static final Logger log = AsmLogger.getLogger(EntityLinkTable.class);
    private final long myEntityId;
    protected Map<Long, Map<String, Map<EntityLink.IPAddrFamily, EntityLink>>> entityProtocolHashMap = new HashMap<Long, Map<String, Map<EntityLink.IPAddrFamily, EntityLink>>>();
    protected Map<String, Map<Integer, List<EntityLink>>> protocolPortHashMap = new HashMap<String, Map<Integer, List<EntityLink>>>();

    public EntityLinkTable(Long myEntityId) {
        this.myEntityId = myEntityId == null ? -1L : myEntityId;
    }

    public long getMyEntityId() {
        return this.myEntityId;
    }

    public synchronized boolean addEntityLink(EntityLink entityLink) {
        Map<Object, Object> portMap;
        Long farend_id = null;
        boolean reverse = false;
        if (this.myEntityId == -1L) {
            log.error((Object)"addEntityLink: MyEntity ID has not been determined.  Cannot add an entity link now.");
            return false;
        }
        if (entityLink.getEntity1_id() == this.myEntityId) {
            farend_id = entityLink.entity2_id;
        }
        if (entityLink.getEntity2_id() == this.myEntityId) {
            reverse = true;
            farend_id = entityLink.entity1_id;
        }
        if (farend_id == null) {
            log.warn((Object)("Blocked attempt to add invalid EntityLink between " + entityLink.getEntity1_id() + " and " + entityLink.getEntity2_id() + " to EntityLinkTable for entity " + this.myEntityId));
            return false;
        }
        if (reverse) {
            long temp1 = entityLink.getEntity1_id();
            entityLink.setEntity1_id(entityLink.getEntity2_id());
            entityLink.setEntity2_id(temp1);
            int temp2 = entityLink.getListenportentity1();
            entityLink.setListenportentity1(entityLink.getListenportentity2());
            entityLink.setListenportentity2(temp2);
        }
        String protocol = entityLink.getTransportProtocol();
        Integer port = entityLink.getListenportentity1();
        EntityLink.IPAddrFamily ipAddrFamily = entityLink.getIPAddrFamily();
        if (this.entityProtocolHashMap.containsKey(farend_id)) {
            Map<String, Map<EntityLink.IPAddrFamily, EntityLink>> protocolIpAddrFamMap = this.entityProtocolHashMap.get(farend_id);
            Map<EntityLink.IPAddrFamily, EntityLink> beingReplacedIpAddrELMap = protocolIpAddrFamMap.get(entityLink.getTransportProtocol());
            if (beingReplacedIpAddrELMap != null) {
                EntityLink beingReplacedEL = beingReplacedIpAddrELMap.get((Object)ipAddrFamily);
                if (beingReplacedEL != null) {
                    entityLink.setExplicitBiDirectionalId(beingReplacedEL.getId());
                }
                beingReplacedIpAddrELMap.put(ipAddrFamily, entityLink);
                protocolIpAddrFamMap.put(protocol, beingReplacedIpAddrELMap);
            } else {
                beingReplacedIpAddrELMap = new HashMap<EntityLink.IPAddrFamily, EntityLink>();
                beingReplacedIpAddrELMap.put(ipAddrFamily, entityLink);
                protocolIpAddrFamMap.put(protocol, beingReplacedIpAddrELMap);
                this.entityProtocolHashMap.put(farend_id, protocolIpAddrFamMap);
            }
        } else {
            HashMap<EntityLink.IPAddrFamily, EntityLink> newIpAddrELMap = new HashMap<EntityLink.IPAddrFamily, EntityLink>();
            newIpAddrELMap.put(ipAddrFamily, entityLink);
            HashMap<String, HashMap<EntityLink.IPAddrFamily, EntityLink>> newProtocolIpAddrFamMap = new HashMap<String, HashMap<EntityLink.IPAddrFamily, EntityLink>>();
            newProtocolIpAddrFamMap.put(protocol, newIpAddrELMap);
            this.entityProtocolHashMap.put(farend_id, newProtocolIpAddrFamMap);
        }
        if (this.protocolPortHashMap.containsKey(protocol)) {
            portMap = this.protocolPortHashMap.get(protocol);
        } else {
            portMap = new HashMap();
            this.protocolPortHashMap.put(protocol, portMap);
        }
        if (!portMap.containsKey(port)) {
            portMap.put(port, new ArrayList());
        }
        ((List)portMap.get(port)).add(entityLink);
        return true;
    }

    public synchronized void removeEntityLink(EntityLink entityLink) {
        if (entityLink != null) {
            Map<String, Map<EntityLink.IPAddrFamily, EntityLink>> protocolIpAddrFamMap;
            boolean flip;
            Long entityId = entityLink.getEntity2_id();
            String protocol = entityLink.getTransportProtocol();
            Integer port = entityLink.getListenportentity1();
            boolean bl = flip = entityId == this.myEntityId;
            if (flip) {
                entityId = entityLink.getEntity1_id();
                port = entityLink.getListenportentity2();
            }
            if ((protocolIpAddrFamMap = this.entityProtocolHashMap.get(entityId)) == null) {
                return;
            }
            Map<EntityLink.IPAddrFamily, EntityLink> ipAddrFamMap = protocolIpAddrFamMap.get(protocol);
            if (protocolIpAddrFamMap == null || ipAddrFamMap == null || !ipAddrFamMap.containsValue(entityLink)) {
                return;
            }
            boolean actuallyRemove = true;
            EntityLink.IPAddrFamily ipAddrFamily = entityLink.getIPAddrFamily();
            EntityLink remEntLink = ipAddrFamMap.get((Object)ipAddrFamily);
            Long explicitBiDirectionalId = remEntLink.getExplicitBiDirectionalId();
            if (explicitBiDirectionalId != null) {
                actuallyRemove = false;
                remEntLink.setExplicitBiDirectionalId(null);
                remEntLink.setId(explicitBiDirectionalId);
            } else {
                ipAddrFamMap.remove((Object)ipAddrFamily);
                if (ipAddrFamMap.isEmpty()) {
                    protocolIpAddrFamMap.remove(protocol);
                }
            }
            if (protocolIpAddrFamMap.isEmpty()) {
                this.entityProtocolHashMap.remove(entityId);
            }
            Map<Integer, List<EntityLink>> portMap = this.protocolPortHashMap.get(protocol);
            List<EntityLink> list = portMap.get(port);
            if (actuallyRemove) {
                list.remove(entityLink);
            }
            if (list.isEmpty()) {
                portMap.remove(port);
            }
            if (portMap.isEmpty()) {
                this.protocolPortHashMap.remove(protocol);
            }
        }
    }

    public EntityLink getEntityLink(Long entity_id, String transportProtocol, IPAddress.IPAddressFamily ipAddressFamily) {
        Map<String, Map<EntityLink.IPAddrFamily, EntityLink>> map = this.entityProtocolHashMap.get(entity_id);
        if (map == null) {
            return null;
        }
        String protocol = null;
        if (transportProtocol != null) {
            protocol = transportProtocol.toUpperCase();
        }
        EntityLink.IPAddrFamily ipAddressFamilyStr = this.getIPAddrFamily(ipAddressFamily);
        Map<EntityLink.IPAddrFamily, EntityLink> ipAddressFamELMap = map.get(protocol);
        if (ipAddressFamELMap != null) {
            return ipAddressFamELMap.get((Object)ipAddressFamilyStr);
        }
        return null;
    }

    private EntityLink.IPAddrFamily getIPAddrFamily(IPAddress.IPAddressFamily ipAddressFamily) {
        if (ipAddressFamily == IPAddress.IPAddressFamily.IPV6) {
            return EntityLink.IPAddrFamily.IPv6;
        }
        return EntityLink.IPAddrFamily.IPv4;
    }

    public List<EntityLink> getEntityLinks(Long entity_id) {
        ArrayList<EntityLink> list = new ArrayList<EntityLink>();
        Map<String, Map<EntityLink.IPAddrFamily, EntityLink>> map = this.entityProtocolHashMap.get(entity_id);
        if (map != null) {
            for (Map<EntityLink.IPAddrFamily, EntityLink> entry : map.values()) {
                list.addAll(entry.values());
            }
        }
        return list;
    }

    public List<EntityLink> getEntityLinks(String transportProtocol) {
        Map<Integer, List<EntityLink>> map;
        ArrayList<EntityLink> list = new ArrayList<EntityLink>();
        String protocol = null;
        if (transportProtocol != null) {
            protocol = transportProtocol.toUpperCase();
        }
        if ((map = this.protocolPortHashMap.get(protocol)) != null) {
            Iterator<List<EntityLink>> iterator = map.values().iterator();
            while (iterator.hasNext()) {
                list.addAll((Collection<EntityLink>)iterator.next());
            }
        }
        return list;
    }

    public List<EntityLink> getEntityLinks(String transportProtocol, Integer listenPort) {
        Map<Integer, List<EntityLink>> map;
        ArrayList<EntityLink> list = new ArrayList<EntityLink>();
        String protocol = null;
        if (transportProtocol != null) {
            protocol = transportProtocol.toUpperCase();
        }
        if ((map = this.protocolPortHashMap.get(protocol)) != null && map.containsKey(listenPort)) {
            list.addAll((Collection<EntityLink>)map.get(listenPort));
        }
        return list;
    }

    public List<Long> getFarEndEntities() {
        ArrayList<Long> list = new ArrayList<Long>();
        list.addAll(this.entityProtocolHashMap.keySet());
        return list;
    }

    public List<String> getTransportProtocols(Long entity_id) {
        ArrayList<String> list = new ArrayList<String>();
        Map<String, Map<EntityLink.IPAddrFamily, EntityLink>> map = this.entityProtocolHashMap.get(entity_id);
        if (map != null) {
            list.addAll(map.keySet());
        }
        return list;
    }

    public int getSize() {
        if (this.entityProtocolHashMap.size() == 0) {
            return 0;
        }
        int size = 0;
        for (Map<String, Map<EntityLink.IPAddrFamily, EntityLink>> protocolIpAddFamMap : this.entityProtocolHashMap.values()) {
            for (Map<EntityLink.IPAddrFamily, EntityLink> ipAddrFamMap : protocolIpAddFamMap.values()) {
                size += ipAddrFamMap.size();
            }
        }
        return size;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("EntityLinks to ");
        result.append(this.myEntityId);
        result.append(":\n");
        for (Map<String, Map<EntityLink.IPAddrFamily, EntityLink>> protocolIpAddFamMap : this.entityProtocolHashMap.values()) {
            for (Map<EntityLink.IPAddrFamily, EntityLink> ipAddrFamMap : protocolIpAddFamMap.values()) {
                for (EntityLink link : ipAddrFamMap.values()) {
                    result.append(link.toString());
                    result.append("\n");
                }
            }
        }
        return result.toString();
    }
}

