/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.objectapi;

import java.io.Serializable;
import java.text.SimpleDateFormat;

public class MonitorTransition<E extends Enum<E>>
implements Serializable {
    private static final long serialVersionUID = -4616766975709066524L;
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private final E status;
    private final long time;
    private final String reason;

    public MonitorTransition(E status, long time, String reason) {
        this.status = status;
        this.time = time;
        this.reason = reason;
    }

    public E getStatus() {
        return this.status;
    }

    public long getTime() {
        return this.time;
    }

    public String getReason() {
        return this.reason;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFormattedTime() {
        SimpleDateFormat simpleDateFormat = DATE_FORMAT;
        synchronized (simpleDateFormat) {
            return DATE_FORMAT.format(this.time);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.status + " at " + this.getFormattedTime());
        if (this.reason != null) {
            builder.append(" \"" + this.reason + "\"");
        }
        return builder.toString();
    }

    public String concise() {
        String reasonString = this.reason == null ? "" : this.reason.substring(0, 3);
        return String.format("%s %-4s %-3s", this.getFormattedTime(), this.status, reasonString);
    }
}

