/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.ppm.mega.common;

import com.avaya.asm.core.AsmLogger;
import com.avaya.common.logging.client.Logger;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class MegaPPMUtils {
    private static final Logger log = AsmLogger.getLogger(MegaPPMUtils.class);

    public static String epochTimestampToPosix(long timestampMS) {
        String timestamp = DateTimeFormatter.ISO_INSTANT.format(Instant.ofEpochMilli(timestampMS));
        return timestamp;
    }

    public static Long posixTimeToEpochMS(String posixTime) {
        String fcn_name = "posixTimeToEpochMS";
        Long timestampAsEpochMS = null;
        if (posixTime == null) {
            log.error((Object)"posixTimeToEpochMS: called with invalid posixTime (null)");
            return null;
        }
        if (posixTime.isEmpty()) {
            log.error((Object)"posixTimeToEpochMS: called with invalid posixTime (Empty())");
            return null;
        }
        try {
            Date date = Date.from(Instant.parse(posixTime));
            timestampAsEpochMS = date.getTime();
        }
        catch (DateTimeParseException dtpe) {
            log.error((Object)("posixTimeToEpochMS: caught exception " + dtpe));
        }
        return timestampAsEpochMS;
    }

    public static long getAndAdjustTimestamp(String offsetOption) {
        long adjustedUnixTime = 0L;
        long unixTime = System.currentTimeMillis();
        String fcn_name = "getAndAdjustTimestamp";
        switch (offsetOption.charAt(0)) {
            case '+': 
            case '-': {
                adjustedUnixTime = unixTime + MegaPPMUtils.handleAdjustment(offsetOption);
                break;
            }
            case 'N': 
            case 'n': {
                adjustedUnixTime = unixTime;
                break;
            }
            case 'Y': 
            case 'y': {
                adjustedUnixTime = unixTime - TimeUnit.DAYS.toMillis(1L);
                break;
            }
            default: {
                try {
                    adjustedUnixTime = TimeUnit.SECONDS.toMillis(Long.parseLong(offsetOption));
                    break;
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("getAndAdjustTimestamp: exception parsing " + offsetOption + " as Long; unable to continue.", nfe);
                }
            }
        }
        return adjustedUnixTime;
    }

    private static long handleAdjustment(String howFar) {
        String direction;
        TimeUnit tu;
        String fcn_name = "handleAdjustment";
        boolean isFiner = log.isFinerEnabled();
        long delta = 0L;
        long adjustment = 1L;
        int choiceSize = howFar.length() - 1;
        char tuChar = howFar.charAt(choiceSize);
        switch (tuChar) {
            case 'S': 
            case 's': {
                tu = TimeUnit.SECONDS;
                break;
            }
            case 'M': 
            case 'm': {
                tu = TimeUnit.MINUTES;
                break;
            }
            case 'H': 
            case 'h': {
                tu = TimeUnit.HOURS;
                break;
            }
            case 'D': 
            case 'd': {
                tu = TimeUnit.DAYS;
                break;
            }
            default: {
                throw new IllegalArgumentException("handleAdjustment: invalid time decrement (or increment) value; use s for seconds, m for minutes, h hours, or d for days in the past (-10h) or future (+10h).");
            }
        }
        long howFarInterval = Long.parseLong(howFar.substring(1, choiceSize));
        adjustment = tu.toMillis(howFarInterval);
        if (howFar.charAt(0) == '+') {
            delta = adjustment;
            direction = "increment";
        } else {
            delta = adjustment * -1L;
            direction = "decrement";
        }
        if (isFiner) {
            log.finer((Object)("handleAdjustment: using howFar arg " + howFar + " seconds; returning " + delta + " msec " + direction + "."));
        }
        return delta;
    }
}

