/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.trustmgmt;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.datamgr.objectapi.IPAddress;
import com.avaya.common.logging.client.Logger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;

public class AsmHostnameVerifier
implements HostnameVerifier {
    private static Logger log = AsmLogger.getLogger(AsmHostnameVerifier.class);

    @Override
    public boolean verify(String ipAddressOrFqdn, SSLSession sslSession) {
        String functionName = "verify";
        boolean isFinestEnabled = log.isFinestEnabled();
        if (isFinestEnabled) {
            log.finest((Object)("verify: entered. ipAddressOrFqdn=" + ipAddressOrFqdn + ", sslSession=" + sslSession));
        }
        X509Certificate cert = null;
        try {
            cert = (X509Certificate)sslSession.getPeerCertificates()[0];
        }
        catch (SSLPeerUnverifiedException e) {
            log.error((Object)("verify: Couldn't get Peer Certificates. ipAddressOrFqdn=" + ipAddressOrFqdn + ", cert=" + cert), (Throwable)e);
        }
        boolean result = false;
        if (ipAddressOrFqdn == null || cert == null) {
            return result;
        }
        result = this.isIpAddress(ipAddressOrFqdn) ? this.matchesIpAddress(ipAddressOrFqdn, cert) : this.matchesFqdn(ipAddressOrFqdn, cert);
        return result;
    }

    private boolean matchesIpAddress(String ipAddress, X509Certificate cert) {
        String functionName = "matchesIpAddress";
        boolean isFinestEnabled = log.isFinestEnabled();
        if (isFinestEnabled) {
            log.finest((Object)("matchesIpAddress: entered. ipAddress=" + ipAddress + ", cert=" + cert));
        }
        Collection<List<?>> sans = null;
        try {
            sans = cert.getSubjectAlternativeNames();
        }
        catch (CertificateParsingException e) {
            log.error((Object)("matchesIpAddress: Couldn't get Subject Alternate Names. ipAddress=" + ipAddress + ", cert=" + cert));
        }
        if (sans != null) {
            for (List<?> sanList : sans) {
                String subjectAlternateName;
                Integer altNameType = (Integer)sanList.get(0);
                if (altNameType != 7 || (subjectAlternateName = (String)sanList.get(1)) == null) continue;
                if (ipAddress.equalsIgnoreCase(subjectAlternateName)) {
                    return true;
                }
                try {
                    if (!InetAddress.getByName(ipAddress).equals(InetAddress.getByName(subjectAlternateName))) continue;
                    return true;
                }
                catch (UnknownHostException unknownHostException) {
                }
                catch (SecurityException securityException) {
                }
            }
        }
        return false;
    }

    private boolean matchesFqdn(String fqdn, X509Certificate cert) {
        String commonName;
        String functionName = "matchesFqdn";
        boolean isFinestEnabled = log.isFinestEnabled();
        if (isFinestEnabled) {
            log.finest((Object)"matchesFqdn: entered.");
        }
        Collection<List<?>> sans = null;
        try {
            sans = cert.getSubjectAlternativeNames();
        }
        catch (CertificateParsingException e) {
            log.error((Object)("matchesFqdn:Couldn't get Subject Alternate Names. fqdn=" + fqdn + ", cert=" + cert));
        }
        if (sans != null) {
            boolean sanExists = false;
            for (List<?> sanList : sans) {
                String subjectAlternateName;
                Integer altNameType = (Integer)sanList.get(0);
                if (altNameType == 2 && (subjectAlternateName = (String)sanList.get(1)) != null && this.isMatched(fqdn, subjectAlternateName)) {
                    return true;
                }
                sanExists = true;
            }
            if (sanExists) {
                return false;
            }
        }
        return (commonName = this.extractCommonName(cert)) != null && this.isMatched(fqdn, commonName);
    }

    private boolean isMatched(String fqdn, String name) {
        return this.matchAllWildcards(fqdn, name);
    }

    private boolean matchAllWildcards(String fqdn, String name) {
        String functionName = "matchAllWildcards";
        boolean isFinestEnabled = log.isFinestEnabled();
        if (isFinestEnabled) {
            log.finest((Object)("matchAllWildcards: entered. fqdn=" + fqdn + ", name=" + name));
        }
        if (fqdn != null && name != null) {
            fqdn = fqdn.toLowerCase(Locale.ENGLISH);
            name = name.toLowerCase(Locale.ENGLISH);
            StringTokenizer fqdnTokens = new StringTokenizer(fqdn, ".");
            StringTokenizer nameTokens = new StringTokenizer(name, ".");
            if (fqdnTokens.countTokens() == nameTokens.countTokens()) {
                do {
                    if (fqdnTokens.hasMoreTokens()) continue;
                    return true;
                } while (this.matchWildCards(fqdnTokens.nextToken(), nameTokens.nextToken()));
            }
        } else if (fqdn == null && name == null) {
            return true;
        }
        return false;
    }

    private boolean matchWildCards(String fqdn, String name) {
        String functionName = "matchWildCards";
        boolean isFinestEnabled = log.isFinestEnabled();
        if (isFinestEnabled) {
            log.finest((Object)("matchWildCards: entered. fqdn=" + fqdn + ", name=" + name));
        }
        if (fqdn != null && name != null) {
            int wildcardIndex = name.indexOf("*");
            if (wildcardIndex < 0) {
                return fqdn.equalsIgnoreCase(name);
            }
            boolean firstWildcard = true;
            while (wildcardIndex >= 0) {
                String nameBeforeWildcard = name.substring(0, wildcardIndex);
                int fqdnIndex = fqdn.indexOf(nameBeforeWildcard);
                if (fqdnIndex < 0 || firstWildcard && fqdnIndex != 0) {
                    return false;
                }
                fqdn = fqdn.substring(fqdnIndex + nameBeforeWildcard.length());
                name = name.substring(wildcardIndex + 1);
                wildcardIndex = name.indexOf("*");
                firstWildcard = false;
            }
            return fqdn.endsWith(name);
        }
        return fqdn == null && name == null;
    }

    private String extractCommonName(X509Certificate cert) {
        String functionName = "extractCommonName";
        String commonName = null;
        try {
            X500Name x500name = new JcaX509CertificateHolder(cert).getSubject();
            RDN rdn = x500name.getRDNs(BCStyle.CN)[0];
            commonName = IETFUtils.valueToString((ASN1Encodable)rdn.getFirst().getValue());
        }
        catch (CertificateEncodingException e) {
            log.error((Object)("extractCommonName: Couldn't get Common Name. cert=" + cert));
        }
        return commonName;
    }

    private boolean isIpAddress(String ipAddressOrFqdn) {
        return IPAddress.isIPAddress(ipAddressOrFqdn);
    }
}

