/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.trustmgmt;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.trustmgmt.RevocationInfo;
import com.avaya.asm.trustmgmt.RevocationInfoFileImpl;
import com.avaya.asm.trustmgmt.RevocationInfoMonitor;
import com.avaya.asm.trustmgmt.RevocationOptions;
import com.avaya.common.logging.client.Logger;

public class RevocationInfoManager {
    private static final Logger log = AsmLogger.getLogger(RevocationInfoManager.class);
    private static final RevocationInfoFileImpl revocationInfoFile = new RevocationInfoFileImpl();
    private static RevocationInfoManager instance = null;

    private RevocationInfoManager() {
        String functionName = "RevocationInfoManager";
        boolean isFineEnabled = log.isFineEnabled();
        if (isFineEnabled) {
            log.fine((Object)"RevocationInfoManager: Creating new instance");
        }
        try {
            RevocationInfoMonitor.getInstance().enableAllRevocationInfoMonitoring();
        }
        catch (Exception e) {
            log.error((Object)"RevocationInfoManager: Cannot enable RegistrationInfo monitoring", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RevocationInfoManager getInstance() {
        if (instance != null) return instance;
        Class<RevocationInfoManager> clazz = RevocationInfoManager.class;
        synchronized (RevocationInfoManager.class) {
            if (instance != null) return instance;
            instance = new RevocationInfoManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public RevocationInfo getRevocationInfo() {
        return revocationInfoFile;
    }

    public RevocationInfoFileImpl getRevocationInfoFile() {
        return revocationInfoFile;
    }

    public void setRevocationOptions(RevocationOptions revocationOptions) {
        String functionName = "setRevocationOptions";
        boolean isFineEnabled = log.isFineEnabled();
        if (isFineEnabled) {
            log.fine((Object)("setRevocationOptions: revocationOptions=" + revocationOptions));
        }
        revocationInfoFile.setRevocationOptions(revocationOptions);
        revocationInfoFile.saveRevocationOptionsToFile();
    }
}

