/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ustore;

import com.avaya.asm.datamgr.dao.cassandra.UserStoreKeyspace;
import com.avaya.asm.datamgr.objectapi.AsmInstance;
import com.avaya.mgmt.trust.util.TMPasswordJboss;
import com.avaya.ustore.KeyInfo;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class AsmDBMgr {
    final String url = "jdbc:postgresql://localhost/asm?ssl";
    final String user = "asm";
    final String password;
    static Object mutex = new Object();
    Connection db;
    final long stubbedBsmId = 0L;
    private Map<Long, Long> userCommunityMap = null;
    private Map<Long, List<Long>> communityAsmInstanceIdsMap = null;
    private String myHostname;
    ErrorHandler errorHandler = null;
    HashMap<Long, Integer> ucomNumSMs = new HashMap();

    private void handleErrors(String msg, Exception e) {
        if (this.errorHandler != null) {
            this.errorHandler.error(msg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getHostname() {
        String hostname = null;
        FileReader hostnameReader = null;
        BufferedReader in = null;
        try {
            hostnameReader = new FileReader("/etc/hostname");
            in = new BufferedReader(hostnameReader);
            hostname = in.readLine();
        }
        catch (IOException iOException) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (hostnameReader != null) {
                try {
                    hostnameReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return hostname;
    }

    public AsmDBMgr() {
        this.password = null;
        this.init(null);
    }

    public AsmDBMgr(ErrorHandler errorHandler) {
        this.password = null;
        this.init(errorHandler);
    }

    private void init(ErrorHandler errorHandler) {
        String fcn_name = "init";
        this.errorHandler = errorHandler;
        try {
            TMPasswordJboss tmPassword = new TMPasswordJboss("mgmt", "/opt/Avaya/wildfly-24.0.0.Final/standalone/configuration/tm/");
            char[] password = tmPassword.toCharArray();
            System.setProperty("javax.net.ssl.trustStorePassword", String.valueOf(password));
            System.setProperty("javax.net.ssl.keyStorePassword", String.valueOf(password));
        }
        catch (Exception e) {
            this.handleErrors("init: unable set properties for truststore / keystore access", e);
            System.exit(1);
        }
        try {
            Class.forName("org.postgresql.Driver");
        }
        catch (ClassNotFoundException e) {
            this.handleErrors("init: ClassNotFoundException received: ", e);
            System.exit(1);
        }
        try {
            this.db = DriverManager.getConnection("jdbc:postgresql://localhost/asm?ssl", "asm", this.password);
        }
        catch (SQLException e) {
            this.handleErrors("init: SQLException received: ", e);
            System.exit(1);
        }
        this.myHostname = AsmDBMgr.getHostname();
    }

    public void queryUsers(List<KeyInfo> ids, String filterRE, boolean primaryOnly, boolean secondaryOnly) throws SQLException {
        String asmProperties = "/opt/Avaya/install.properties";
        String fcn_name = "queryUsers";
        String sqlSelect = "SELECT p_inst.id,assign.asmusercommunity_id, u.id,set.id FROM asminstance inst, asminstance p_inst, asmusercommunityassign assign, asmusercommunityassign p_assign, csuser u, cscommprofileset set, cscommprofile prof, asmcommprofile asmprof, asmusercommunity comm ";
        String sqlCmd1 = "WHERE inst.managementaccesspointhostname='";
        String allCmd2 = "' AND inst.id=assign.asminstance_id AND assign.asmusercommunity_id=comm.id AND comm.id=asmprof.usercommunity_id AND asmprof.id=prof.id AND prof.cscommprofilesetid=set.id AND set.csuserid=u.id AND p_assign.asmusercommunity_id=assign.asmusercommunity_id AND p_assign.priorityorder=0 AND p_inst.id=p_assign.asminstance_id";
        String primSecCmd2 = " AND assign.priorityorder";
        String sqlCmd3 = " ORDER BY u.id;";
        String userFilter = filterRE == null ? "" : " AND u.loginname ~ '" + filterRE + "' ";
        this.userCommunityMap = new HashMap<Long, Long>();
        this.communityAsmInstanceIdsMap = new HashMap<Long, List<Long>>();
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream("/opt/Avaya/install.properties"));
        }
        catch (FileNotFoundException e2) {
            this.handleErrors("FileNotFoundException raised for /opt/Avaya/install.properties", e2);
            System.exit(1);
        }
        catch (IOException e2) {
            this.handleErrors("IOException raised reading in properties: /opt/Avaya/install.properties", e2);
            System.exit(1);
        }
        String mgmtIpAddr = properties.getProperty("MgmtIP");
        if (mgmtIpAddr == null) {
            this.handleErrors("MgmtIP not found in /opt/Avaya/install.properties", null);
            System.exit(1);
        }
        Statement st = null;
        try {
            st = this.db.createStatement();
        }
        catch (SQLException e) {
            this.handleErrors("queryUsers: SQLException received for createStatement: ", e);
            throw e;
        }
        ResultSet rs = null;
        StringBuilder sb = new StringBuilder("SELECT p_inst.id,assign.asmusercommunity_id, u.id,set.id FROM asminstance inst, asminstance p_inst, asmusercommunityassign assign, asmusercommunityassign p_assign, csuser u, cscommprofileset set, cscommprofile prof, asmcommprofile asmprof, asmusercommunity comm ");
        try {
            sb.append("WHERE inst.managementaccesspointhostname='");
            sb.append(mgmtIpAddr);
            sb.append("' AND inst.id=assign.asminstance_id AND assign.asmusercommunity_id=comm.id AND comm.id=asmprof.usercommunity_id AND asmprof.id=prof.id AND prof.cscommprofilesetid=set.id AND set.csuserid=u.id AND p_assign.asmusercommunity_id=assign.asmusercommunity_id AND p_assign.priorityorder=0 AND p_inst.id=p_assign.asminstance_id");
            if (primaryOnly || secondaryOnly) {
                sb.append(" AND assign.priorityorder");
                sb.append(primaryOnly ? "=0 " : "!=0 ");
            }
            sb.append(userFilter);
            sb.append(" ORDER BY u.id;");
            rs = st.executeQuery(sb.toString());
        }
        catch (SQLException e) {
            this.handleErrors("queryUsers: SQLException received for executeQuery: " + sb.toString(), e);
            try {
                st.close();
            }
            catch (SQLException e1) {
                this.handleErrors("queryUsers: SQLException received for st.close(): " + sb.toString(), e1);
            }
            throw e;
        }
        try {
            while (rs.next()) {
                Long ucomId = rs.getLong(2);
                int numSMs = this.ucomNumSMs.get(ucomId);
                KeyInfo keyInfo = new KeyInfo(rs.getLong(1), rs.getLong(2), 0L, rs.getLong(3), rs.getLong(4), numSMs);
                ids.add(keyInfo);
                this.userCommunityMap.put(rs.getLong(4), ucomId);
                if (this.communityAsmInstanceIdsMap.containsKey(ucomId)) continue;
                this.communityAsmInstanceIdsMap.put(ucomId, null);
            }
        }
        catch (SQLException e) {
            this.handleErrors("queryUsers: SQLException received for rs operation: ", e);
            throw e;
        }
        try {
            st.close();
        }
        catch (SQLException e) {
            this.handleErrors("queryUsers: SQLException received for st.close: ", e);
            throw e;
        }
        try {
            rs.close();
        }
        catch (SQLException e) {
            this.handleErrors("queryUsers: SQLException received for rs.close: ", e);
            throw e;
        }
    }

    public Map<Long, Long> getUsersCommunityMap() {
        return this.userCommunityMap;
    }

    public Map<Long, List<Long>> getCommunityAsmInstanceIdsMap() {
        return this.communityAsmInstanceIdsMap;
    }

    public Map<Long, UserData> getUserCommunities(String filterRE, boolean primaryOnly, boolean secondaryOnly) throws SQLException {
        String asmProperties = "/opt/Avaya/install.properties";
        String fcn_name = "queryUsers";
        String sqlSelect = "SELECT p_inst.id,assign.asmusercommunity_id, u.id,set.id FROM asminstance inst, asminstance p_inst, asmusercommunityassign assign, asmusercommunityassign p_assign, csuser u, cscommprofileset set, cscommprofile prof, asmcommprofile asmprof, asmusercommunity comm ";
        String sqlCmd1 = "WHERE inst.managementaccesspointhostname IN (";
        String allCmd2 = ") AND inst.id=assign.asminstance_id AND assign.asmusercommunity_id=comm.id AND comm.id=asmprof.usercommunity_id AND asmprof.id=prof.id AND prof.cscommprofilesetid=set.id AND set.csuserid=u.id AND p_assign.asmusercommunity_id=assign.asmusercommunity_id AND p_assign.priorityorder=0 AND p_inst.id=p_assign.asminstance_id";
        String primSecCmd2 = " AND assign.priorityorder";
        String sqlCmd3 = " ORDER BY u.id;";
        String userFilter = filterRE == null ? "" : " AND u.loginname ~ '" + filterRE + "' ";
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream("/opt/Avaya/install.properties"));
        }
        catch (FileNotFoundException e2) {
            this.handleErrors("FileNotFoundException raised for /opt/Avaya/install.properties", e2);
            System.exit(1);
        }
        catch (IOException e2) {
            this.handleErrors("IOException raised reading in properties: /opt/Avaya/install.properties", e2);
            System.exit(1);
        }
        String mgmtIpAddr = properties.getProperty("MgmtIP");
        if (mgmtIpAddr == null) {
            this.handleErrors("MgmtIP not found in /opt/Avaya/install.properties", null);
            System.exit(1);
        }
        String hostname = AsmDBMgr.getHostname();
        Statement st = null;
        try {
            st = this.db.createStatement();
        }
        catch (SQLException e) {
            this.handleErrors("queryUsers: SQLException received for createStatement: ", e);
            throw e;
        }
        ResultSet rs = null;
        StringBuilder sb = new StringBuilder("SELECT p_inst.id,assign.asmusercommunity_id, u.id,set.id FROM asminstance inst, asminstance p_inst, asmusercommunityassign assign, asmusercommunityassign p_assign, csuser u, cscommprofileset set, cscommprofile prof, asmcommprofile asmprof, asmusercommunity comm ");
        try {
            sb.append("WHERE inst.managementaccesspointhostname IN (");
            sb.append('\'');
            sb.append(mgmtIpAddr);
            sb.append('\'');
            if (hostname != null) {
                sb.append(',');
                sb.append('\'');
                sb.append(hostname);
                sb.append('\'');
            }
            sb.append(") AND inst.id=assign.asminstance_id AND assign.asmusercommunity_id=comm.id AND comm.id=asmprof.usercommunity_id AND asmprof.id=prof.id AND prof.cscommprofilesetid=set.id AND set.csuserid=u.id AND p_assign.asmusercommunity_id=assign.asmusercommunity_id AND p_assign.priorityorder=0 AND p_inst.id=p_assign.asminstance_id");
            if (primaryOnly || secondaryOnly) {
                sb.append(" AND assign.priorityorder");
                sb.append(primaryOnly ? "=0 " : "!=0 ");
            }
            sb.append(userFilter);
            sb.append(" ORDER BY u.id;");
            rs = st.executeQuery(sb.toString());
        }
        catch (SQLException e) {
            this.handleErrors("queryUsers: SQLException received for executeQuery: " + sb.toString(), e);
            try {
                st.close();
            }
            catch (SQLException e1) {
                this.handleErrors("queryUsers: SQLException received for st.close(): " + sb.toString(), e1);
            }
            throw e;
        }
        HashMap<Long, UserData> userCommunities = new HashMap<Long, UserData>();
        try {
            while (rs.next()) {
                Long setId = rs.getLong(4);
                Long userId = rs.getLong(3);
                Long community = rs.getLong(2);
                userCommunities.put(setId, new UserData(userId, community));
            }
        }
        catch (SQLException e) {
            this.handleErrors("queryUsers: SQLException received for rs operation: ", e);
            throw e;
        }
        try {
            st.close();
        }
        catch (SQLException e) {
            this.handleErrors("queryUsers: SQLException received for st.close: ", e);
            throw e;
        }
        try {
            rs.close();
        }
        catch (SQLException e) {
            this.handleErrors("queryUsers: SQLException received for rs.close: ", e);
            throw e;
        }
        return userCommunities;
    }

    public void queryUserCommunities() throws SQLException {
        String fcn_name = "queryUserCommunities";
        String sqlSelect = "SELECT asmusercommunity_id, COUNT(*) FROM  asmusercommunityassign assign GROUP BY asmusercommunity_id ORDER BY asmusercommunity_id;";
        Statement st = null;
        try {
            st = this.db.createStatement();
        }
        catch (SQLException e) {
            this.handleErrors("queryUserCommunities: SQLException received for createStatement: ", e);
            throw e;
        }
        ResultSet rs = null;
        try {
            rs = st.executeQuery("SELECT asmusercommunity_id, COUNT(*) FROM  asmusercommunityassign assign GROUP BY asmusercommunity_id ORDER BY asmusercommunity_id;");
        }
        catch (SQLException e) {
            this.handleErrors("queryUserCommunities: SQLException received for executeQuery: SELECT asmusercommunity_id, COUNT(*) FROM  asmusercommunityassign assign GROUP BY asmusercommunity_id ORDER BY asmusercommunity_id;", e);
            try {
                st.close();
            }
            catch (SQLException e1) {
                this.handleErrors("queryUserCommunities: SQLException received for st.close(): SELECT asmusercommunity_id, COUNT(*) FROM  asmusercommunityassign assign GROUP BY asmusercommunity_id ORDER BY asmusercommunity_id;", e1);
            }
            throw e;
        }
        try {
            while (rs.next()) {
                Long ucomId = rs.getLong(1);
                int numSMs = rs.getInt(2);
                this.ucomNumSMs.put(ucomId, numSMs);
            }
        }
        catch (SQLException e) {
            this.handleErrors("queryUserCommunities: SQLException received for rs operation: ", e);
            throw e;
        }
        try {
            st.close();
        }
        catch (SQLException e) {
            this.handleErrors("queryUserCommunities: SQLException received for st.close: ", e);
            throw e;
        }
        try {
            rs.close();
        }
        catch (SQLException e) {
            this.handleErrors("queryUserCommunities: SQLException received for rs.close: ", e);
            throw e;
        }
    }

    public Map<Long, UserStoreKeyspace> getKeyspaces() throws SQLException {
        String fcn_name = "getKeyspaces";
        String sqlSelect = "SELECT asmusercommunity_id, asminstance_id FROM asmusercommunityassign ORDER BY asmusercommunity_id";
        Map<Long, AsmInstance> asmInstances = this.queryAllAsmInstances();
        Statement st = null;
        try {
            st = this.db.createStatement();
        }
        catch (SQLException e) {
            this.handleErrors("getKeyspaces: SQLException received for createStatement: ", e);
            throw e;
        }
        ResultSet rs = null;
        try {
            rs = st.executeQuery("SELECT asmusercommunity_id, asminstance_id FROM asmusercommunityassign ORDER BY asmusercommunity_id");
        }
        catch (SQLException e) {
            this.handleErrors("getKeyspaces: SQLException received for executeQuery: SELECT asmusercommunity_id, asminstance_id FROM asmusercommunityassign ORDER BY asmusercommunity_id", e);
            try {
                st.close();
            }
            catch (SQLException e1) {
                this.handleErrors("getKeyspaces: SQLException received for st.close(): SELECT asmusercommunity_id, asminstance_id FROM asmusercommunityassign ORDER BY asmusercommunity_id", e1);
            }
            throw e;
        }
        HashMap<Long, ArrayList<AsmInstance>> communities = new HashMap<Long, ArrayList<AsmInstance>>();
        try {
            while (rs.next()) {
                Long community = rs.getLong(1);
                Long instance = rs.getLong(2);
                ArrayList<AsmInstance> instances = (ArrayList<AsmInstance>)communities.get(community);
                if (instances == null) {
                    instances = new ArrayList<AsmInstance>();
                    communities.put(community, instances);
                }
                instances.add(asmInstances.get(instance));
            }
        }
        catch (SQLException e) {
            this.handleErrors("getKeyspaces: SQLException received for rs operation: ", e);
            throw e;
        }
        try {
            st.close();
        }
        catch (SQLException e) {
            this.handleErrors("getKeyspaces: SQLException received for st.close: ", e);
            throw e;
        }
        try {
            rs.close();
        }
        catch (SQLException e) {
            this.handleErrors("getKeyspaces: SQLException received for rs.close: ", e);
            throw e;
        }
        HashMap<Long, UserStoreKeyspace> keyspaces = new HashMap<Long, UserStoreKeyspace>();
        for (Map.Entry entry : communities.entrySet()) {
            UserStoreKeyspace keyspace = new UserStoreKeyspace((List)entry.getValue());
            keyspaces.put((Long)entry.getKey(), keyspace);
        }
        return keyspaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> queryUsersAsmInstanceIds(long ucommId) throws SQLException {
        String fcn_name = "queryUsersAsmInstanceIds";
        String sqlSelectPart1 = "SELECT asminstance_id FROM asmusercommunityassign where asmusercommunity_id ='";
        String sqlSelectPart2 = "' ORDER BY asminstance_id;";
        Statement st = null;
        ArrayList<Long> instanceList = new ArrayList<Long>();
        ResultSet rs = null;
        try {
            try {
                st = this.db.createStatement();
            }
            catch (SQLException e) {
                this.handleErrors("queryUsersAsmInstanceIds: SQLException received for createStatement: ", e);
                throw e;
            }
            try {
                rs = st.executeQuery("SELECT asminstance_id FROM asmusercommunityassign where asmusercommunity_id ='" + ucommId + "' ORDER BY asminstance_id;");
            }
            catch (SQLException e) {
                this.handleErrors("queryUsersAsmInstanceIds: SQLException received for st.executeQuery: SELECT asminstance_id FROM asmusercommunityassign where asmusercommunity_id ='" + ucommId + "' ORDER BY asminstance_id;", e);
                throw e;
            }
            int i = 1;
            try {
                while (rs.next()) {
                    instanceList.add(rs.getLong(i));
                }
            }
            catch (SQLException e) {
                this.handleErrors("queryUsersAsmInstanceIds: SQLException received for rs.next operation: ", e);
                throw e;
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                this.handleErrors("queryUsersAsmInstanceIds: SQLException received for rs.close: ", e);
            }
            try {
                if (st != null) {
                    st.close();
                }
            }
            catch (SQLException e) {
                this.handleErrors("queryUsersAsmInstanceIds: SQLException received for st.close: ", e);
            }
        }
        return instanceList;
    }

    public void queryAsmInstanceIdsForCommunityId(Map<Long, List<Long>> communityAsmInstanceIdsMap) throws SQLException {
        String fcn_name = "queryAsmInstanceIdsForCommunityId";
        HashMap<Long, List<Long>> commAsmInstanceIdsMap = new HashMap<Long, List<Long>>();
        String sqlSelect = "SELECT asminstance_id FROM asmusercommunityassign where asmusercommunity_id = ";
        Statement st = null;
        try {
            st = this.db.createStatement();
        }
        catch (SQLException e) {
            this.handleErrors("queryAsmInstanceIdsForCommunityId: SQLException received for createStatement: ", e);
            throw e;
        }
        ResultSet rs = null;
        for (Long commId : communityAsmInstanceIdsMap.keySet()) {
            ArrayList<Long> asmInstanceIdList = new ArrayList<Long>();
            try {
                rs = st.executeQuery("SELECT asminstance_id FROM asmusercommunityassign where asmusercommunity_id = " + commId);
            }
            catch (SQLException e) {
                this.handleErrors("queryAsmInstanceIdsForCommunityId: SQLException received for st.executeQuery: SELECT asminstance_id FROM asmusercommunityassign where asmusercommunity_id = ", e);
                throw e;
            }
            try {
                while (rs.next()) {
                    asmInstanceIdList.add(rs.getLong("asminstance_id"));
                }
            }
            catch (SQLException e) {
                this.handleErrors("queryAsmInstanceIdsForCommunityId: SQLException received for rs operation: ", e);
                throw e;
            }
            communityAsmInstanceIdsMap.put(commId, asmInstanceIdList);
        }
        try {
            st.close();
        }
        catch (SQLException e) {
            this.handleErrors("queryAsmInstanceIdsForCommunityId: SQLException received for st.close: ", e);
            throw e;
        }
        try {
            rs.close();
        }
        catch (SQLException e) {
            this.handleErrors("queryAsmInstanceIdsForCommunityId: SQLException received for rs.close: ", e);
            throw e;
        }
        communityAsmInstanceIdsMap = commAsmInstanceIdsMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, AsmInstance> queryAllAsmInstances() throws SQLException {
        String fcn_name = "queryAllAsmInstances";
        String sqlSelect = "SELECT id, sipentity_id, managementaccesspointhostname, sm_type, is_monitoring, monitor_proactive_secs, monitor_reactive_secs, monitor_retries, is_cdr_enabled, cdr_fileformat, cdr_usertouser_calls, cdr_incomplete_calls, err_on_notify_failure, honor_phase_equal_endpoint, adaptation_cm_tg_id, maincm_for_lsp_app_id, maintenance_mode, storage_cluster_id, aads_applicationsystem_id  FROM asminstance";
        Statement st = null;
        ResultSet rs = null;
        HashMap<Long, AsmInstance> asmInstances = new HashMap<Long, AsmInstance>();
        try {
            try {
                st = this.db.createStatement();
            }
            catch (SQLException e) {
                this.handleErrors("queryAllAsmInstances: SQLException received for createStatement: ", e);
                throw e;
            }
            try {
                rs = st.executeQuery("SELECT id, sipentity_id, managementaccesspointhostname, sm_type, is_monitoring, monitor_proactive_secs, monitor_reactive_secs, monitor_retries, is_cdr_enabled, cdr_fileformat, cdr_usertouser_calls, cdr_incomplete_calls, err_on_notify_failure, honor_phase_equal_endpoint, adaptation_cm_tg_id, maincm_for_lsp_app_id, maintenance_mode, storage_cluster_id, aads_applicationsystem_id  FROM asminstance");
            }
            catch (SQLException e) {
                this.handleErrors("queryAllAsmInstances: SQLException received for st.executeQuery: SELECT id, sipentity_id, managementaccesspointhostname, sm_type, is_monitoring, monitor_proactive_secs, monitor_reactive_secs, monitor_retries, is_cdr_enabled, cdr_fileformat, cdr_usertouser_calls, cdr_incomplete_calls, err_on_notify_failure, honor_phase_equal_endpoint, adaptation_cm_tg_id, maincm_for_lsp_app_id, maintenance_mode, storage_cluster_id, aads_applicationsystem_id  FROM asminstance", e);
                throw e;
            }
            try {
                while (rs.next()) {
                    Long instanceId = rs.getLong("id");
                    AsmInstance instance = new AsmInstance(instanceId, rs.getLong("sipentity_id"), rs.getString("managementaccesspointhostname"), !"SM".equalsIgnoreCase(rs.getString("sm_type")), rs.getBoolean("is_monitoring"), rs.getInt("monitor_proactive_secs"), rs.getInt("monitor_reactive_secs"), rs.getInt("monitor_retries"), rs.getBoolean("is_cdr_enabled"), rs.getString("cdr_fileformat"), rs.getBoolean("cdr_usertouser_calls"), rs.getBoolean("cdr_incomplete_calls"), rs.getBoolean("err_on_notify_failure"), rs.getBoolean("honor_phase_equal_endpoint"), (Long)rs.getObject("adaptation_cm_tg_id"), (Long)rs.getObject("maincm_for_lsp_app_id"), rs.getBoolean("maintenance_mode"), (Long)rs.getObject("storage_cluster_id"), (Long)rs.getObject("aads_applicationsystem_id"));
                    asmInstances.put(instanceId, instance);
                }
            }
            catch (SQLException e) {
                this.handleErrors("queryAllAsmInstances: SQLException received for rs operation: ", e);
                throw e;
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                this.handleErrors("queryAllAsmInstances: SQLException received for rs.close: ", e);
            }
            try {
                if (st != null) {
                    st.close();
                }
            }
            catch (SQLException e) {
                this.handleErrors("queryAllAsmInstances: SQLException received for st.close: ", e);
            }
        }
        return asmInstances;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String queryAsmHostName(long instanceId) throws SQLException {
        String fcn_name = "queryAsmHostName";
        String sqlSelect = "SELECT managementaccesspointhostname FROM asminstance where id = ";
        Statement st = null;
        String managementHostName = null;
        ResultSet rs = null;
        try {
            try {
                st = this.db.createStatement();
            }
            catch (SQLException e) {
                this.handleErrors("queryAsmHostName: SQLException received for createStatement: ", e);
                throw e;
            }
            try {
                rs = st.executeQuery("SELECT managementaccesspointhostname FROM asminstance where id = " + instanceId + ";");
            }
            catch (SQLException e) {
                this.handleErrors("queryAsmHostName: SQLException received for st.executeQuery: SELECT managementaccesspointhostname FROM asminstance where id = " + instanceId, e);
                throw e;
            }
            try {
                while (rs.next()) {
                    managementHostName = rs.getString(1);
                }
            }
            catch (SQLException e) {
                this.handleErrors("queryAsmHostName: SQLException received for rs.next operation: ", e);
                throw e;
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                this.handleErrors("queryAsmHostName: SQLException received for rs.close: ", e);
            }
            try {
                if (st != null) {
                    st.close();
                }
            }
            catch (SQLException e) {
                this.handleErrors("queryAsmHostName: SQLException received for st.close: ", e);
            }
        }
        return managementHostName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long queryUsersAsmCommProfileId(long cpSetId) throws SQLException {
        String fcn_name = "queryUsersAsmCommProfileId";
        String sqlSelect1 = "SELECT id FROM cscommprofile WHERE cscommprofilesetid = ";
        String sqlSelect2 = " and commprofiletype = 'SIP'";
        Statement st = null;
        Long acpId = null;
        ResultSet rs = null;
        try {
            try {
                st = this.db.createStatement();
            }
            catch (SQLException e) {
                this.handleErrors("queryUsersAsmCommProfileId: SQLException received for createStatement: ", e);
                throw e;
            }
            try {
                rs = st.executeQuery("SELECT id FROM cscommprofile WHERE cscommprofilesetid = " + cpSetId + " and commprofiletype = 'SIP'" + ";");
            }
            catch (SQLException e) {
                this.handleErrors("queryUsersAsmCommProfileId: SQLException received for st.executeQuery: SELECT id FROM cscommprofile WHERE cscommprofilesetid = " + cpSetId + " and commprofiletype = 'SIP'", e);
                throw e;
            }
            try {
                while (rs.next()) {
                    acpId = rs.getLong(1);
                }
            }
            catch (SQLException e) {
                this.handleErrors("queryUsersAsmCommProfileId: SQLException received for rs.next operation: ", e);
                throw e;
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                this.handleErrors("queryUsersAsmCommProfileId: SQLException received for rs.close: ", e);
            }
            try {
                if (st != null) {
                    st.close();
                }
            }
            catch (SQLException e) {
                this.handleErrors("queryUsersAsmCommProfileId: SQLException received for st.close: ", e);
            }
        }
        return acpId;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public static class UserData {
        private Long csuser_id;
        private Long usercommunity_id;

        public UserData(Long csuser_id, Long usercommunity_id) {
            this.csuser_id = csuser_id;
            this.usercommunity_id = usercommunity_id;
        }

        public Long getCsuser_id() {
            return this.csuser_id;
        }

        public Long getUsercommunity_id() {
            return this.usercommunity_id;
        }
    }

    public static interface ErrorHandler {
        public void error(String var1);

        public void error(String var1, Exception var2);
    }
}

