/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ustore;

import com.avaya.asm.core.AES;
import com.avaya.asm.core.AsmCommon;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DMUtilities;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreKeyspace;
import com.avaya.asm.datamgr.objectapi.AsmInstance;
import com.avaya.common.logging.client.Logger;
import java.io.IOException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.codec.DecoderException;

public class UstoreUtils {
    private static final Logger log = AsmLogger.getLogger(UstoreUtils.class);
    private static final AES aes = new AES();
    static final String foreignDomain = "@__foreign__";
    static Pattern foreignDomainPat = Pattern.compile("@__foreign__");

    public static String formatTime(long total_ms) {
        long h = total_ms / 3600000L;
        long m = total_ms / 60000L % 60L;
        long s = total_ms / 1000L % 60L;
        long ms = total_ms % 1000L;
        StringBuilder sb = new StringBuilder();
        if (h > 0L) {
            sb.append(String.format("%2d:", h));
        }
        if (m > 0L || h > 0L) {
            sb.append(String.format(h > 0L ? "%02d:" : "%d:", m));
        }
        if (s > 0L || m > 0L || h > 0L) {
            sb.append(String.format(h > 0L || m > 0L ? "%02d." : "%d.", s));
        }
        sb.append(String.format(s > 0L || m > 0L || h > 0L ? "%03d" : "%d", ms));
        return sb.toString();
    }

    public static boolean equalStrings(String str1, String str2) {
        return UstoreUtils.equalObjects(str1, str2);
    }

    public static boolean equalObjects(Object obj1, Object obj2) {
        if (obj1 == null) {
            if (obj2 == null) {
                return true;
            }
        } else if (obj2 != null) {
            return obj1.equals(obj2);
        }
        return false;
    }

    public static boolean isValidData(String testStr) {
        return testStr != null && !testStr.isEmpty();
    }

    public static ByteBuffer returnByteBuffer(String line) throws Exception {
        ByteBuffer byteBuffer = null;
        byte[] byteArray = new byte[line.length() / 2];
        for (int i = 0; i < line.length(); i += 2) {
            try {
                int parsedInt = Integer.parseInt(line.substring(i, i + 2), 16);
                if (parsedInt < 0 || i > 255) {
                    throw new NumberFormatException("Value out of range. Value:\"" + line.substring(i, i + 2));
                }
                byteArray[i / 2] = (byte)parsedInt;
                continue;
            }
            catch (Exception e) {
                return byteBuffer;
            }
        }
        return ByteBuffer.wrap(byteArray);
    }

    public static String getUserScopedKeyspaceName(List<AsmInstance> instances) {
        String fcn_name = "getUserScopedKeyspaceName";
        boolean isFiner = log.isFinerEnabled();
        UserStoreKeyspace keyspace = new UserStoreKeyspace(instances);
        if (isFiner) {
            log.finer((Object)("getUserScopedKeyspaceName: keyspace name = " + keyspace.toString()));
        }
        return keyspace.toString();
    }

    public static void setEnvClientUserPasswordFromEncrypted(String enSuperUserName, String enSuperUserPasswd, String enUserName, String enUserPasswd, Map<String, String> envMap) {
        String superUserName = null;
        String superUserPasswd = null;
        String userName = null;
        String userPasswd = null;
        String fcn_name = "setEnvClientUserPasswordFromEncrypted";
        boolean isFiner = log.isFinerEnabled();
        if (isFiner) {
            log.finer((Object)"setEnvClientUserPasswordFromEncrypted, enter");
        }
        if ((superUserName = UstoreUtils.decryptCredentials(enSuperUserName)) == null) {
            log.error((Object)("setEnvClientUserPasswordFromEncrypted: cannot decrypt superUserName: " + enSuperUserName));
        }
        superUserPasswd = UstoreUtils.decryptCredentials(enSuperUserPasswd);
        if (superUserName == null) {
            log.error((Object)("setEnvClientUserPasswordFromEncrypted: cannot decrypt superUserPasswd: " + enSuperUserPasswd));
        }
        userName = UstoreUtils.decryptCredentials(enUserName);
        if (superUserName == null) {
            log.error((Object)("setEnvClientUserPasswordFromEncrypted: cannot decrypt userName: " + enUserName));
        }
        if ((userPasswd = UstoreUtils.decryptCredentials(enUserPasswd)) == null) {
            log.error((Object)("setEnvClientUserPasswordFromEncrypted: cannot decrypt superUserPasswd: " + enUserPasswd));
        }
        UstoreUtils.setEnvClientUserPassword(superUserName, superUserPasswd, userName, userPasswd, envMap);
        if (isFiner) {
            log.finer((Object)("setEnvClientUserPasswordFromEncrypted, leave, envMap.size=" + envMap.size()));
        }
    }

    public static void setEnvClientUserPassword(String superUserName, String superUserPasswd, String userName, String userPasswd, Map<String, String> envMap) {
        String fcn_name = "setEnvClientUserPassword";
        boolean isFiner = log.isFinerEnabled();
        if (isFiner) {
            log.finer((Object)"setEnvClientUserPassword, enter");
        }
        envMap.put("CASSANDRA_USER", userName);
        envMap.put("CASSANDRA_PASSWORD", userPasswd);
        envMap.put("CASSANDRA_SUPER_USER", superUserName);
        envMap.put("CASSANDRA_SUPER_PASSWORD", superUserPasswd);
        if (isFiner) {
            log.finer((Object)("setEnvClientUserPassword, leave, envMap.size=" + envMap.size()));
        }
    }

    public static String decryptCredentials(String cred) {
        String fcn_name = "decryptCredentials";
        String decryptCred = null;
        try {
            decryptCred = aes.decrypt(cred);
        }
        catch (IOException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException | DecoderException e) {
            log.error((Object)"decryptCredentials: error decrypting credential", e);
        }
        return decryptCred;
    }

    public static String removeForeignDomain(String handle) {
        if (handle == null) {
            return null;
        }
        Matcher matcher = foreignDomainPat.matcher(handle);
        return matcher.replaceAll("");
    }

    public static String asmInstanceToIpAddr(AsmInstance instance) throws DMException {
        List<String> addresses;
        String fcn_name = "asmInstanceToIpAddr";
        try {
            addresses = AsmCommon.realDNSResolve(instance.getManagementAccessPointHostName());
        }
        catch (UnknownHostException e) {
            throw new DMException("asmInstanceToIpAddr: FQDN/IP address from AsmInstance with an unresolvable address", e);
        }
        return addresses.get(0);
    }

    public static boolean isUstoreContactOperationAllowed() {
        boolean isBranchSM = DMUtilities.isBranch();
        boolean isAADSConfigured = DMUtilities.isApplicationConfigured("Avaya Aura Device Services");
        return !isBranchSM && isAADSConfigured;
    }

    static boolean is96x1Model(String model) {
        boolean retVal = false;
        if (model != null) {
            switch (model) {
                case "9601": 
                case "9608": 
                case "9611": 
                case "9621": 
                case "9641": {
                    retVal = true;
                    break;
                }
                default: {
                    retVal = false;
                }
            }
        }
        return retVal;
    }

    static boolean isJ1x9Model(String model) {
        boolean retVal = false;
        if (model != null) {
            int modelLength = model.length();
            if (model.startsWith("J1") && (model.endsWith("9") || model.endsWith("9CC")) && (modelLength == "J1X9".length() || modelLength == "J1X9CC".length())) {
                retVal = true;
            }
        }
        return retVal;
    }

    public static String getGenericDeviceModel(String vendor, String model) {
        String genericDeviceModel = model;
        if (vendor != null && model != null && vendor.equals("Avaya")) {
            if (UstoreUtils.is96x1Model(model)) {
                genericDeviceModel = "96x1";
            } else if (UstoreUtils.isJ1x9Model(model)) {
                genericDeviceModel = "J100";
            }
        }
        return genericDeviceModel;
    }

    public static String getDeviceHandleFromVendorModel(String vendor, String model) {
        StringBuilder retString = new StringBuilder();
        String separator = "@@";
        String genericDeviceModel = UstoreUtils.getGenericDeviceModel(vendor, model);
        retString.append("@@").append(vendor).append("@@").append(genericDeviceModel);
        return retString.toString();
    }
}

