/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.watchd.jft;

import com.avaya.asm.core.AsmLogger;
import com.avaya.common.logging.client.Logger;
import com.avaya.watchd.jft.WdConnection;
import com.avaya.watchd.jft.WdException;
import com.avaya.watchd.jft.WdReasonCodesEnum;
import com.avaya.watchd.jft.WdReturnCodesEnum;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class WdHeartBeat {
    String appName = null;
    int pid;
    Logger log = AsmLogger.getLogger(WdHeartBeat.class);
    private static String opCodeStr = String.valueOf(20);
    WdConnection conn = null;

    public WdHeartBeat(String appName) {
        this.appName = appName;
    }

    public WdHeartBeat() {
        this.appName = System.getenv("WD_APPNAME");
    }

    private void sendInitialHBeat(int hbeatTime) throws WdException {
        String fcn_name = "sendInitialHBeat";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finest((Object)("sendInitialHBeat: enter, hbeatTime=" + hbeatTime));
        }
        OutputStream ostream = null;
        try {
            ostream = this.conn.getOutputStream();
        }
        catch (IOException e) {
            this.log.error((Object)"sendInitialHBeat received IOException getting output stream", (Throwable)e);
            throw new WdException("sendInitialHBeat: getOutputStream() failed", WdReturnCodesEnum.WD_COMMUNICATION_ERROR, WdReasonCodesEnum.WD_SOCKET_ERROR, e);
        }
        try {
            ostream.write(opCodeStr.getBytes());
            ostream.flush();
        }
        catch (IOException e) {
            this.log.error((Object)"sendInitialHBeat received IOException write of opcode", (Throwable)e);
            throw new WdException("sendInitialHBeat: ostream.write/flush failed for opcode", WdReturnCodesEnum.WD_COMMUNICATION_ERROR, WdReasonCodesEnum.WD_SOCKET_ERROR, e);
        }
        int appNameLength = this.appName.length() + 1;
        ByteBuffer bb = this.allocateByteBuffer(4);
        bb.putInt(appNameLength);
        try {
            ostream.write(bb.array());
            ostream.flush();
            ostream.write(this.appName.getBytes());
            ostream.write(0);
            ostream.flush();
        }
        catch (IOException e) {
            this.log.error((Object)"sendInitialHBeat received IOException for length or appName", (Throwable)e);
            throw new WdException("sendInitialHBeat: ostream.write/flush failed for appName and length", WdReturnCodesEnum.WD_COMMUNICATION_ERROR, WdReasonCodesEnum.WD_SOCKET_ERROR, e);
        }
        this.sendHBeat(hbeatTime);
        if (isFiner) {
            this.log.finest((Object)"sendInitialHBeat: leave");
        }
    }

    private void sendHBeat(int hbeatTime) throws WdException {
        String fcn_name = "sendHBeat";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("sendHBeat: enter, hbeatTime=" + hbeatTime));
        }
        try {
            OutputStream ostream = this.conn.getOutputStream();
            ByteBuffer bb = this.allocateByteBuffer(4);
            bb.putInt(hbeatTime);
            ostream.write(bb.array());
            ostream.flush();
        }
        catch (IOException e) {
            this.log.error((Object)"sendHBeat received IOException for sending hbeatTime", (Throwable)e);
            throw new WdException("sendHBeat: ostream.write/flush failed for hbeatTime", WdReturnCodesEnum.WD_COMMUNICATION_ERROR, WdReasonCodesEnum.WD_SOCKET_ERROR, e);
        }
        if (isFiner) {
            this.log.finer((Object)"sendHBeat: leave");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Send(int hbeatTime) throws WdException {
        if (this.conn == null) {
            WdHeartBeat wdHeartBeat = this;
            synchronized (wdHeartBeat) {
                this.conn = new WdConnection();
                this.conn.Open();
                this.sendInitialHBeat(hbeatTime);
            }
        } else {
            this.sendHBeat(hbeatTime);
        }
    }

    public void Close() throws WdException {
        if (this.conn != null) {
            this.conn.Close();
            this.conn = null;
        }
    }

    ByteBuffer allocateByteBuffer(int size) {
        ByteBuffer bb = ByteBuffer.allocate(4);
        if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
            bb.order(ByteOrder.LITTLE_ENDIAN);
        }
        return bb;
    }
}

