/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.common.logging.client;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.Level;

public class LogLevel {
    private static final long serialVersionUID = 1L;
    public static final int FINEST_INT = Level.DEBUG.intLevel() - 20;
    public static final int FINER_INT = Level.DEBUG.intLevel() - 10;
    public static final int FINE_INT = Level.DEBUG.intLevel();
    public static final LogLevel FINEST;
    public static final LogLevel FINER;
    public static final LogLevel FINE;
    public static final LogLevel OFF;
    public static final LogLevel FATAL;
    public static final LogLevel ERROR;
    public static final LogLevel WARN;
    public static final LogLevel INFO;
    public static final LogLevel DEBUG;
    public static final LogLevel TRACE;
    public static final LogLevel ALL;
    private static final ConcurrentMap<String, Level> LEVELS;
    private Level log4jLevel;

    private LogLevel(String name) {
        this.log4jLevel = (Level)LEVELS.get(name);
    }

    public Level getLo4jLevel() {
        return this.log4jLevel;
    }

    public int intLevel() {
        return this.log4jLevel.intLevel();
    }

    static {
        LEVELS = new ConcurrentHashMap<String, Level>();
        LEVELS.put("OFF", Level.OFF);
        LEVELS.put("FATAL", Level.FATAL);
        LEVELS.put("ERROR", Level.ERROR);
        LEVELS.put("WARN", Level.WARN);
        LEVELS.put("INFO", Level.INFO);
        LEVELS.put("DEBUG", Level.DEBUG);
        LEVELS.put("FINEST", Level.forName((String)"FINEST", (int)FINEST_INT));
        LEVELS.put("FINER", Level.forName((String)"FINER", (int)FINER_INT));
        LEVELS.put("FINE", Level.forName((String)"FINE", (int)FINE_INT));
        LEVELS.put("TRACE", Level.TRACE);
        LEVELS.put("ALL", Level.ALL);
        FINEST = new LogLevel("FINEST");
        FINER = new LogLevel("FINER");
        FINE = new LogLevel("FINE");
        OFF = new LogLevel("OFF");
        FATAL = new LogLevel("FATAL");
        ERROR = new LogLevel("ERROR");
        WARN = new LogLevel("WARN");
        INFO = new LogLevel("INFO");
        DEBUG = new LogLevel("DEBUG");
        TRACE = new LogLevel("TRACE");
        ALL = new LogLevel("ALL");
    }
}

