/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.common.logging.client;

import com.avaya.common.logging.client.CommonLogManager;
import com.avaya.common.logging.client.LogLevel;
import com.avaya.common.logging.helper.EventCode;
import com.avaya.common.logging.helper.EventMsg;
import com.avaya.common.logging.helper.LogRecordJDO;
import java.rmi.server.UID;
import java.util.TimeZone;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;

public class Logger {
    static StringBuilder FQCN = new StringBuilder(Logger.class.getName());
    protected org.apache.logging.log4j.Logger log4jLogger;
    private StringBuilder logJDO = null;

    public static Logger getLogger(String aName) {
        return CommonLogManager.getLogger(aName);
    }

    public static Logger getLogger(Class<?> aClass) {
        return CommonLogManager.getLogger(aClass.getName());
    }

    public static Logger getLogger(String aName, UID jdoId) {
        return CommonLogManager.getLogger(aName, jdoId);
    }

    public static Logger getLogger(Class<?> aClass, UID jdoId) {
        return CommonLogManager.getLogger(aClass.getName(), jdoId);
    }

    public static Logger getRootLogger() {
        return CommonLogManager.getRootLogger();
    }

    protected Logger(String aName) {
        this.log4jLogger = LogManager.getLogger((String)aName);
    }

    protected Logger() {
        this.log4jLogger = LogManager.getRootLogger();
    }

    protected LogRecordJDO getLogRecordJDO() {
        return CommonLogManager.getLogRecordJDO(this.logJDO.toString());
    }

    protected void initializeJDO(String hostname, String processId, String processName, String logProductType) {
        if (this.logJDO == null) {
            this.logJDO = new StringBuilder(this.log4jLogger.getName());
        }
        LogRecordJDO logRecordJDO = CommonLogManager.getLogRecordJDO(this.logJDO.toString());
        logRecordJDO.setHostname(hostname);
        logRecordJDO.setProcessId(processId);
        logRecordJDO.setProcessName(processName);
        logRecordJDO.setLogProductType(logProductType);
        CommonLogManager.updateLogRecordJDO(this.logJDO.toString(), logRecordJDO);
    }

    protected void setJDO(String jdoId) {
        this.logJDO = new StringBuilder(jdoId);
    }

    public void error(Object aMsg) {
        this.error(aMsg, null);
    }

    public void error(Object aMsg, Throwable aThrowable) {
        this.log(aMsg, aThrowable, LogLevel.ERROR);
    }

    public void trace(Object aMsg) {
        this.trace(aMsg, null);
    }

    public void trace(Object aMsg, Throwable aThrowable) {
        this.log(aMsg, aThrowable, LogLevel.TRACE);
    }

    public void debug(Object aMsg) {
        this.debug(aMsg, null);
    }

    public void debug(Object aMsg, Throwable aThrowable) {
        this.log(aMsg, aThrowable, LogLevel.DEBUG);
    }

    public void fatal(Object aMsg) {
        this.fatal(aMsg, null);
    }

    public void fatal(Object aMsg, Throwable aThrowable) {
        this.log(aMsg, aThrowable, LogLevel.FATAL);
    }

    public void fine(Object aMsg) {
        this.fine(aMsg, null);
    }

    public void fine(Object aMsg, Throwable aThrowable) {
        this.log(aMsg, aThrowable, LogLevel.FINE);
    }

    public void finer(Object aMsg) {
        this.finer(aMsg, null);
    }

    public void finer(Object aMsg, Throwable aThrowable) {
        this.log(aMsg, aThrowable, LogLevel.FINER);
    }

    public void finest(Object aMsg) {
        this.finest(aMsg, null);
    }

    public void finest(Object aMsg, Throwable aThrowable) {
        this.log(aMsg, aThrowable, LogLevel.FINEST);
    }

    public void info(Object aMsg) {
        this.info(aMsg, null);
    }

    public void info(Object aMsg, Throwable aThrowable) {
        this.log(aMsg, aThrowable, LogLevel.INFO);
    }

    public void warn(Object aMsg) {
        this.warn(aMsg, null);
    }

    public void warn(Object aMsg, Throwable aThrowable) {
        this.log(aMsg, aThrowable, LogLevel.WARN);
    }

    public boolean isEnabledFor(LogLevel level) {
        return this.log4jLogger.isEnabled(level.getLo4jLevel());
    }

    public boolean isFineEnabled() {
        return this.log4jLogger.isEnabled(LogLevel.FINE.getLo4jLevel());
    }

    public boolean isDebugEnabled() {
        return this.log4jLogger.isDebugEnabled();
    }

    public boolean isFinerEnabled() {
        return this.log4jLogger.isEnabled(LogLevel.FINER.getLo4jLevel());
    }

    public boolean isFinestEnabled() {
        return this.log4jLogger.isEnabled(LogLevel.FINEST.getLo4jLevel());
    }

    public boolean isInfoEnabled() {
        return this.log4jLogger.isEnabled(Level.INFO);
    }

    public void logEvent(EventCode eventCode, Object ... aArgument) {
        EventMsg eventMsg = new EventMsg(eventCode, aArgument);
        this.log(eventMsg, null, eventCode.getLogLevel());
    }

    public void logEvent(EventCode eventCode, Throwable aThrowable, Object ... aArgument) {
        EventMsg eventMsg = new EventMsg(eventCode, aArgument);
        this.log(eventMsg, aThrowable, eventCode.getLogLevel());
    }

    protected void log(Object aMsg, Throwable aThrowable, LogLevel logLevel) {
        int syslogEquivalent = this.getSyslogEquivalent(logLevel.getLo4jLevel());
        if (aMsg instanceof LogRecordJDO) {
            ((LogRecordJDO)aMsg).setSeverity(syslogEquivalent);
            this.log4jLogger.log(logLevel.getLo4jLevel(), aMsg, aThrowable);
        } else {
            LogRecordJDO logMessage = CommonLogManager.getLogRecordJDO(this.logJDO.toString());
            logMessage.setLogMessage(aMsg);
            logMessage.setSeverity(syslogEquivalent);
            CommonLogManager.updateInstanceLogRecordJDO(this.logJDO.toString(), logMessage);
            this.log4jLogger.log(logLevel.getLo4jLevel(), aMsg, aThrowable);
        }
    }

    private int getSyslogEquivalent(Level logLevel) {
        switch (logLevel.getStandardLevel()) {
            case OFF: 
            case FATAL: {
                return 0;
            }
            case ERROR: {
                return 3;
            }
            case WARN: {
                return 4;
            }
            case INFO: {
                return 6;
            }
            case DEBUG: 
            case TRACE: 
            case ALL: {
                return 7;
            }
        }
        return 0;
    }

    public void setHostname(String hostname) {
        LogRecordJDO logRecordJDO = CommonLogManager.getLogRecordJDO(this.logJDO.toString());
        logRecordJDO.setHostname(hostname);
        CommonLogManager.updateLogRecordJDO(this.logJDO.toString(), logRecordJDO);
    }

    public void setInstanceHostname(String hostname) {
        LogRecordJDO logRecordJDO = CommonLogManager.getLogRecordJDO(this.logJDO.toString());
        logRecordJDO.setHostname(hostname);
        CommonLogManager.updateInstanceLogRecordJDO(this.logJDO.toString(), logRecordJDO);
    }

    public String getHostname() {
        LogRecordJDO logRecordJDO = CommonLogManager.getLogRecordJDO(this.logJDO.toString());
        return logRecordJDO.getHostname();
    }

    public String getInstanceHostname() {
        LogRecordJDO logRecordJDO = CommonLogManager.getLogRecordJDO(this.logJDO.toString());
        return logRecordJDO.getHostname();
    }

    public void setProcessId(String processId) {
        LogRecordJDO logRecordJDO = CommonLogManager.getLogRecordJDO(this.logJDO.toString());
        logRecordJDO.setProcessId(processId);
        CommonLogManager.updateLogRecordJDO(this.logJDO.toString(), logRecordJDO);
    }

    public String getProcessId() {
        LogRecordJDO logRecordJDO = CommonLogManager.getLogRecordJDO(this.logJDO.toString());
        return logRecordJDO.getProcessId();
    }

    public void setInstanceProcessId(String processId) {
        LogRecordJDO logRecordJDO = CommonLogManager.getLogRecordJDO(this.logJDO.toString());
        logRecordJDO.setProcessId(processId);
        CommonLogManager.updateInstanceLogRecordJDO(this.logJDO.toString(), logRecordJDO);
    }

    public String getInstanceProcessId() {
        LogRecordJDO logRecordJDO = CommonLogManager.getLogRecordJDO(this.logJDO.toString());
        return logRecordJDO.getProcessId();
    }

    public void setProcessName(String processName) {
        LogRecordJDO logRecordJDO = CommonLogManager.getLogRecordJDO(this.logJDO.toString());
        logRecordJDO.setProcessName(processName);
        CommonLogManager.updateLogRecordJDO(this.logJDO.toString(), logRecordJDO);
    }

    public String getProcessName() {
        LogRecordJDO logRecordJDO = CommonLogManager.getLogRecordJDO(this.logJDO.toString());
        return logRecordJDO.getProcessName();
    }

    public void setInstanceProcessName(String processName) {
        LogRecordJDO logRecordJDO = CommonLogManager.getLogRecordJDO(this.logJDO.toString());
        logRecordJDO.setProcessName(processName);
        CommonLogManager.updateInstanceLogRecordJDO(this.logJDO.toString(), logRecordJDO);
    }

    public String getInstanceProcessName() {
        LogRecordJDO logRecordJDO = CommonLogManager.getLogRecordJDO(this.logJDO.toString());
        return logRecordJDO.getProcessName();
    }

    public void setLogProductType(String logProductType) {
        LogRecordJDO logRecordJDO = CommonLogManager.getLogRecordJDO(this.logJDO.toString());
        logRecordJDO.setLogProductType(logProductType);
        CommonLogManager.updateLogRecordJDO(this.logJDO.toString(), logRecordJDO);
    }

    public String getLogProductType() {
        LogRecordJDO logRecordJDO = CommonLogManager.getLogRecordJDO(this.logJDO.toString());
        return logRecordJDO.getLogProductType();
    }

    public void setInstanceLogProductType(String logProductType) {
        LogRecordJDO logRecordJDO = CommonLogManager.getLogRecordJDO(this.logJDO.toString());
        logRecordJDO.setLogProductType(logProductType);
        CommonLogManager.updateInstanceLogRecordJDO(this.logJDO.toString(), logRecordJDO);
    }

    public String getInstanceLogProductType() {
        LogRecordJDO logRecordJDO = CommonLogManager.getLogRecordJDO(this.logJDO.toString());
        return logRecordJDO.getLogProductType();
    }

    public void setTimeZone(TimeZone timeZone) {
        LogRecordJDO logRecordJDO = CommonLogManager.getLogRecordJDO(this.logJDO.toString());
        logRecordJDO.setTimeZone(timeZone);
        CommonLogManager.updateLogRecordJDO(this.logJDO.toString(), logRecordJDO);
    }

    public TimeZone getTimeZone() {
        LogRecordJDO logRecordJDO = CommonLogManager.getLogRecordJDO(this.logJDO.toString());
        return logRecordJDO.getTimeZone();
    }

    public void setInstanceTimeZone(TimeZone timeZone) {
        LogRecordJDO logRecordJDO = CommonLogManager.getLogRecordJDO(this.logJDO.toString());
        logRecordJDO.setTimeZone(timeZone);
        CommonLogManager.updateInstanceLogRecordJDO(this.logJDO.toString(), logRecordJDO);
    }

    public TimeZone getInstanceTimeZone() {
        LogRecordJDO logRecordJDO = CommonLogManager.getLogRecordJDO(this.logJDO.toString());
        return logRecordJDO.getTimeZone();
    }
}

