/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.common.logging.helper;

import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class ResourceBundleLoader {
    static HashMap<String, ResourceBundle> resourceBundles = new HashMap();
    static HashMap<String, Long> fileModificationTimes = new HashMap();
    ResourceBundle rBundle = null;
    URL urlResource = null;
    StringBuilder resourceProtocol = new StringBuilder("");
    StringBuilder resourceFilename = new StringBuilder("");
    long modificationTime = -1L;

    public ResourceBundle load(String resource) {
        StringBuilder resourceName = new StringBuilder(this.formatResourceName(resource));
        this.getResource(resourceName.toString());
        this.rBundle = resourceBundles.get(resourceName.toString());
        if (this.rBundle == null) {
            this.loadResource(resourceName.toString());
        } else if (this.resourceProtocol.toString().equals("file")) {
            Long HMModTime;
            File resource_file = new File(this.resourceFilename.toString());
            if (resource_file.exists() && resource_file.canRead()) {
                this.modificationTime = resource_file.lastModified();
            }
            if ((HMModTime = fileModificationTimes.get(resourceName)) == null || this.modificationTime > HMModTime) {
                this.loadResource(resourceName.toString());
            }
        }
        return this.rBundle;
    }

    private String formatResourceName(String name) {
        StringBuffer returnStr = new StringBuffer();
        returnStr.append(name.replace('.', '/')).append(".properties");
        return returnStr.toString();
    }

    private void getResource(String resourceName) {
        this.urlResource = this.getClass().getClassLoader().getResource(resourceName);
        try {
            this.resourceProtocol = new StringBuilder(this.urlResource.getProtocol());
            this.resourceFilename = new StringBuilder(URLDecoder.decode(this.urlResource.getFile(), "UTF-16"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadResource(String resourceName) {
        try {
            this.rBundle = new PropertyResourceBundle(this.getClass().getClassLoader().getResourceAsStream(resourceName));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.rBundle == null) {
            throw new MissingResourceException("Missing Property file:", this.getClass().getSimpleName(), resourceName);
        }
        resourceBundles.put(resourceName, this.rBundle);
        if (this.urlResource.getProtocol().equals("file")) {
            if (this.modificationTime == -1L) {
                File resource_file = new File(this.resourceFilename.toString());
                this.modificationTime = resource_file.lastModified();
            }
            fileModificationTimes.put(resourceName, this.modificationTime);
        }
    }

    public static void main(String[] args) {
        ResourceBundleLoader rbl = new ResourceBundleLoader();
        rbl.load("com.avaya.EventCodes");
    }
}

