/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.collaboration.util.logger;

import com.avaya.asm.datamgr.DMFactory;
import com.avaya.collaboration.util.logger.EventCode;
import com.avaya.common.logging.client.CommonLogManager;
import com.avaya.common.logging.client.ExtendedCommonLogger;
import com.avaya.common.logging.client.LogLevel;
import com.avaya.commons.lang.ArgAssert;
import com.avaya.zephyr.platform.dal.api.ServiceDescriptor;
import com.avaya.zephyr.platform.dal.api.ServiceUtil;
import com.avaya.zephyr.platform.dao.AusInstanceDAO;
import com.avaya.zephyr.platform.dm.ZephyrDM;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class Logger
extends ExtendedCommonLogger {
    private static final String SERVICE_EVENT_LOGGER = "com.avaya.serviceEventing";
    static String log4jPropertiesDir = "/opt/Avaya/Common/conf";
    static String log4jPropertiesFile = "log4j2.properties";
    private static final String FQCN = Logger.class.getName();
    private static final String DENY_NS_MSG = "Deny New Service State - ";
    private static final ConcurrentMap<Integer, String> CLASSLOADER_SERVICEIDENTITY_MAP = new ConcurrentHashMap<Integer, String>();
    private static final ConcurrentMap<Logger, Integer> LOGGER_CLASSLOADER_MAP = new ConcurrentHashMap<Logger, Integer>();
    private static final String EMPTY_STR = "";
    private static final String MESSAGE = "message";
    private String serviceName;
    private String prefix = "";
    private com.avaya.common.logging.client.Logger eventLogger = null;

    public Logger(String loggerType) {
        super(loggerType);
    }

    public static Logger getLogger(Class<?> classInstance) {
        ArgAssert.assertNotNull(classInstance, (String)"classInstance");
        Integer classLoaderHashCode = classInstance.getClassLoader().hashCode();
        Logger smcLogger = Logger.getServiceLogger(classInstance);
        LOGGER_CLASSLOADER_MAP.put(smcLogger, classLoaderHashCode);
        return smcLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getLogger(String serviceName) {
        Logger smcLogger;
        ArgAssert.assertNotNull((Object)serviceName, (String)"serviceName");
        if (Logger.checkAppender(serviceName)) {
            ConcurrentMap concurrentMap = extendedLoggerMap;
            synchronized (concurrentMap) {
                try {
                    smcLogger = (Logger)Logger.getPrivateLogger(serviceName, null);
                }
                catch (Exception e) {
                    extendedLoggerMap.remove(serviceName);
                    smcLogger = (Logger)Logger.getPrivateLogger(serviceName, null);
                }
            }
            smcLogger.setServiceName(serviceName);
            smcLogger.setPrefix(serviceName + " - ");
        } else {
            smcLogger = Logger.getServiceLogger(null);
            Integer classLoaderHashCode = Thread.currentThread().getContextClassLoader().hashCode();
            LOGGER_CLASSLOADER_MAP.put(smcLogger, classLoaderHashCode);
        }
        return smcLogger;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean checkAppender(String serviceName) {
        File file = new File(log4jPropertiesDir, log4jPropertiesFile);
        try (FileReader fileReader = new FileReader(file);
             BufferedReader br = new BufferedReader(fileReader);){
            String line = null;
            String needle = "logger." + serviceName + ".name=";
            do {
                if ((line = br.readLine()) == null) return false;
            } while (line.trim().startsWith("#") || !line.contains(needle));
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            System.err.println("Exception when looking for appender for " + serviceName);
            e.printStackTrace(System.err);
            return false;
        }
    }

    public void error(Object message) {
        ArgAssert.assertNotNull((Object)message, (String)MESSAGE);
        this.log(FQCN, LogLevel.ERROR, this.prefix + message, null);
    }

    public void error(Object message, Throwable throwable) {
        ArgAssert.assertNotNull((Object)message, (String)MESSAGE);
        ArgAssert.assertNotNull((Object)throwable, (String)"throwable");
        this.log(FQCN, LogLevel.ERROR, this.prefix + message, throwable);
    }

    public void fatal(Object message) {
        ArgAssert.assertNotNull((Object)message, (String)MESSAGE);
        this.log(FQCN, LogLevel.FATAL, this.prefix + message, null);
    }

    public void fatal(Object message, Throwable throwable) {
        ArgAssert.assertNotNull((Object)message, (String)MESSAGE);
        ArgAssert.assertNotNull((Object)throwable, (String)"throwable");
        this.log(FQCN, LogLevel.FATAL, this.prefix + message, throwable);
    }

    public void fine(Object message) {
        ArgAssert.assertNotNull((Object)message, (String)MESSAGE);
        this.log(FQCN, LogLevel.FINE, this.prefix + message, null);
    }

    public void fine(Object message, Throwable throwable) {
        ArgAssert.assertNotNull((Object)message, (String)MESSAGE);
        ArgAssert.assertNotNull((Object)throwable, (String)"throwable");
        this.log(FQCN, LogLevel.FINE, this.prefix + message, throwable);
    }

    public void finer(Object message) {
        ArgAssert.assertNotNull((Object)message, (String)MESSAGE);
        this.log(FQCN, LogLevel.FINER, this.prefix + message, null);
    }

    public void finer(Object message, Throwable throwable) {
        ArgAssert.assertNotNull((Object)message, (String)MESSAGE);
        ArgAssert.assertNotNull((Object)throwable, (String)"throwable");
        this.log(FQCN, LogLevel.FINER, this.prefix + message, throwable);
    }

    public void finest(Object message) {
        ArgAssert.assertNotNull((Object)message, (String)MESSAGE);
        this.log(FQCN, LogLevel.FINEST, this.prefix + message, null);
    }

    public void finest(Object message, Throwable throwable) {
        ArgAssert.assertNotNull((Object)message, (String)MESSAGE);
        ArgAssert.assertNotNull((Object)throwable, (String)"throwable");
        this.log(FQCN, LogLevel.FINEST, this.prefix + message, throwable);
    }

    public void info(Object message) {
        ArgAssert.assertNotNull((Object)message, (String)MESSAGE);
        this.log(FQCN, LogLevel.INFO, this.prefix + message, null);
    }

    public void info(Object message, Throwable throwable) {
        ArgAssert.assertNotNull((Object)message, (String)MESSAGE);
        ArgAssert.assertNotNull((Object)throwable, (String)"throwable");
        this.log(FQCN, LogLevel.INFO, this.prefix + message, throwable);
    }

    public void warn(Object message, Throwable throwable) {
        ArgAssert.assertNotNull((Object)message, (String)MESSAGE);
        ArgAssert.assertNotNull((Object)throwable, (String)"throwable");
        this.log(FQCN, LogLevel.WARN, this.prefix + message, throwable);
    }

    public void warn(Object message) {
        ArgAssert.assertNotNull((Object)message, (String)MESSAGE);
        this.log(FQCN, LogLevel.WARN, this.prefix + message, null);
    }

    public boolean isFineEnabled() {
        return super.isEnabledFor(LogLevel.FINE);
    }

    public boolean isFinerEnabled() {
        return super.isEnabledFor(LogLevel.FINER);
    }

    public boolean isFinestEnabled() {
        return super.isEnabledFor(LogLevel.FINEST);
    }

    public boolean isInfoEnabled() {
        return super.isEnabledFor(LogLevel.INFO);
    }

    final void logEvent(EventCode eventCode, Object ... argument) {
        ArgAssert.assertNotNull((Object)eventCode, (String)"eventCode");
        this.logEvent(eventCode.getCommonEventCode(), argument);
    }

    final void logEvent(EventCode eventCode, Throwable throwable, Object ... argument) {
        ArgAssert.assertNotNull((Object)eventCode, (String)"eventCode");
        ArgAssert.assertNotNull((Object)throwable, (String)"throwable");
        this.logEvent(eventCode.getCommonEventCode(), throwable, argument);
    }

    public final void logEvent(String eventId, Object ... argument) {
        ArgAssert.assertNotNull((Object)eventId, (String)"eventCode");
        String finalEventCode = this.serviceName != null && this.serviceName.length() > 0 ? this.serviceName + "_" + eventId : eventId;
        if (this.isAdminsteredDenyNewService()) {
            Logger.getLogger(this.serviceName).info(DENY_NS_MSG + finalEventCode);
            return;
        }
        if (this.eventLogger == null) {
            this.eventLogger = CommonLogManager.getLogger((String)SERVICE_EVENT_LOGGER);
            CommonLogManager.initializeJDO((String)SERVICE_EVENT_LOGGER, (String)Logger.getHostName(), (String)Logger.getProcessID(), (String)this.getServiceName(), (TimeZone)TimeZone.getDefault(), (String)"com.avaya.ceservices");
            this.eventLogger.setLogProductType("com.avaya.ceservices");
        }
        com.avaya.common.logging.helper.EventCode eventCode = new com.avaya.common.logging.helper.EventCode(finalEventCode, "com.avaya.ceservices", LogLevel.INFO);
        this.eventLogger.logEvent(eventCode, argument);
    }

    static void setServiceIdentity(Class<?> classInstance, Object prefixMessage) {
        CLASSLOADER_SERVICEIDENTITY_MAP.put(classInstance.getClassLoader().hashCode(), prefixMessage.toString());
    }

    static void removeServiceIdentity(Class<?> classInstance) {
        Integer classLoaderHashCode = classInstance.getClassLoader().hashCode();
        CLASSLOADER_SERVICEIDENTITY_MAP.remove(classLoaderHashCode);
        Iterator iter = LOGGER_CLASSLOADER_MAP.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (classLoaderHashCode.intValue() != ((Integer)entry.getValue()).intValue()) continue;
            iter.remove();
        }
    }

    final String getPrefix() {
        Integer classLoaderHashCode = (Integer)LOGGER_CLASSLOADER_MAP.get((Object)this);
        if (classLoaderHashCode != null) {
            String prefixStr = (String)CLASSLOADER_SERVICEIDENTITY_MAP.get(classLoaderHashCode);
            if (prefixStr == null) {
                return EMPTY_STR;
            }
            return prefixStr;
        }
        return EMPTY_STR;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Logger getServiceLogger(Class<?> classInstance) {
        String serviceIdentity = Logger.getServiceIdentity(classInstance);
        String serviceName = Logger.getServiceName(serviceIdentity);
        String serviceVersion = Logger.getServiceVersion(serviceIdentity);
        int newHashCode = classInstance != null ? classInstance.getClassLoader().hashCode() : Thread.currentThread().getContextClassLoader().hashCode();
        if (serviceName != null) {
            String loggerKey = serviceName + "-" + serviceVersion;
            ConcurrentMap concurrentMap = extendedLoggerMap;
            synchronized (concurrentMap) {
                if (extendedLoggerMap.containsKey(loggerKey)) {
                    try {
                        return (Logger)((Object)extendedLoggerMap.get(loggerKey));
                    }
                    catch (ClassCastException e) {
                        extendedLoggerMap.remove(loggerKey);
                    }
                }
                String prefix = loggerKey + " - ";
                CLASSLOADER_SERVICEIDENTITY_MAP.putIfAbsent(newHashCode, prefix);
                Logger smcLogger = (Logger)Logger.getPrivateLogger(loggerKey, serviceName);
                smcLogger.setServiceName(serviceName);
                smcLogger.setPrefix(prefix);
                return smcLogger;
            }
        }
        ConcurrentMap concurrentMap = extendedLoggerMap;
        synchronized (concurrentMap) {
            String loggerKey = classInstance != null ? classInstance.getName() : EMPTY_STR;
            try {
                return (Logger)Logger.getPrivateLogger(loggerKey, null);
            }
            catch (ClassCastException e) {
                extendedLoggerMap.remove(loggerKey);
                return (Logger)Logger.getPrivateLogger(loggerKey, null);
            }
        }
    }

    private static String getServiceIdentity(Class<?> classInstance) {
        String serviceIdentity;
        ServiceDescriptor serviceDescriptor = ServiceUtil.getServiceDescriptor();
        if (serviceDescriptor != null) {
            serviceIdentity = serviceDescriptor.getName() + "-" + serviceDescriptor.getVersion();
        } else {
            int hashcode = classInstance != null ? classInstance.getClassLoader().hashCode() : Thread.currentThread().getContextClassLoader().hashCode();
            serviceIdentity = (String)CLASSLOADER_SERVICEIDENTITY_MAP.get(hashcode);
        }
        return serviceIdentity;
    }

    final String getServiceName() {
        return this.serviceName;
    }

    final void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    static String getServiceName(String serviceIdentity) {
        String serviceName = null;
        if (serviceIdentity != null && serviceIdentity.length() > 0) {
            if (serviceIdentity.endsWith(" - ")) {
                return Logger.getServiceName(serviceIdentity.substring(0, serviceIdentity.lastIndexOf(45)));
            }
            if (serviceIdentity.contains("(")) {
                serviceName = serviceIdentity.split("[()]")[0];
                serviceName = serviceName.trim();
            } else if (serviceIdentity.contains("-")) {
                serviceName = serviceIdentity.substring(0, serviceIdentity.lastIndexOf(45));
                serviceName = serviceName.trim();
            }
        }
        return serviceName;
    }

    final String getServiceVersion() {
        String prefixStr = this.getPrefix();
        return prefixStr == EMPTY_STR ? EMPTY_STR : Logger.getServiceVersion(prefixStr.substring(0, prefixStr.lastIndexOf(45)));
    }

    static String getServiceVersion(String serviceIdentity) {
        String serviceVersion = null;
        if (serviceIdentity != null && serviceIdentity.length() > 0) {
            if (serviceIdentity.endsWith(" - ")) {
                return Logger.getServiceVersion(serviceIdentity.substring(0, serviceIdentity.lastIndexOf(45)));
            }
            if (serviceIdentity.contains("(")) {
                serviceVersion = serviceIdentity.split("[()]")[1];
                serviceVersion = serviceVersion.trim();
            } else if (serviceIdentity.contains("-")) {
                serviceVersion = serviceIdentity.substring(serviceIdentity.lastIndexOf(45) + 1);
                serviceVersion = serviceVersion.trim();
            }
        }
        return serviceVersion;
    }

    private boolean isAdminsteredDenyNewService() {
        try {
            ZephyrDM zephyrDM = (ZephyrDM)DMFactory.getInstance().getDataMgr(ZephyrDM.class);
            AusInstanceDAO ausInstanceDAO = zephyrDM.getAusInstanceDAO();
            return ausInstanceDAO.getAdminedToDenyNewServiceFlag();
        }
        catch (Exception e) {
            if (this.serviceName != null) {
                Logger.getLogger(this.serviceName).warn("isAdminsteredDenyNewService : Could not get system Deny New Service State, returning false. Error = " + e.getMessage());
            } else {
                Logger.getLogger(Logger.class).warn("isAdminsteredDenyNewService : Could not get system Deny New Service State, returning false. Error = " + e.getMessage());
            }
            return false;
        }
    }
}

