/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.eclipse.plugin;

import com.avaya.eclipse.plugin.Activator;
import com.avaya.eclipse.plugin.ButtonCallbackAdapter;
import com.avaya.eclipse.plugin.CEDeploymentWindow;
import com.avaya.eclipse.plugin.PluginUtilities;
import com.avaya.eclipse.plugin.PropertyWindowEditor;
import com.avaya.eclipse.plugin.ServerTreeView;
import com.avaya.eclipse.plugin.model.ElementInfo;
import com.avaya.eclipse.plugin.model.TreeLoader;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class ServerTreeViewUiManager
implements IMenuListener,
Listener {
    private CheckboxTreeViewer viewer;
    private Shell shell;
    private MenuManager menuMgr;
    private static final String IPADDRESS_PATTERN = "^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$";

    public MenuManager getMenuMgr() {
        return this.menuMgr;
    }

    public ServerTreeViewUiManager(Shell shell, CheckboxTreeViewer viewer) {
        this.viewer = viewer;
        this.shell = shell;
        this.hookContextMenu();
    }

    public void hookContextMenu() {
        this.menuMgr = new MenuManager("#PopupMenu");
        this.menuMgr.setRemoveAllWhenShown(true);
        this.menuMgr.addMenuListener((IMenuListener)this);
        Menu menu = PluginUtilities.getInstance().hookContextMenu(this.menuMgr, this.viewer);
        this.viewer.getControl().setMenu(menu);
    }

    protected boolean validateIP(String ipAddr) {
        Pattern pattern = Pattern.compile(IPADDRESS_PATTERN);
        Matcher matcher = pattern.matcher(ipAddr);
        return matcher.matches();
    }

    public boolean isMultiSMGRNodesSelected() {
        ServerTreeView.Node selectTreeNode = (ServerTreeView.Node)((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
        List<ServerTreeView.Node> selectedNodes = TreeLoader.getInstance().getSelectedNodes();
        if (selectedNodes != null && !selectedNodes.isEmpty()) {
            int countSMGRSelected = this.countSMGRSelected(selectedNodes);
            return countSMGRSelected == 1 && this.isContains(selectedNodes, selectTreeNode);
        }
        return false;
    }

    private int countSMGRSelected(List<ServerTreeView.Node> selectedNodes) {
        int count = 0;
        for (ServerTreeView.Node node : selectedNodes) {
            if (node.getElementInfo().getServerType() != ElementInfo.ServerType.SMGR) continue;
            ++count;
        }
        return count;
    }

    private boolean isContains(List<ServerTreeView.Node> selectedNodes, ServerTreeView.Node selectTreeNode) {
        for (ServerTreeView.Node node : selectedNodes) {
            if (selectTreeNode.getData() == null || !selectTreeNode.getData().equals(node.getElementInfo().getIp())) continue;
            return true;
        }
        return false;
    }

    public void handleEvent(Event event) {
        for (MenuItem item : ((Menu)event.widget).getItems()) {
            if (!"Edit System".equals(item.getText())) continue;
            if (this.isMultiSMGRNodesSelected()) {
                PropertyWindowEditor.updateStatusLabel("");
                item.setEnabled(true);
                continue;
            }
            PropertyWindowEditor.updateStatusLabel("Please select single SMGR for enabling edit operation");
            item.setEnabled(false);
        }
    }

    public void menuAboutToShow(IMenuManager manager) {
        manager.add((IAction)new AddSystemManagerAction((TreeViewer)this.viewer));
        ServerTreeView.Node treeNode = (ServerTreeView.Node)((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
        if (treeNode != null) {
            manager.add((IAction)new EditSystemManagerAction((TreeViewer)this.viewer));
            manager.add((IAction)new RefreshAction((TreeViewer)this.viewer));
            manager.add((IAction)new ExpandAllAction((TreeViewer)this.viewer));
            ElementInfo ei = treeNode.getElementInfo();
            if (ei.getServerType() == ElementInfo.ServerType.SMGR) {
                manager.add((IAction)new RemoveSystemManagerAction((TreeViewer)this.viewer));
            }
        }
        if (this.menuMgr.getMenu() != null) {
            this.menuMgr.getMenu().addListener(22, (Listener)this);
        }
    }

    class ExpandAllAction
    extends Action {
        private TreeViewer parent;

        public ExpandAllAction(TreeViewer parent) {
            this.parent = parent;
            this.setText("Expand All");
            this.setToolTipText("Show all clusters and Avaya Breeze servers");
        }

        public void run() {
            List<ServerTreeView.Node> nodes = TreeLoader.getInstance().getSelectedNodes();
            for (ServerTreeView.Node node : nodes) {
                this.parent.expandToLevel((Object)node, -1);
            }
        }
    }

    class RefreshAction
    extends Action {
        private TreeViewer parent;

        public RefreshAction(TreeViewer parent) {
            this.parent = parent;
            this.setText("Refresh");
            this.setToolTipText("Refresh the details of this server");
        }

        public void run() {
            PropertyWindowEditor.updateStatusLabel("Refresh operation is in progress. Please wait for a while!");
            if (!PluginUtilities.getInstance().isDemoMode()) {
                BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MouseListener listener = new MouseListener(){

                            public void mouseUp(MouseEvent arg0) {
                            }

                            public void mouseDown(MouseEvent arg0) {
                            }

                            public void mouseDoubleClick(MouseEvent arg0) {
                            }
                        };
                        ServerTreeViewUiManager.this.shell.addMouseListener(listener);
                        List<ElementInfo> smgrElements = PropertyWindowEditor.getSMGREmements();
                        for (ElementInfo elementInfo : smgrElements) {
                            Activator.log(1, "Refreshing " + elementInfo);
                            TreeLoader.getInstance().refreshNode(elementInfo);
                        }
                        ServerTreeViewUiManager.this.viewer.refresh();
                        PluginUtilities.getInstance().setInput(ServerTreeViewUiManager.this.viewer, TreeLoader.getInstance().getRootNode());
                        ServerTreeViewUiManager.this.viewer.setCheckedElements(TreeLoader.getInstance().getSelectedNodes().toArray());
                        ServerTreeViewUiManager.this.shell.redraw();
                        RefreshAction.this.parent.refresh();
                        List<ServerTreeView.Node> nodes = TreeLoader.getInstance().getSelectedNodes();
                        for (ServerTreeView.Node node : nodes) {
                            RefreshAction.this.parent.expandToLevel((Object)node, -1);
                        }
                        RefreshAction.this.parent.getControl().setFocus();
                        ServerTreeViewUiManager.this.shell.removeMouseListener(listener);
                        PropertyWindowEditor.updateStatusLabel("Refresh operation completed!");
                    }
                });
            }
        }
    }

    class AddSystemManagerAction
    extends Action {
        private TreeViewer parent;

        public AddSystemManagerAction(TreeViewer parent) {
            this.parent = parent;
            this.setText("Add SMGR");
            this.setToolTipText("Add a new System Manager");
        }

        public void run() {
            final CEDeploymentWindow cedd = new CEDeploymentWindow(ServerTreeViewUiManager.this.shell, null, 340, 290);
            String[] properties = new String[]{"System Manager IP", "User Name (CLI User)", "Password (CLI User)", "SSH Port"};
            cedd.setProps(properties);
            Properties pDefault = new Properties();
            pDefault.setProperty("System Manager IP", "");
            pDefault.setProperty("User Name (CLI User)", "admin");
            pDefault.setProperty("Password (CLI User)", "admin");
            pDefault.setProperty("SSH Port", "22");
            cedd.setDfaultValues(pDefault);
            cedd.setUpdateCallback(new ButtonCallbackAdapter(ServerTreeViewUiManager.this.shell){

                @Override
                public void onUpdate(Properties props) {
                    if (!ServerTreeViewUiManager.this.validateIP(props.getProperty("System Manager IP"))) {
                        PluginUtilities.getInstance().openError(ServerTreeViewUiManager.this.shell, "Validation Error", "Please select valid SMGR ip address");
                        return;
                    }
                    cedd.close();
                    ElementInfo element = new ElementInfo();
                    element.setIp(props.getProperty("System Manager IP"));
                    element.setUserName(props.getProperty("User Name (CLI User)"));
                    element.setPassword(props.getProperty("Password (CLI User)"));
                    element.setPort(Integer.parseInt(props.getProperty("SSH Port")));
                    TreeLoader.getInstance().addNewNode(element);
                    ServerTreeViewUiManager.this.viewer.refresh();
                    ServerTreeViewUiManager.this.shell.redraw();
                    PluginUtilities.getInstance().setInput(ServerTreeViewUiManager.this.viewer, TreeLoader.getInstance().getRootNode());
                    ServerTreeViewUiManager.this.viewer.setCheckedElements(TreeLoader.getInstance().getSelectedNodes().toArray());
                    ServerTreeViewUiManager.this.viewer.setGrayedElements(TreeLoader.getInstance().getGrayedNodes().toArray());
                }
            });
            cedd.run();
            this.parent.refresh();
            List<ServerTreeView.Node> childlist = TreeLoader.getInstance().getRootNode().getChildren();
            if (childlist != null && !childlist.isEmpty()) {
                StructuredSelection selection = new StructuredSelection((Object[])new ServerTreeView.Node[]{childlist.get(0)});
                this.parent.setSelection((ISelection)selection);
                this.parent.getControl().setFocus();
            }
        }
    }

    class EditSystemManagerAction
    extends Action {
        public EditSystemManagerAction(TreeViewer parent) {
            this.setText("Edit System");
            this.setToolTipText("Edit System");
        }

        public void run() {
            String ipKey;
            final ServerTreeView.Node treeNode = (ServerTreeView.Node)((IStructuredSelection)ServerTreeViewUiManager.this.viewer.getSelection()).getFirstElement();
            if (treeNode.getElementInfo().getServerType().equals((Object)ElementInfo.ServerType.CLUSTER)) {
                return;
            }
            final CEDeploymentWindow cedd = new CEDeploymentWindow(ServerTreeViewUiManager.this.shell, null, 340, 290);
            String[] properties = new String[]{"System Manager IP", "User Name (CLI User)", "Password (CLI User)", "SSH Port"};
            cedd.setBlockOnOpen(true);
            Properties pDefault = new Properties();
            if (treeNode.getElementInfo().getServerType().equals((Object)ElementInfo.ServerType.CE)) {
                pDefault.setProperty("Avaya Breeze\u00ae Server IP(Management)", treeNode.getElementInfo().getIp());
                properties = new String[]{"Avaya Breeze\u00ae Server IP(Management)", "User Name (CLI User)", "Password (CLI User)", "SSH Port"};
                ipKey = "Avaya Breeze\u00ae Server IP(Management)";
            } else {
                pDefault.setProperty("System Manager IP", treeNode.getElementInfo().getIp());
                ipKey = "System Manager IP";
            }
            pDefault.setProperty("User Name (CLI User)", treeNode.getElementInfo().getUserName());
            pDefault.setProperty("Password (CLI User)", treeNode.getElementInfo().getPassword());
            pDefault.setProperty("SSH Port", String.valueOf(treeNode.getElementInfo().getPort()));
            cedd.setDfaultValues(pDefault);
            cedd.setProps(properties);
            cedd.setUpdateCallback(new ButtonCallbackAdapter(ServerTreeViewUiManager.this.shell){

                @Override
                public void onUpdate(Properties props) {
                    if (!ServerTreeViewUiManager.this.validateIP(props.getProperty(ipKey))) {
                        PluginUtilities.getInstance().openError(ServerTreeViewUiManager.this.shell, "Validation Error", "Please select valid ip address");
                        return;
                    }
                    cedd.close();
                    ElementInfo element = new ElementInfo();
                    element.setIp(props.getProperty(ipKey));
                    element.setOldIp(treeNode.getElementInfo().getIp());
                    element.setUserName(props.getProperty("User Name (CLI User)"));
                    element.setPassword(props.getProperty("Password (CLI User)"));
                    element.setPort(Integer.parseInt(props.getProperty("SSH Port")));
                    element.setServerType(treeNode.getElementInfo().getServerType());
                    TreeLoader.getInstance().editNode(element);
                    ServerTreeViewUiManager.this.shell.redraw();
                    ServerTreeViewUiManager.this.viewer.refresh();
                    ServerTreeViewUiManager.this.viewer.setInput((Object)TreeLoader.getInstance().getRootNode());
                    ServerTreeViewUiManager.this.viewer.setCheckedElements(TreeLoader.getInstance().getSelectedNodes().toArray());
                    ServerTreeViewUiManager.this.viewer.setGrayedElements(TreeLoader.getInstance().getGrayedNodes().toArray());
                }
            });
            cedd.run();
            cedd.setBlockOnOpen(false);
        }
    }

    class RemoveSystemManagerAction
    extends Action {
        public RemoveSystemManagerAction(TreeViewer parent) {
            this.setText("Remove SMGR");
            this.setToolTipText("Remove this System Manager");
        }

        public void run() {
            List<ElementInfo> smgrElements = PropertyWindowEditor.getSMGREmements();
            StringBuffer removeSMGRIPList = new StringBuffer();
            for (ElementInfo elementInfo : smgrElements) {
                if (elementInfo == null) continue;
                if (removeSMGRIPList.length() != 0) {
                    removeSMGRIPList.append(",").append(elementInfo.getIp());
                    continue;
                }
                removeSMGRIPList.append(elementInfo.getIp());
            }
            if (PluginUtilities.getInstance().openMessageDialog(removeSMGRIPList.toString()) == 0) {
                for (ElementInfo elementInfo : smgrElements) {
                    TreeLoader.getInstance().reomveFromRoot(elementInfo);
                }
            }
            ServerTreeViewUiManager.this.shell.redraw();
            ServerTreeViewUiManager.this.viewer.refresh();
            PluginUtilities.getInstance().setInput(ServerTreeViewUiManager.this.viewer, TreeLoader.getInstance().getRootNode());
            ServerTreeViewUiManager.this.viewer.setCheckedElements(TreeLoader.getInstance().getSelectedNodes().toArray());
            ServerTreeViewUiManager.this.viewer.setGrayedElements(TreeLoader.getInstance().getGrayedNodes().toArray());
        }
    }
}

