/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.eclipse.plugin.action;

import com.avaya.eclipse.plugin.Activator;
import com.avaya.eclipse.plugin.CEProjectModel;
import com.avaya.eclipse.plugin.PluginUtilities;
import com.avaya.eclipse.plugin.PropertyWindowEditor;
import com.avaya.eclipse.plugin.action.ActionDelegateAbstract;
import com.avaya.eclipse.plugin.model.ElementInfo;
import com.avaya.eclipse.plugin.model.TreeLoader;
import com.avaya.eclipse.plugin.operation.CEOperation;
import com.avaya.ssh.SSHConnection;
import com.avaya.ssh.SSHConnector;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;

public class EnableDebugOnCE
extends ActionDelegateAbstract {
    @Override
    public void run(IAction action) {
        PropertyWindowEditor.validateConfigurations(true);
        Job myJob = new Job("Enable Debug on selected Avaya Breeze nodes"){

            public IStatus run(IProgressMonitor monitor) {
                List<ElementInfo> ceElements = PropertyWindowEditor.getCEElements(PropertyWindowEditor.getSMGREmements());
                if (ceElements != null && ceElements.size() == 0) {
                    CEOperation.openErrorDialog("Operation Enable Debug on Avaya Breeze nodes Failure", "Please select at least one Avaya Breeze\u00ae node to proceed with Avaya Breeze\u00ae Eclipse plug-in action.");
                    return Status.OK_STATUS;
                }
                CEProjectModel cep = new CEProjectModel();
                cep.setAssociatedElements(TreeLoader.getInstance().getSelectedNodesAsElement());
                for (ElementInfo ce : ceElements) {
                    try {
                        SSHConnection sshce = SSHConnector.getInstance().getSSHConnection(ce);
                        sshce.execute("enableDebugCe");
                        if (PluginUtilities.getInstance().isDemoMode()) continue;
                        Thread.sleep(5000L);
                    }
                    catch (Exception e) {
                        Activator.log(4, 0, "Failed to enable Debug on selected Avaya Breeze nodes", e);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        myJob.schedule();
    }
}

