/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.eclipse.plugin.handler;

import com.avaya.eclipse.plugin.Activator;
import com.avaya.eclipse.plugin.PluginUtilities;
import com.avaya.eclipse.plugin.PropertyWindowEditor;
import com.avaya.eclipse.plugin.model.ElementInfo;
import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.internal.terminals.ui.TerminalServiceHelper;
import org.eclipse.rse.internal.terminals.ui.views.TerminalViewer;
import org.eclipse.rse.subsystems.terminals.core.ITerminalServiceSubSystem;
import org.eclipse.rse.subsystems.terminals.core.elements.TerminalElement;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;

public class LaunchTerminal
extends AbstractHandler
implements DisposeListener {
    private String systemType;
    private ElementInfo elementInfo;
    private String launchCommand;
    private ITerminalServiceSubSystem terminalSubSystem;

    public LaunchTerminal(String systemType, ElementInfo elementInfo) {
        this.systemType = systemType;
        this.elementInfo = elementInfo;
    }

    public LaunchTerminal(String systemType, ElementInfo elementInfo, String launchCommand) {
        this(systemType, elementInfo);
        this.launchCommand = launchCommand;
    }

    private IHost getCurrentHost(String name) {
        ISystemRegistry systemRegistry = PluginUtilities.getInstance().getTheSystemRegistry();
        ISystemProfile profile = systemRegistry.getSystemProfileManager().getDefaultPrivateSystemProfile();
        return systemRegistry.getHost(profile, name);
    }

    public ITerminalServiceSubSystem getTerminalSubSystem(String appendName, ElementInfo ei) {
        String name = appendName + "-" + ei.getIp();
        ITerminalServiceSubSystem terminalSubSystem = null;
        try {
            terminalSubSystem = PluginUtilities.getInstance().getTerminalSubSystem(this.getCurrentHost(name));
        }
        catch (NullPointerException e) {
            ArrayList<ElementInfo> elements = new ArrayList<ElementInfo>();
            elements.add(ei);
            PropertyWindowEditor.createRSESystem(elements);
            terminalSubSystem = PluginUtilities.getInstance().getTerminalSubSystem(this.getCurrentHost(name));
        }
        IConnectorService conn = terminalSubSystem.getConnectorService();
        conn.setUserId(ei.getUserName());
        conn.setPassword(ei.getUserName(), ei.getPassword(), false, false);
        try {
            conn.connect((IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e1) {
            Activator.log(4, 0, "Error connecting to " + ei.getIp(), e1);
        }
        return terminalSubSystem;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.terminalSubSystem = this.getTerminalSubSystem(this.systemType, this.elementInfo);
        if (this.terminalSubSystem != null) {
            TerminalViewer viewer = PluginUtilities.getInstance().getTerminalViewer();
            if (!this.terminalSubSystem.isConnected()) {
                try {
                    this.terminalSubSystem.connect((IProgressMonitor)new NullProgressMonitor(), false);
                }
                catch (Exception e) {
                    SystemBasePlugin.logError((String)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            if (this.terminalSubSystem.isConnected()) {
                CTabItem tab = viewer.getTabFolder().createTabItem((IAdaptable)this.terminalSubSystem.getHost(), this.getInitialDirectoryCmd());
                TerminalElement element = TerminalServiceHelper.createTerminalElement((CTabItem)tab, (ITerminalServiceSubSystem)this.terminalSubSystem);
                this.terminalSubSystem.addChild(element);
                tab.addDisposeListener((DisposeListener)this);
            }
        }
        return null;
    }

    public String getInitialDirectoryCmd() {
        return this.launchCommand + "\r";
    }

    public void widgetDisposed(DisposeEvent arg0) {
        if (this.terminalSubSystem != null) {
            try {
                this.terminalSubSystem.disconnect();
            }
            catch (Exception e) {
                Activator.log(4, 0, "Error while disconnecting terminal", e);
            }
        }
    }
}

