/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.eclipse.plugin.model;

import com.avaya.eclipse.plugin.Activator;
import com.avaya.eclipse.plugin.util.AESEncrypt;
import java.util.Set;
import java.util.TreeSet;
import org.w3c.dom.Element;

public class ElementInfo
implements Comparable<ElementInfo> {
    private String name;
    private String password;
    private String userName;
    private String oldIp;
    private String ip;
    private int port = 22;
    private boolean switchToSu;
    private String rootUser;
    private String rootPassword;
    private boolean grayed = false;
    private boolean checked = false;
    private boolean validated;
    private Set<ElementInfo> associatedElements;
    private ServerType serverType = ServerType.SMGR;

    public boolean isGrayed() {
        return this.grayed;
    }

    public void setGrayed(boolean grayed) {
        this.grayed = grayed;
    }

    public boolean isValidated() {
        return this.validated;
    }

    public void setValidated(boolean validated) {
        this.validated = validated;
    }

    public ElementInfo() {
    }

    public ElementInfo(ElementInfo other) {
        this.name = other.name;
        this.password = other.password;
        this.userName = other.userName;
        this.ip = other.ip;
        this.port = other.port;
        this.switchToSu = other.switchToSu;
        this.rootUser = other.rootUser;
        this.rootPassword = other.rootPassword;
        this.associatedElements = new TreeSet<ElementInfo>(other.getAssociatedElements());
        this.serverType = other.serverType;
        this.checked = other.checked;
        this.grayed = other.grayed;
        this.validated = other.validated;
    }

    public ElementInfo(ServerType serverType, String name, String ip) {
        this.name = name;
        this.ip = ip;
        this.serverType = serverType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isSwitchToSu() {
        return this.switchToSu;
    }

    public void setSwitchToSu(boolean switchToSu) {
        this.switchToSu = switchToSu;
    }

    public String getRootUser() {
        return this.rootUser;
    }

    public void setRootUser(String rootUser) {
        this.rootUser = rootUser;
    }

    public String getRootPassword() {
        return this.rootPassword;
    }

    public void setRootPassword(String rootPassword) {
        this.rootPassword = rootPassword;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getOldIp() {
        return this.oldIp;
    }

    public void setOldIp(String oldIp) {
        this.oldIp = oldIp;
    }

    public String getPassword() {
        if (this.password == null && this.serverType != ServerType.CLUSTER) {
            this.setPassword(ElementInfo.getDefaultPassword(this.serverType));
        }
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUserName() {
        if (this.userName == null && this.serverType != ServerType.CLUSTER) {
            this.setUserName(ElementInfo.getDefaultUsername(this.serverType));
        }
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public ServerType getServerType() {
        return this.serverType;
    }

    public void setServerType(ServerType serverType) {
        this.serverType = serverType;
    }

    public static ElementInfo createCE(String name, String ip) {
        return new ElementInfo(ServerType.CE, name, ip);
    }

    public static ElementInfo createSMGR(String name, String ip) {
        return new ElementInfo(ServerType.SMGR, name, ip);
    }

    public static ElementInfo createCluster(String name, String ip) {
        return new ElementInfo(ServerType.CLUSTER, name, ip);
    }

    public Set<ElementInfo> getAssociatedElements() {
        return this.associatedElements == null ? new TreeSet() : this.associatedElements;
    }

    public void setAssociatedElements(Set<ElementInfo> associatedElements) {
        this.associatedElements = associatedElements;
    }

    public void addAssociatedElement(ElementInfo ei) {
        if (this.associatedElements == null) {
            this.associatedElements = new TreeSet<ElementInfo>();
        }
        this.associatedElements.add(ei);
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }

    public String toString() {
        switch (this.getServerType()) {
            case CE: {
                return this.name + " (" + this.ip + ")";
            }
            case SMGR: 
            case CLUSTER: {
                return this.name != null ? this.name : this.ip;
            }
        }
        return this.ip;
    }

    public static String getDefaultUsername(ServerType serverType) {
        switch (serverType) {
            case SMGR: {
                return "admin";
            }
            case CE: {
                return "cust";
            }
        }
        return null;
    }

    public static String getDefaultPassword(ServerType serverType) {
        switch (serverType) {
            case SMGR: {
                return "admin";
            }
            case CE: {
                return "cust01";
            }
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ip == null ? 0 : this.ip.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ElementInfo other = (ElementInfo)obj;
        return !(this.ip == null ? other.ip != null : !this.ip.equals(other.ip));
    }

    public void save(Element element) {
        element.setAttribute("ip", this.getIp());
        if (this.name != null && !this.name.equals(this.ip)) {
            element.setAttribute("name", this.name);
        }
        if (this.serverType != ServerType.CLUSTER) {
            if (this.userName != null) {
                element.setAttribute("username", this.userName);
            }
            if (this.password != null) {
                try {
                    String enPassword = AESEncrypt.encrypt(this.password, this.userName);
                    element.setAttribute("password", enPassword);
                }
                catch (Exception e) {
                    Activator.log(4, 0, "Error encrypting password", e);
                }
            }
            if (this.rootPassword != null) {
                element.setAttribute("rootpassword", this.rootPassword);
            }
            if (this.rootUser != null) {
                element.setAttribute("rootuser", this.rootUser);
            }
            if (this.switchToSu) {
                element.setAttribute("switchtosu", "true");
            }
            element.setAttribute("port", String.valueOf(this.port));
        }
        if (this.isGrayed()) {
            element.setAttribute("grayed", Boolean.TRUE.toString());
        }
        if (this.isChecked()) {
            element.setAttribute("checked", Boolean.TRUE.toString());
        }
        if (this.isValidated()) {
            element.setAttribute("validated", Boolean.TRUE.toString());
        }
    }

    public static ElementInfo load(Element element) throws Exception {
        if (!element.hasAttribute("ip")) {
            throw new Exception("invalid history file - IP not found");
        }
        ElementInfo ei = new ElementInfo();
        String tag = element.getTagName();
        if (tag.equalsIgnoreCase("smgr")) {
            ei.serverType = ServerType.SMGR;
        } else if (tag.equalsIgnoreCase("cluster")) {
            ei.serverType = ServerType.CLUSTER;
        } else if (tag.equalsIgnoreCase("ce")) {
            ei.serverType = ServerType.CE;
        } else {
            throw new Exception("invalid history file - unknown server type \"" + tag + "\"");
        }
        ei.ip = element.getAttribute("ip");
        if (element.hasAttribute("name")) {
            ei.name = element.getAttribute("name");
        }
        if (ei.serverType != ServerType.CLUSTER) {
            if (element.hasAttribute("username")) {
                ei.userName = element.getAttribute("username");
            }
            if (element.hasAttribute("password")) {
                String enPass = element.getAttribute("password");
                if (element.hasAttribute("username")) {
                    ei.userName = element.getAttribute("username");
                    try {
                        ei.setPassword(AESEncrypt.decrypt(enPass, ei.getUserName()));
                    }
                    catch (Exception e) {
                        Activator.log(4, 0, "Error decrypting password", e);
                    }
                } else {
                    String username = ElementInfo.getDefaultUsername(ei.serverType);
                    try {
                        ei.setPassword(AESEncrypt.decrypt(enPass, username));
                    }
                    catch (Exception e) {
                        Activator.log(4, 0, "Error decrypting password", e);
                    }
                }
            }
            if (element.hasAttribute("rootpassword")) {
                ei.rootPassword = element.getAttribute("rootpassword");
            }
            if (element.hasAttribute("rootuser")) {
                ei.rootUser = element.getAttribute("rootuser");
            }
            try {
                ei.port = Integer.parseInt(element.getAttribute("port"));
            }
            catch (NumberFormatException e) {
                ei.port = 22;
            }
            if (element.hasAttribute("switchtosu")) {
                ei.setSwitchToSu(Boolean.valueOf(element.getAttribute("switchtosu")));
            }
        }
        if (element.hasAttribute("checked")) {
            ei.setChecked(Boolean.valueOf(element.getAttribute("checked")));
        }
        if (element.hasAttribute("grayed")) {
            ei.setGrayed(Boolean.valueOf(element.getAttribute("grayed")));
        }
        if (element.hasAttribute("validated")) {
            ei.setValidated(Boolean.valueOf(element.getAttribute("validated")));
        }
        return ei;
    }

    @Override
    public int compareTo(ElementInfo o) {
        if (o == this) {
            return 0;
        }
        if (o.getIp() == null || o.getServerType() == null) {
            return -20;
        }
        String uName1 = this.getIp();
        if (this.getServerType().equals((Object)ServerType.CLUSTER)) {
            uName1 = this.getName();
        }
        String uName2 = o.getIp();
        if (o.getServerType().equals((Object)ServerType.CLUSTER)) {
            uName2 = o.getName();
        }
        return (uName1 + this.getServerType().toString()).compareTo(uName2 + o.getServerType().toString());
    }

    public static enum ServerType {
        SMGR,
        CLUSTER,
        CE;

    }
}

