/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.ContactAPI;
import com.avaya.asm.datamgr.dao.cassandra.CassandraDAOFactory;
import com.avaya.asm.datamgr.dao.cassandra.KeyspaceMetaData;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreKeyspace;
import com.avaya.asm.datamgr.dao.ustore.ContactDAO;
import com.avaya.asm.datamgr.helpers.CassandraConnectionInfo;
import com.avaya.asm.datamgr.helpers.ContactHelper;
import com.avaya.common.logging.client.Logger;
import com.avaya.ustore.objectapi.SmgrContactRefKey;
import com.avaya.ustore.objectapi.SmgrContactRefRecord;
import com.avaya.ustore.objectapi.UstoreContactKey;
import com.avaya.ustore.objectapi.UstoreContactRecord;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;

public class ContactDM
implements ContactAPI {
    private final Logger log = AsmLogger.getLogger(ContactDM.class);
    private CassandraDAOFactory<ContactDAO> contactDAOFactory = new CassandraDAOFactory();
    private ContactDAO cDAO = null;
    private ContactHelper contactHelper = null;

    public ContactDM(CassandraConnectionInfo cConnInfo) {
        this.cDAO = this.contactDAOFactory.getDAOInstance(cConnInfo, ContactDAO.class);
        this.contactHelper = ContactHelper.getInstance();
    }

    @Override
    public void addContact(UstoreContactRecord uCRecord, List<SmgrContactRefRecord> sCRRecordList, boolean ifConditionalFailsTryUpdate) throws DMException {
        String fcn_name = "addContact";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("addContact: enter with UstoreContactRecord = " + uCRecord + ", size of sCRRecordList = " + sCRRecordList.size()));
        }
        if (uCRecord == null || sCRRecordList == null || sCRRecordList.isEmpty()) {
            this.log.warn((Object)"addContact: There's nothing to push into the DB. ");
            return;
        }
        this.cDAO.addContact(uCRecord, sCRRecordList, ifConditionalFailsTryUpdate);
        if (isFiner) {
            this.log.finer((Object)"addContact: leave ");
        }
    }

    @Override
    public void updateContact(UstoreContactRecord uCRecord, List<SmgrContactRefRecord> addSCRRecordList, List<SmgrContactRefKey> deleteSCRKeyList, boolean unconditionalUpdate) throws DMException {
        String fcn_name = "updateContact";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            if (uCRecord != null) {
                this.log.finer((Object)("updateContact: enter with UstoreContactRecord = " + uCRecord));
            }
            if (addSCRRecordList != null) {
                this.log.finer((Object)("updateContact: enter with size of addSCRRecordList = " + addSCRRecordList.size()));
            }
            if (deleteSCRKeyList != null) {
                this.log.finer((Object)("updateContact: enter with size of deleteSCRKeyList = " + deleteSCRKeyList.size()));
            }
        }
        if (uCRecord == null && (addSCRRecordList == null || addSCRRecordList.isEmpty()) && (deleteSCRKeyList == null || deleteSCRKeyList.isEmpty())) {
            this.log.warn((Object)"updateContact: There's nothing to push into the DB. ");
            return;
        }
        this.cDAO.updateContact(uCRecord, addSCRRecordList, deleteSCRKeyList, unconditionalUpdate, false);
        if (isFiner) {
            this.log.finer((Object)"updateContact: leave ");
        }
    }

    @Override
    public void deleteContacts(UserStoreKeyspace keyspace, long ownerCsuserId, List<UUID> contactIdsToDelete) throws DMException {
        String fcn_name = "deleteContacts";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("deleteContacts: enter with keyspace = " + keyspace + ", ownerCsuserId = " + ownerCsuserId + ", number of contactIds to delete = " + contactIdsToDelete.size()));
        }
        if (keyspace == null || contactIdsToDelete.size() <= 0) {
            this.log.warn((Object)("deleteContacts: We got bad data: keyspace = " + keyspace + ", number of contactIds to delete = " + contactIdsToDelete.size()));
            throw new IllegalArgumentException("deleteContacts: We got bad data: keyspace = " + keyspace + ", number of contactIds to delete = " + contactIdsToDelete.size());
        }
        this.cDAO.deleteContacts(keyspace, ownerCsuserId, contactIdsToDelete);
        if (isFiner) {
            this.log.finer((Object)"deleteContacts: leave ");
        }
    }

    @Override
    public void deleteAllContacts(UserStoreKeyspace keyspace, long ownerCsuserId) throws DMException {
        String fcn_name = "deleteAllContacts";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("deleteAllContacts: enter with keyspace = " + keyspace + ", ownerCsuserId = " + ownerCsuserId));
        }
        if (keyspace == null) {
            this.log.warn((Object)("deleteAllContacts: We got bad data: keyspace = " + keyspace));
            throw new IllegalArgumentException("deleteAllContacts: We got bad data: keyspace = " + keyspace);
        }
        this.cDAO.deleteAllContacts(keyspace, ownerCsuserId);
        if (isFiner) {
            this.log.finer((Object)"deleteAllContacts: leave ");
        }
    }

    @Override
    public UstoreContactRecord getContactWithKeyspace(UserStoreKeyspace keyspace, long ownerCsuserId, UUID contactId) throws DMException {
        String fcn_name = "getContactWithKeyspace";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("getContactWithKeyspace: enter with keyspace = " + keyspace + ", ownerCsuserId = " + ownerCsuserId + ", contactId = " + contactId));
        }
        if (keyspace == null || contactId == null) {
            this.log.warn((Object)("getContactWithKeyspace: We got bad data: keyspace = " + keyspace + ", contactId = " + contactId));
            throw new IllegalArgumentException("getContactWithKeyspace: We got bad data: keyspace = " + keyspace + ", contactId = " + contactId);
        }
        UstoreContactRecord uCR = this.cDAO.getContact(keyspace, ownerCsuserId, contactId);
        if (isFiner) {
            this.log.finer((Object)("getContactWithKeyspace: leave, UstoreContactRecord = " + uCR));
        }
        return uCR;
    }

    @Override
    public List<UstoreContactRecord> getAllContactsWithKeyspace(UserStoreKeyspace keyspace, long ownerCsuserId) throws DMException {
        String fcn_name = "getAllContactsWithKeyspace";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("getAllContactsWithKeyspace: enter with keyspace = " + keyspace + ", ownerCsuserId = " + ownerCsuserId));
        }
        if (keyspace == null) {
            this.log.warn((Object)("getAllContactsWithKeyspace: We got bad data: keyspace = " + keyspace));
            throw new IllegalArgumentException("getAllContactsWithKeyspace: We got bad data: keyspace = " + keyspace);
        }
        List<UstoreContactRecord> uCRList = this.cDAO.getAllContacts(keyspace, ownerCsuserId);
        if (isFiner) {
            if (uCRList != null) {
                this.log.finer((Object)("getAllContactsWithKeyspace: leave, UstoreContactRecord list size = " + uCRList.size()));
            } else {
                this.log.finer((Object)"getAllContactsWithKeyspace: leave, UstoreContactRecord list was null");
            }
        }
        return uCRList;
    }

    public Integer getContactsCount(UserStoreKeyspace keyspace, long csuserId) throws DMException {
        String fcn_name = "getContactsCountWithKeyspace";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("getContactsCountWithKeyspace: enter with keyspace = " + keyspace + ", csuserId = " + csuserId));
        }
        if (keyspace == null) {
            this.log.warn((Object)("getContactsCountWithKeyspace: We got bad data: keyspace = " + keyspace + ", csuserId = " + csuserId));
            throw new IllegalArgumentException("getContactsCountWithKeyspace: We got bad data: keyspace = " + keyspace + ", csuserId = " + csuserId);
        }
        Integer contactCount = this.cDAO.getContactsCount(keyspace, csuserId);
        if (isFiner) {
            this.log.finer((Object)("getContactsCountWithKeyspace: leave, UstoreContactRecord count = " + contactCount));
        }
        return contactCount;
    }

    @Override
    public SmgrContactRefRecord getSmgrContactRef(UserStoreKeyspace keyspace, long ownerCsuserId, String recType, long recId) throws DMException {
        String fcn_name = "getSmgrContactRef";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("getSmgrContactRef: enter with keyspace = " + keyspace + ", ownerCsuserId = " + ownerCsuserId + ", recType = " + recType + ", recId = " + recId));
        }
        if (keyspace == null) {
            this.log.warn((Object)("getSmgrContactRef: We got bad data: keyspace = " + keyspace));
            throw new IllegalArgumentException("getSmgrContactRef: We got bad data: keyspace = " + keyspace);
        }
        SmgrContactRefRecord sCRR = null;
        sCRR = this.cDAO.getSmgrContactRef(keyspace, ownerCsuserId, recType, recId);
        if (isFiner) {
            this.log.finer((Object)"getSmgrContactRef: leave");
        }
        return sCRR;
    }

    @Override
    public List<SmgrContactRefRecord> getSmgrContactRefsByContactId(UserStoreKeyspace keyspace, long ownerCsuserId, UUID contactId) throws DMException {
        String fcn_name = "getSmgrContactRefsByContactId";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("getSmgrContactRefsByContactId: enter with keyspace = " + keyspace + ", ownerCsuserId = " + ownerCsuserId + ", contactId = " + contactId));
        }
        if (keyspace == null || contactId == null) {
            this.log.warn((Object)("getSmgrContactRefsByContactId: We got bad data: keyspace = " + keyspace + ", contactId = " + contactId));
            throw new IllegalArgumentException("getSmgrContactRefsByContactId: We got bad data: keyspace = " + keyspace + ", contactId = " + contactId);
        }
        List<SmgrContactRefRecord> sCRRList = null;
        sCRRList = this.cDAO.getSmgrContactRefsByContactId(keyspace, ownerCsuserId, contactId);
        if (isFiner) {
            this.log.finer((Object)("getSmgrContactRefsByContactId: leave, SmgrContactRefRecord list size = " + sCRRList.size()));
        }
        return sCRRList;
    }

    @Override
    public List<SmgrContactRefRecord> getSmgrContactRefsByRecType(UserStoreKeyspace keyspace, long ownerCsuserId, String recType) throws DMException {
        String fcn_name = "getSmgrContactRefsByRecType";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("getSmgrContactRefsByRecType: enter with keyspaceName = " + keyspace + ", recType = " + recType + ", ownerCsuserId = " + ownerCsuserId));
        }
        if (keyspace == null) {
            this.log.warn((Object)("getSmgrContactRefsByRecType: We got bad data: keyspace = " + keyspace));
            throw new IllegalArgumentException("getSmgrContactRefsByRecType: We got bad data: keyspace = " + keyspace);
        }
        List<SmgrContactRefRecord> sCRRList = null;
        sCRRList = this.cDAO.getSmgrContactRefsByRecType(keyspace, ownerCsuserId, recType);
        if (isFiner) {
            this.log.finer((Object)("getSmgrContactRefsByRecType: leave, SmgrContactRefRecord list size = " + sCRRList.size()));
        }
        return sCRRList;
    }

    @Override
    public List<SmgrContactRefRecord> getSmgrContactRefsByOwnerId(UserStoreKeyspace keyspace, long ownerCsuserId) throws DMException {
        String fcn_name = "getSmgrContactRefsByContactId";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("getSmgrContactRefsByContactId: enter with keyspaceName = " + keyspace + ", ownerCsuserId = " + ownerCsuserId));
        }
        if (keyspace == null) {
            this.log.warn((Object)("getSmgrContactRefsByContactId: We got bad data: keyspace = " + keyspace));
            throw new IllegalArgumentException("getSmgrContactRefsByContactId: We got bad data: keyspace = " + keyspace);
        }
        List<SmgrContactRefRecord> sCRRList = null;
        sCRRList = this.cDAO.getSmgrContactRefsByOwnerId(keyspace, ownerCsuserId);
        if (isFiner) {
            this.log.finer((Object)("getSmgrContactRefsByContactId: leave, SmgrContactRefRecord list size = " + sCRRList.size()));
        }
        return sCRRList;
    }

    @Override
    public void moveContacts(long csuserId, UserStoreKeyspace oldKeyspace, UserStoreKeyspace newKeyspace, boolean ifConditionalAddFailsTryUpdate) throws DMException {
        String fcn_name = "moveContacts";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        if (isFiner) {
            this.log.finer((Object)("moveContacts: enter, csuserId=" + csuserId + ", oldKeyspace=" + oldKeyspace + ", newKeyspace=" + newKeyspace));
        }
        if (oldKeyspace.equals(newKeyspace)) {
            if (newKeyspace.getName().equals("global_user_dc")) {
                this.cDAO.setMigrationContact(csuserId);
            }
            if (isFiner) {
                this.log.finer((Object)("moveContacts: leave, oldKeyspace == newKeyspace: " + oldKeyspace));
            }
            return;
        }
        List<UstoreContactRecord> contacts = null;
        List<SmgrContactRefRecord> allSCRRecords = null;
        try {
            contacts = this.getAllContactsWithKeyspace(oldKeyspace, csuserId);
        }
        catch (DMException e) {
            this.log.error((Object)("moveContacts: DMException thrown by contactDM:getAllContactsWithKeyspace for key=" + oldKeyspace), (Throwable)e);
            throw e;
        }
        if (isFinest) {
            if (contacts == null) {
                this.log.finest((Object)("moveContacts: contacts is null so no contacts for csuserId " + csuserId + ", oldKeyspace " + oldKeyspace));
            } else {
                this.log.finest((Object)("moveContacts: num contacts read is " + contacts.size()));
            }
        }
        try {
            allSCRRecords = this.getSmgrContactRefsByOwnerId(oldKeyspace, csuserId);
        }
        catch (DMException e) {
            this.log.error((Object)("moveContacts: DMException thrown by contactDM.getSmgrContactRefsByOwnerId for oldKeyspace=" + oldKeyspace), (Throwable)e);
            throw e;
        }
        if (contacts != null && !contacts.isEmpty()) {
            for (UstoreContactRecord ucr : contacts) {
                List<SmgrContactRefRecord> sCRRecords = this.findSmgrContactRefRecords(allSCRRecords, ucr.getCscontactlistmemberId());
                try {
                    UstoreContactKey oldCKey = ucr.getKey();
                    UstoreContactKey newCKey = new UstoreContactKey(csuserId, oldCKey.getId(), newKeyspace);
                    ucr.setKey(newCKey);
                    for (SmgrContactRefRecord scr : sCRRecords) {
                        SmgrContactRefKey scrk = scr.getKey();
                        SmgrContactRefKey newScrKey = new SmgrContactRefKey(scrk.getOwnerCsuserId(), scrk.getRecType(), scrk.getRecId(), newKeyspace);
                        scr.setKey(newScrKey);
                    }
                    this.addContact(ucr, sCRRecords, ifConditionalAddFailsTryUpdate);
                }
                catch (DMException e) {
                    this.log.error((Object)("moveContacts: DMException thrown by contactDM.addContact for ucr=" + ucr), (Throwable)e);
                    throw e;
                }
            }
            try {
                this.deleteAllContacts(oldKeyspace, csuserId);
            }
            catch (DMException e) {
                this.log.error((Object)("moveContacts: DMException thrown by contactDM.deleteAllContact for user=" + csuserId + ", keyspace=" + oldKeyspace), (Throwable)e);
                throw e;
            }
        }
        if (newKeyspace.getName().equals("global_user_dc")) {
            this.cDAO.setMigrationContact(csuserId);
            if (isFinest) {
                this.log.finest((Object)("moveContacts: ContactData Migration to global_user_dc KS is completed. Added special Contact record Successfully. csuserId : " + csuserId + ", oldKeyspace : " + oldKeyspace + ", newKeyspace : " + newKeyspace));
            }
        }
        if (isFiner) {
            this.log.finer((Object)("moveContacts, leave, contacts moved for csuserId " + csuserId + " to newKeyspace " + newKeyspace));
        }
    }

    protected List<SmgrContactRefRecord> findSmgrContactRefRecords(List<SmgrContactRefRecord> allSCRRecords, long clmId) {
        ArrayList<SmgrContactRefRecord> sCRRList = new ArrayList<SmgrContactRefRecord>();
        Iterator<SmgrContactRefRecord> it = allSCRRecords.iterator();
        while (it.hasNext()) {
            SmgrContactRefRecord sCRRecord = it.next();
            if (sCRRecord.getClmId() != clmId) continue;
            sCRRList.add(sCRRecord);
            it.remove();
        }
        return sCRRList;
    }

    public List<String> getKeyspaces() throws DMException {
        List<KeyspaceMetaData> ksmdList = this.cDAO.getKeyspaces();
        ArrayList<String> ksNameList = new ArrayList<String>(ksmdList.size());
        for (KeyspaceMetaData ksmd : ksmdList) {
            ksNameList.add(ksmd.getName());
        }
        return ksNameList;
    }

    public boolean doesContactCFExist(String keyspaceName) throws DMException {
        return this.cDAO.doesTableExist(keyspaceName, "contact");
    }

    public boolean createKeyspaceAndCFs(UserStoreKeyspace keyspace) throws DMException {
        String fcn_name = "createKeyspaceAndCFs";
        boolean isFiner = this.log.isFinerEnabled();
        String ksName = keyspace.getName();
        boolean ksexist = this.getKeyspaces().contains(ksName);
        boolean createCF = true;
        if (ksexist) {
            boolean bl = createCF = !this.cDAO.doesTableExist(ksName, "contact");
        }
        if (createCF) {
            this.cDAO.createKeyspaceAndCFs(keyspace, ksexist);
        }
        if (isFiner) {
            this.log.finer((Object)("createKeyspaceAndCFs, Is contact CF created  :" + createCF + ", keyspace: " + keyspace));
        }
        return createCF;
    }

    @Override
    public void getOwnerCsUserIdsForKeyspace(UserStoreKeyspace keyspace, Collection<Long> ids) throws DMException {
        this.cDAO.getOwnerCsUserIdsByKeyspace(keyspace, ids);
    }

    public boolean contactsMigratedToGlobalUserDC(long ownercsuserid, UserStoreKeyspace keyspace) throws DMException {
        String fcn_name = "contactsMigratedToGlobalUserDC";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        if (isFiner) {
            this.log.finer((Object)("contactsMigratedToGlobalUserDC: enter, ownercsuserid = " + ownercsuserid + ", keyspace = " + keyspace));
        }
        if (this.contactHelper.storeContactsInGlobalUserDCKeyspace()) {
            boolean migrationContactPresent = this.checkMigrationContactPresent(ownercsuserid);
            if (migrationContactPresent) {
                if (isFinest) {
                    this.log.finest((Object)("contactsMigratedToGlobalUserDC: contact Data already migrated to Global_user_dc KS. checkMigrationContactPresent: " + migrationContactPresent));
                }
            } else {
                this.migrateContactsToGlobalUserDC(ownercsuserid, keyspace);
            }
            return true;
        }
        return false;
    }

    public boolean checkMigrationContactPresent(long ownercsuserid) throws DMException {
        String fcn_name = "checkMigrationContactPresent";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("checkMigrationContactPresent: ownercsuserid = " + ownercsuserid));
        }
        boolean checkMigrationContactPresent = this.cDAO.contactsMigratedToGlobalUserDC(ownercsuserid);
        if (isFiner) {
            this.log.finer((Object)("checkMigrationContactPresent: ownercsuserid = " + ownercsuserid + ", checkMigrationContactPresent = " + checkMigrationContactPresent));
        }
        return checkMigrationContactPresent;
    }

    protected void migrateContactsToGlobalUserDC(long ownercsuserid, UserStoreKeyspace keyspace) throws DMException {
        String fcn_name = "migrateContactsToGlobalUserDC";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("migrateContactsToGlobalUserDC: enter, ownercsuserid = " + ownercsuserid));
        }
        this.moveContacts(ownercsuserid, keyspace, new UserStoreKeyspace("global_user_dc"), true);
    }

    @Override
    public UstoreContactRecord getContactFromCurrentKeyspace(UserStoreKeyspace keyspace, long ownerCsuserId, UUID contactId) throws DMException {
        String fcn_name = "getContactFromCurrentKeyspace";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("getContactFromCurrentKeyspace: enter with keyspace = " + keyspace + ", ownerCsuserId = " + ownerCsuserId + ", contactId = " + contactId));
        }
        if (keyspace == null || contactId == null) {
            this.log.warn((Object)("getContactFromCurrentKeyspace: We got bad data: keyspace = " + keyspace + ", contactId = " + contactId));
            throw new IllegalArgumentException("getContactFromCurrentKeyspace: We got bad data: keyspace = " + keyspace + ", contactId = " + contactId);
        }
        UstoreContactRecord uCR = this.cDAO.getContactFromCurrentKeyspace(keyspace, ownerCsuserId, contactId);
        if (isFiner) {
            this.log.finer((Object)("getContactFromCurrentKeyspace: leave, UstoreContactRecord = " + uCR));
        }
        return uCR;
    }

    @Override
    public List<UstoreContactRecord> getAllContactsFromCurrentKeyspace(UserStoreKeyspace keyspace, long ownerCsuserId) throws DMException {
        String fcn_name = "getAllContactsFromCurrentKeyspace";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("getAllContactsFromCurrentKeyspace: enter with keyspace = " + keyspace + ", ownerCsuserId = " + ownerCsuserId));
        }
        if (keyspace == null) {
            this.log.warn((Object)("getAllContactsFromCurrentKeyspace: We got bad data: keyspace = " + keyspace));
            throw new IllegalArgumentException("getAllContactsFromCurrentKeyspace: We got bad data: keyspace = " + keyspace);
        }
        List<UstoreContactRecord> uCRList = this.cDAO.getAllContactsFromCurrentKeyspace(keyspace, ownerCsuserId);
        if (isFiner) {
            if (uCRList != null) {
                this.log.finer((Object)("getAllContactsFromCurrentKeyspace: leave, UstoreContactRecord list size = " + uCRList.size()));
            } else {
                this.log.finer((Object)"getAllContactsFromCurrentKeyspace: leave, UstoreContactRecord list was null");
            }
        }
        return uCRList;
    }

    public void setMigrationContact(long ownercsuserid) throws DMException {
        String fcn_name = "setMigrationContact";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("setMigrationContact: ownercsuserid = " + ownercsuserid));
        }
        this.cDAO.setMigrationContact(ownercsuserid);
        if (isFiner) {
            this.log.finer((Object)"setMigrationContact: leave ");
        }
    }
}

