/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr;

public class DatabaseConfig {
    private boolean ssl = true;
    private String user = "asm";
    private String password = "asm";
    private int timeout = 10000;
    private int retries = 2;
    private int poolsize = 3;
    private String driver = "org.postgresql.Driver";
    private static DatabaseConfig instance = null;

    private DatabaseConfig() {
    }

    public static DatabaseConfig getInstance() {
        if (instance == null) {
            instance = new DatabaseConfig();
        }
        return instance;
    }

    public String getUrl(String db) {
        String host = System.getProperty("dbhost", "localhost");
        String postgresqlSslOptions = System.getProperty("postgresqlSslOptions", null);
        StringBuffer url = new StringBuffer("");
        url.append("jdbc:postgresql://").append(host).append("/").append(db);
        if (this.isSsl()) {
            if (postgresqlSslOptions == null) {
                url.append("?ssl");
            } else {
                url.append("?");
                url.append(postgresqlSslOptions);
            }
        }
        return url.toString();
    }

    public boolean isSsl() {
        String dbssl = System.getProperty("dbssl", "true");
        this.ssl = Boolean.parseBoolean(dbssl);
        return this.ssl;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public int getPoolsize() {
        return this.poolsize;
    }

    public void setPoolsize(int poolsize) {
        this.poolsize = poolsize;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }
}

