/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.AppSetAssign;
import com.avaya.asm.datamgr.objectapi.AppSetMember;
import com.avaya.asm.datamgr.objectapi.AsmApplication;
import com.avaya.asm.datamgr.objectapi.MediaAttributes;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AppSetDAO
extends DataAccessObject {
    private final Logger log = AsmLogger.getLogger(AppSetDAO.class);
    protected Map<Long, AsmApplication> applicationMap = new HashMap<Long, AsmApplication>();
    protected Map<Long, Attribute> attributeMap = new HashMap<Long, Attribute>();
    protected Map<Long, List<AppSetAssign>> assignSetMap = new HashMap<Long, List<AppSetAssign>>();
    protected Map<Long, Long> assignIdMap = new HashMap<Long, Long>();
    protected Map<Long, List<AppSetMember>> setMap = new HashMap<Long, List<AppSetMember>>();
    protected final AppSorter sorter = new AppSorter();
    protected Map<Long, List<Long>> routePolicyIDListMap = new HashMap<Long, List<Long>>();
    protected Map<Long, ApplicationRoutingPolicyPair> asmApplicationToRoutePolicyPairMap = new ConcurrentHashMap<Long, ApplicationRoutingPolicyPair>();
    protected static final String getApplications = "SELECT id, sipentity_id, do_media_filtering, accepts_audio, accepts_video, accepts_text, match_type, if_no_sdp FROM asmapplication";
    protected static final String getApplicationById = "SELECT id, sipentity_id, do_media_filtering, accepts_audio, accepts_video, accepts_text, match_type, if_no_sdp FROM asmapplication WHERE id = ?";
    protected static final String getAttributes = "SELECT id, asmapplication_id, attributename, attributevalue FROM asmapplicationattribute";
    protected static final String getAttributeById = "SELECT id, asmapplication_id, attributename, attributevalue FROM asmapplicationattribute WHERE id = ?";
    protected static final String getAppSetAssignments = "SELECT id, application_id, appset_id, orderofexecution, ismandatory, isprimaryfs FROM asmappsetassign";
    protected static final String getAppSetAssignmentById = "SELECT id, application_id, appset_id, orderofexecution, ismandatory, isprimaryfs FROM asmappsetassign WHERE id = ?";
    protected static final String getApplicationRoutePolicy = "SELECT id, asmapplication_id, routingpolicy_id FROM asmapplication_to_routingpolicy";
    protected static final String getApplicationRoutePolicyById = "SELECT id, asmapplication_id, routingpolicy_id FROM asmapplication_to_routingpolicy WHERE id = ?";
    protected static final ResultSetMapper applicationsMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            HashMap<Long, AsmApplication> map = new HashMap<Long, AsmApplication>();
            while (rs.next()) {
                map.put(rs.getLong("id"), new AsmApplication(rs.getLong("id"), rs.getLong("sipentity_id"), new MediaAttributes(rs.getBoolean("do_media_filtering"), MediaAttributes.MediaAccepts.valueOf(rs.getString("accepts_audio")), MediaAttributes.MediaAccepts.valueOf(rs.getString("accepts_video")), MediaAttributes.MediaAccepts.valueOf(rs.getString("accepts_text")), MediaAttributes.MatchType.valueOf(rs.getString("match_type")), MediaAttributes.IfNoSdp.valueOf(rs.getString("if_no_sdp")))));
            }
            return map;
        }
    };
    protected static final ResultSetMapper applicationMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            if (rs.next()) {
                return new AsmApplication(rs.getLong("id"), rs.getLong("sipentity_id"), new MediaAttributes(rs.getBoolean("do_media_filtering"), MediaAttributes.MediaAccepts.valueOf(rs.getString("accepts_audio")), MediaAttributes.MediaAccepts.valueOf(rs.getString("accepts_video")), MediaAttributes.MediaAccepts.valueOf(rs.getString("accepts_text")), MediaAttributes.MatchType.valueOf(rs.getString("match_type")), MediaAttributes.IfNoSdp.valueOf(rs.getString("if_no_sdp"))));
            }
            return null;
        }
    };
    protected final ResultSetMapper attributesMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            HashMap<Long, Attribute> map = new HashMap<Long, Attribute>();
            while (rs.next()) {
                String name = rs.getString("attributename");
                String value = rs.getString("attributevalue");
                if (name != null && name.isEmpty()) {
                    name = null;
                }
                if (value != null && value.isEmpty()) {
                    value = null;
                }
                map.put(rs.getLong("id"), new Attribute(rs.getLong("asmapplication_id"), name, value));
            }
            return map;
        }
    };
    protected static final ResultSetMapper assignmentsMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            HashMap map = new HashMap();
            while (rs.next()) {
                long appSetId = rs.getLong("appset_id");
                if (!map.containsKey(appSetId)) {
                    map.put(appSetId, new ArrayList());
                }
                ((List)map.get(appSetId)).add(new AppSetAssign(rs.getLong("id"), rs.getLong("application_id"), appSetId, rs.getInt("orderofexecution"), rs.getBoolean("ismandatory"), rs.getBoolean("isprimaryfs")));
            }
            return map;
        }
    };
    protected static final ResultSetMapper applicationsRoutePolicyMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            HashMap<Long, ApplicationRoutingPolicyPair> map = new HashMap<Long, ApplicationRoutingPolicyPair>();
            while (rs.next()) {
                map.put(rs.getLong("id"), new ApplicationRoutingPolicyPair(rs.getLong("asmapplication_id"), rs.getLong("routingpolicy_id")));
            }
            return map;
        }
    };

    public AppSetDAO() {
        super(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateSetMapEntry(Long setId) {
        this.lock.acquireWriteLock();
        try {
            this.setMap.remove(setId);
            if (setId == null || !this.assignSetMap.containsKey(setId)) {
                return;
            }
            this.setMap.put(setId, new ArrayList());
            Collections.sort(this.assignSetMap.get(setId), this.sorter);
            for (AppSetAssign assign : this.assignSetMap.get(setId)) {
                AppSetMember member = new AppSetMember(this.applicationMap.get(assign.getApplicationId()).getMediaAttributes(), assign.getMandatory(), assign.getPrimaryFS(), this.applicationMap.get(assign.getApplicationId()).getSipEntityId(), this.applicationMap.get(assign.getApplicationId()).getRoutePolicyIDs(), this.applicationMap.get(assign.getApplicationId()).getHandle(), this.applicationMap.get(assign.getApplicationId()).getURIParams());
                this.setMap.get(setId).add(member);
            }
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateAllApplicationWithRoutePolicyList() {
        this.lock.acquireWriteLock();
        try {
            if (this.routePolicyIDListMap != null && !this.routePolicyIDListMap.isEmpty()) {
                for (Map.Entry<Long, AsmApplication> applicationEntry : this.applicationMap.entrySet()) {
                    Long applicationID = applicationEntry.getKey();
                    AsmApplication applicationValue = applicationEntry.getValue();
                    if (!this.routePolicyIDListMap.containsKey(applicationID)) continue;
                    applicationValue.setRoutePolicyIDs(this.routePolicyIDListMap.get(applicationID));
                }
            }
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    @Override
    protected Object getMainCollection() {
        HashSet<Object> mainTypes = new HashSet<Object>();
        mainTypes.addAll(this.applicationMap.values());
        for (List<AppSetAssign> list : this.assignSetMap.values()) {
            mainTypes.addAll(list);
        }
        return mainTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void init() {
        Map<Long, List<Long>> routePolicyIDListMapTMP;
        Map applicationRoutingPolicyMapTMP;
        Map assignSetMapTMP;
        Map applicationMapTMP;
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)("Initializing " + AppSetDAO.class.getSimpleName()));
        }
        Map attributeMapTMP = null;
        Object[] params = new Object[]{};
        try {
            attributeMapTMP = (Map)this.dataSource.executeQuery(getAttributes, params, this.attributesMapper);
            applicationMapTMP = (Map)this.dataSource.executeQuery(getApplications, params, applicationsMapper);
            assignSetMapTMP = (Map)this.dataSource.executeQuery(getAppSetAssignments, params, assignmentsMapper);
            applicationRoutingPolicyMapTMP = (Map)this.dataSource.executeQuery(getApplicationRoutePolicy, params, applicationsRoutePolicyMapper);
            routePolicyIDListMapTMP = this.buildRoutePolicyIDListMap(applicationRoutingPolicyMapTMP);
            for (Attribute attribute : attributeMapTMP.values()) {
                if (!applicationMapTMP.containsKey(attribute.appId)) continue;
                ((AsmApplication)applicationMapTMP.get(attribute.appId)).setAttribute(attribute.name, attribute.value);
            }
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            this.log.error((Object)("Error initializing " + this.getClass().getSimpleName()), (Throwable)e);
            GenericAlarmHandler.handleFailureEvent(this, e);
            return;
        }
        this.lock.acquireWriteLock();
        try {
            if (this.okay()) {
                this.applicationMap = applicationMapTMP;
                this.attributeMap = attributeMapTMP;
                this.assignSetMap = assignSetMapTMP;
                this.routePolicyIDListMap = routePolicyIDListMapTMP;
                this.asmApplicationToRoutePolicyPairMap = applicationRoutingPolicyMapTMP;
                this.populateAllApplicationWithRoutePolicyList();
                this.setMap = new HashMap<Long, List<AppSetMember>>();
                this.assignIdMap = new HashMap<Long, Long>();
                for (Map.Entry entry : this.assignSetMap.entrySet()) {
                    Long appSetId = (Long)entry.getKey();
                    for (AppSetAssign assign : (List)entry.getValue()) {
                        this.assignIdMap.put(assign.getId(), appSetId);
                    }
                    this.populateSetMapEntry(appSetId);
                }
            }
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    protected Map<Long, List<Long>> buildRoutePolicyIDListMap(Map<Long, ApplicationRoutingPolicyPair> applicationRoutingPolicyMap) {
        HashMap<Long, List<Long>> routePolicyIDListMap = new HashMap<Long, List<Long>>();
        for (Map.Entry<Long, ApplicationRoutingPolicyPair> e : applicationRoutingPolicyMap.entrySet()) {
            ApplicationRoutingPolicyPair pair = e.getValue();
            long applicationId = pair.getAsmApplicationId();
            long routepolicy_id = pair.getRoutePolicyId();
            if (!routePolicyIDListMap.containsKey(applicationId)) {
                routePolicyIDListMap.put(applicationId, new ArrayList());
            }
            ((List)routePolicyIDListMap.get(applicationId)).add(routepolicy_id);
        }
        return routePolicyIDListMap;
    }

    @Override
    public List<String> getDependentTables() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("asmapplication");
        list.add("asmapplicationattribute");
        list.add("asmappsetassign");
        list.add("asmapplication_to_routingpolicy");
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void updateDAO(DAOTableEvent event) {
        DAOReplicationEvent.OperationType operation = event.getOperation();
        String tableName = event.getTableName();
        Long id = event.getKey();
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)this.logTag(operation, tableName, id));
        }
        boolean locked = false;
        ArrayList<Long> setsToUpdate = new ArrayList<Long>();
        ArrayList<Object> oldObjects = new ArrayList<Object>();
        ArrayList<Object> newObjects = new ArrayList<Object>();
        try {
            AsmApplication oldApplication;
            AsmApplication newApplication;
            if ("asmapplicationattribute".equals(tableName)) {
                void var11_14;
                newApplication = null;
                oldApplication = null;
                Object var11_12 = null;
                Object oldAttribute = null;
                if (operation != DAOReplicationEvent.OperationType.DELETE) {
                    Object[] params = new Object[]{id};
                    Map map = (Map)this.dataSource.executeQuery(getAttributeById, params, this.attributesMapper);
                    Attribute attribute = (Attribute)map.get(id);
                }
                this.lock.acquireWriteLock();
                locked = true;
                oldAttribute = this.attributeMap.remove(id);
                if (oldAttribute != null) {
                    oldApplication = this.applicationMap.get(((Attribute)oldAttribute).appId);
                    if (oldApplication == null) {
                        throw new DMException("AsmApplication does not exist for" + event);
                    }
                    if (var11_14 == null) {
                        newApplication = new AsmApplication(oldApplication);
                        newApplication.removeAttribute(((Attribute)oldAttribute).name);
                        this.applicationMap.put(((Attribute)oldAttribute).appId, newApplication);
                    }
                    block5: for (List list : this.assignSetMap.values()) {
                        for (AppSetAssign assign2 : list) {
                            if (assign2.getApplicationId() != ((Attribute)oldAttribute).appId.longValue() || setsToUpdate.contains(assign2.getAppSetId())) continue;
                            setsToUpdate.add(assign2.getAppSetId());
                            continue block5;
                        }
                    }
                }
                if (var11_14 != null) {
                    oldApplication = this.applicationMap.get(var11_14.appId);
                    if (oldApplication == null) {
                        throw new DMException("AsmApplication does not exist for" + event);
                    }
                    newApplication = new AsmApplication(oldApplication);
                    newApplication.setAttribute(var11_14.name, var11_14.value);
                    this.applicationMap.put(var11_14.appId, newApplication);
                    this.attributeMap.put(id, (Attribute)var11_14);
                    block7: for (List list : this.assignSetMap.values()) {
                        for (AppSetAssign assign : list) {
                            if (assign.getApplicationId() != var11_14.appId.longValue() || setsToUpdate.contains(assign.getAppSetId())) continue;
                            setsToUpdate.add(assign.getAppSetId());
                            continue block7;
                        }
                    }
                }
                if (oldApplication != null || newApplication != null) {
                    oldObjects.add(oldApplication);
                    newObjects.add(newApplication);
                }
            } else if ("asmapplication".equals(tableName)) {
                newApplication = null;
                if (operation != DAOReplicationEvent.OperationType.DELETE) {
                    Object[] params = new Object[]{id};
                    newApplication = (AsmApplication)this.dataSource.executeQuery(getApplicationById, params, applicationMapper);
                }
                this.lock.acquireWriteLock();
                locked = true;
                block9: for (List list : this.assignSetMap.values()) {
                    for (Object assign : list) {
                        if (((AppSetAssign)assign).getApplicationId() != id.longValue() || setsToUpdate.contains(((AppSetAssign)assign).getAppSetId())) continue;
                        setsToUpdate.add(((AppSetAssign)assign).getAppSetId());
                        continue block9;
                    }
                }
                oldApplication = this.applicationMap.remove(id);
                if (newApplication != null) {
                    if (operation == DAOReplicationEvent.OperationType.UPDATE) {
                        for (Attribute attribute : this.attributeMap.values()) {
                            if (!attribute.appId.equals(newApplication.getId())) continue;
                            newApplication.setAttribute(attribute.name, attribute.value);
                        }
                    }
                    this.applicationMap.put(id, newApplication);
                    if (this.routePolicyIDListMap.containsKey(id)) {
                        newApplication.setRoutePolicyIDs(this.routePolicyIDListMap.get(id));
                    }
                }
                if (oldApplication != null || newApplication != null) {
                    oldObjects.add(oldApplication);
                    newObjects.add(newApplication);
                }
            } else if ("asmappsetassign".equals(tableName)) {
                void var11_20;
                AppSetAssign oldAssign = null;
                AppSetAssign newAssign = null;
                Object var11_18 = null;
                if (operation != DAOReplicationEvent.OperationType.DELETE) {
                    Object[] params = new Object[]{id};
                    Map map = (Map)this.dataSource.executeQuery(getAppSetAssignmentById, params, assignmentsMapper);
                }
                this.lock.acquireWriteLock();
                locked = true;
                Long appSetId = this.assignIdMap.remove(id);
                if (appSetId != null && this.assignSetMap.containsKey(appSetId)) {
                    for (AppSetAssign appSetAssign : this.assignSetMap.get(appSetId)) {
                        if (appSetAssign.getId() != id.longValue()) continue;
                        oldAssign = appSetAssign;
                        break;
                    }
                    this.assignSetMap.get(appSetId).remove(oldAssign);
                    setsToUpdate.add(appSetId);
                }
                if (var11_20 != null && !var11_20.isEmpty()) {
                    Object assign;
                    assign = var11_20.keySet().iterator();
                    while (assign.hasNext()) {
                        Long l;
                        appSetId = l = (Long)((Object)assign.next());
                    }
                    if (var11_20.get(appSetId) == null || ((List)var11_20.get(appSetId)).size() != 1) {
                        throw new DMException("Invalid data for " + (Object)((Object)operation) + " event");
                    }
                    setsToUpdate.add(appSetId);
                    this.assignIdMap.put(id, appSetId);
                    if (!this.assignSetMap.containsKey(appSetId)) {
                        this.assignSetMap.put(appSetId, new ArrayList());
                    }
                    newAssign = (AppSetAssign)((List)var11_20.get(appSetId)).get(0);
                    this.assignSetMap.get(appSetId).add(newAssign);
                }
                if (this.assignSetMap.containsKey(appSetId) && this.assignSetMap.get(appSetId).isEmpty()) {
                    this.assignSetMap.remove(appSetId);
                }
                if (oldAssign != null || newAssign != null) {
                    oldObjects.add(oldAssign);
                    newObjects.add(newAssign);
                }
            } else if ("asmapplication_to_routingpolicy".equals(tableName)) {
                Object oldApplicationRoutingPolicyPair = null;
                ApplicationRoutingPolicyPair newApplicationRoutingPolicyPair = null;
                Object var11_21 = null;
                List<Long> newRoutePolicyIdList = null;
                List<Long> existingRoutePolicyIDs = null;
                Object var14_35 = null;
                Long routePolicyID = null;
                if (operation != DAOReplicationEvent.OperationType.DELETE) {
                    Object[] params = new Object[]{id};
                    Map singleApplicationToRoutePolicyMap = (Map)this.dataSource.executeQuery(getApplicationRoutePolicyById, params, applicationsRoutePolicyMapper);
                    newApplicationRoutingPolicyPair = (ApplicationRoutingPolicyPair)singleApplicationToRoutePolicyMap.get(id);
                    Map<Long, List<Long>> map = this.buildRoutePolicyIDListMap(singleApplicationToRoutePolicyMap);
                }
                this.lock.acquireWriteLock();
                locked = true;
                Long oldApplicationID = null;
                oldApplicationRoutingPolicyPair = this.asmApplicationToRoutePolicyPairMap.remove(id);
                if (oldApplicationRoutingPolicyPair != null) {
                    AsmApplication existingApplication;
                    oldApplicationID = ((ApplicationRoutingPolicyPair)oldApplicationRoutingPolicyPair).getAsmApplicationId();
                    routePolicyID = ((ApplicationRoutingPolicyPair)oldApplicationRoutingPolicyPair).getRoutePolicyId();
                    existingRoutePolicyIDs = this.routePolicyIDListMap.get(oldApplicationID);
                    existingRoutePolicyIDs.remove(routePolicyID);
                    if (existingRoutePolicyIDs.isEmpty()) {
                        this.routePolicyIDListMap.remove(oldApplicationID);
                        existingRoutePolicyIDs = null;
                    }
                    if ((existingApplication = this.applicationMap.get(oldApplicationID)) != null) {
                        existingApplication.setRoutePolicyIDs(existingRoutePolicyIDs);
                    }
                    block14: for (List<AppSetAssign> list : this.assignSetMap.values()) {
                        for (AppSetAssign appSetAssign : list) {
                            if (appSetAssign.getApplicationId() != oldApplicationID.longValue() || setsToUpdate.contains(appSetAssign.getAppSetId())) continue;
                            setsToUpdate.add(appSetAssign.getAppSetId());
                            continue block14;
                        }
                    }
                }
                if (newApplicationRoutingPolicyPair != null) {
                    void var11_23;
                    Long l = newApplicationRoutingPolicyPair.getAsmApplicationId();
                    newRoutePolicyIdList = (List<Long>)var11_23.get(l);
                    Long newRoutePolicyID = (Long)newRoutePolicyIdList.get(0);
                    List<Long> updatingList = this.routePolicyIDListMap.get(l);
                    if (updatingList != null) {
                        if (!updatingList.contains(newRoutePolicyID)) {
                            updatingList.add(newRoutePolicyID);
                        }
                        newRoutePolicyIdList = updatingList;
                    }
                    this.asmApplicationToRoutePolicyPairMap.put(id, newApplicationRoutingPolicyPair);
                    this.routePolicyIDListMap.put(l, newRoutePolicyIdList);
                    AsmApplication existingApplication = this.applicationMap.get(l);
                    if (existingApplication != null) {
                        existingApplication.setRoutePolicyIDs(newRoutePolicyIdList);
                    }
                    block16: for (List list : this.assignSetMap.values()) {
                        for (AppSetAssign assign5 : list) {
                            if (assign5.getApplicationId() != l.longValue() || setsToUpdate.contains(assign5.getAppSetId())) continue;
                            setsToUpdate.add(assign5.getAppSetId());
                            continue block16;
                        }
                    }
                }
                if (oldApplicationRoutingPolicyPair != null || newApplicationRoutingPolicyPair != null) {
                    oldObjects.add(oldApplicationRoutingPolicyPair);
                    newObjects.add(newApplicationRoutingPolicyPair);
                }
            }
            for (Long setId : setsToUpdate) {
                this.populateSetMapEntry(setId);
            }
        }
        catch (DMException e) {
            if (locked) {
                this.lock.releaseWriteLock();
                locked = false;
            }
            oldObjects.clear();
            newObjects.clear();
            this.log.error((Object)(this.logTag(operation, tableName, id) + "Error updating " + this.getClass().getSimpleName() + " object; re-initializing"), (Throwable)e);
            this.reinit();
            if (!this.okay()) {
                this.log.error((Object)(this.logTag(operation, tableName, id) + "Reinit NOT successful!"));
                return;
            }
        }
        finally {
            if (locked) {
                this.lock.releaseWriteLock();
            }
        }
        if (!oldObjects.isEmpty()) {
            this.updateListeners(oldObjects, newObjects);
        }
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)(this.logTag(operation, tableName, id) + "update successful"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AsmApplication> getAllAppsForSipEntityId(Long seId) {
        ArrayList<AsmApplication> appList = new ArrayList<AsmApplication>();
        try {
            this.lock.acquireReadLock();
            for (AsmApplication app : this.applicationMap.values()) {
                if (app.getSipEntityId() != seId.longValue()) continue;
                appList.add(app);
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        return appList;
    }

    @SMConsole(description="Retrieve all provisioned Application Sets.")
    public Map<Long, List<AppSetMember>> getAllAppSets() {
        this.lock.acquireReadLock();
        try {
            Map<Long, List<AppSetMember>> map = this.setMap;
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public List<AppSetMember> getAppSet(Long setId) {
        this.lock.acquireReadLock();
        try {
            if (this.setMap.containsKey(setId)) {
                ArrayList<AppSetMember> arrayList = new ArrayList<AppSetMember>((Collection)this.setMap.get(setId));
                return arrayList;
            }
            ArrayList<AppSetMember> arrayList = new ArrayList<AppSetMember>();
            return arrayList;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(description="Retrieve all applications available for app-sequencing.")
    public Map<Long, AsmApplication> getAllApplications() {
        this.lock.acquireReadLock();
        try {
            Map<Long, AsmApplication> map = this.applicationMap;
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public AsmApplication getAsmApplication(Long asmApplicationId) {
        this.lock.acquireReadLock();
        try {
            AsmApplication asmApplication = this.applicationMap.get(asmApplicationId);
            return asmApplication;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SMConsole(parameterNames={"sipEntityId"}, description="Get IDs of Application Sets that the given entity is a member of.")
    public List<Long> getAppSetIdsForEntity(long sipEntityId) {
        ArrayList<Long> list = new ArrayList<Long>();
        this.lock.acquireReadLock();
        try {
            for (Map.Entry<Long, List<AppSetMember>> setEntry : this.setMap.entrySet()) {
                for (AppSetMember member : setEntry.getValue()) {
                    if (member.getSipEntityId() != sipEntityId) continue;
                    list.add(setEntry.getKey());
                }
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SMConsole(parameterNames={"routingPolicyID"}, description="Get IDs of Application Sets that reference the given routingPolicyId.")
    public List<Long> getAppSetIdsForRoutingPolicyId(long routingPolicyID) {
        ArrayList<Long> list = new ArrayList<Long>();
        this.lock.acquireReadLock();
        try {
            block3: for (Map.Entry<Long, List<AppSetMember>> setEntry : this.setMap.entrySet()) {
                for (AppSetMember member : setEntry.getValue()) {
                    List<Long> routingPolicyIDs = member.getRoutePolicyIDs();
                    if (routingPolicyIDs == null || !routingPolicyIDs.contains(routingPolicyID)) continue;
                    list.add(setEntry.getKey());
                    continue block3;
                }
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        return list;
    }

    @SMConsole(description="Retrieve all applications and correspondiing routing policy list.")
    public Map<Long, List<Long>> getAllApplicationToRoutingPolicies() {
        this.lock.acquireReadLock();
        try {
            Map<Long, List<Long>> map = this.routePolicyIDListMap;
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    protected class AppSorter
    implements Comparator<AppSetAssign> {
        protected AppSorter() {
        }

        @Override
        public int compare(AppSetAssign a1, AppSetAssign a2) {
            if (a1 == null && a2 == null) {
                return 0;
            }
            if (a1 == null) {
                return 1;
            }
            if (a2 == null) {
                return -1;
            }
            return a1.getOrder() - a2.getOrder();
        }
    }

    public static class ApplicationRoutingPolicyPair {
        private final long asmApplicationId;
        private final long routePolicyId;

        public ApplicationRoutingPolicyPair(long asmApplicationId, long routePolicyId) {
            this.asmApplicationId = asmApplicationId;
            this.routePolicyId = routePolicyId;
        }

        public long getAsmApplicationId() {
            return this.asmApplicationId;
        }

        public long getRoutePolicyId() {
            return this.routePolicyId;
        }

        public String toString() {
            return "ApplicationRoutingPolicyPair[asmApplicationId=" + this.asmApplicationId + ", routePolicyId=" + this.routePolicyId + "]";
        }
    }

    protected static class Attribute {
        public final Long appId;
        public final String name;
        public final String value;

        public Attribute(Long appId, String name, String value) {
            this.appId = appId;
            this.name = name;
            this.value = value;
        }
    }
}

