/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.AsmAddressMappingGroupDAO;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.AsmAddressMappingGroupParm;
import com.avaya.asm.datamgr.objectapi.AsmRemoteClientAddressParm;
import com.avaya.asm.datamgr.objectapi.FQDNOrIpAddr;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AsmRemoteClientAddressDAO
extends DataAccessObject {
    private static final Logger log = AsmLogger.getLogger(AsmRemoteClientAddressDAO.class);
    protected Map<Long, AsmRemoteClientAddressParm> asmRemoteClientAddressMap = new HashMap<Long, AsmRemoteClientAddressParm>();
    public static final String queryAsmRemoteClientAddress = "SELECT id, pattern, address_mapping_group_id, proxy_type, securable FROM asm_remote_client_address";
    public static final String getAsmRemoteClientAddressById = "SELECT id, pattern, address_mapping_group_id, proxy_type, securable FROM asm_remote_client_address WHERE id = ?";
    public static final long defaultGroupId = -99L;
    private static final String myClassSimpleName = AsmRemoteClientAddressDAO.class.getSimpleName();
    protected final String REMOTE_CLIENT_ADDRESS_TABLE = "asm_remote_client_address";
    private static final ResultSetMapper asmRemoteClientAddressesMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            HashMap<Long, AsmRemoteClientAddressParm> map = new HashMap<Long, AsmRemoteClientAddressParm>();
            while (rs.next()) {
                Long id = rs.getLong("id");
                Long groupId = rs.getLong("address_mapping_group_id");
                String pattern = rs.getString("pattern");
                String proxy_type = rs.getString("proxy_type");
                AsmRemoteClientAddressParm asmRemoteClientAddrParms = new AsmRemoteClientAddressParm(id, pattern, groupId, proxy_type, rs.getBoolean("securable"));
                map.put(id, asmRemoteClientAddrParms);
            }
            return map;
        }
    };
    private static final ResultSetMapper asmRemoteClientAddressMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            if (rs.next()) {
                Long id = rs.getLong("id");
                Long groupId = rs.getLong("address_mapping_group_id");
                String pattern = rs.getString("pattern");
                String proxy_type = rs.getString("proxy_type");
                return new AsmRemoteClientAddressParm(id, pattern, groupId, proxy_type, rs.getBoolean("securable"));
            }
            return null;
        }
    };

    public static ResultSetMapper getAsmRemoteClientAddressesMapper() {
        return asmRemoteClientAddressesMapper;
    }

    public static ResultSetMapper getAsmRemoteClientAddressMapper() {
        return asmRemoteClientAddressMapper;
    }

    @Override
    public Object getMainCollection() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        HashMap asmRemoteClientAddressMapTMP;
        String fcn_name = myClassSimpleName + ".init: ";
        boolean isFine = log.isFineEnabled();
        if (isFine) {
            log.fine((Object)(fcn_name + "Enter"));
        }
        this.getDataMgr(AsmAddressMappingGroupDAO.class);
        Object[] params = new Object[]{};
        try {
            asmRemoteClientAddressMapTMP = (HashMap)this.dataSource.executeQuery(queryAsmRemoteClientAddress, params, AsmRemoteClientAddressDAO.getAsmRemoteClientAddressesMapper());
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            log.error((Object)("Error " + fcn_name), (Throwable)e);
            GenericAlarmHandler.handleFailureEvent(this, e);
            return;
        }
        if (this.okay()) {
            try {
                this.lock.acquireWriteLock();
                this.asmRemoteClientAddressMap = asmRemoteClientAddressMapTMP;
            }
            finally {
                this.lock.releaseWriteLock();
                if (isFine) {
                    log.fine((Object)(fcn_name + "completed"));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cascadeDeleteDAO(DAOTableEvent tableEvent) {
        String fcn_name = myClassSimpleName + ".cascadeDeleteDAO: ";
        boolean isFine = log.isFineEnabled();
        DAOReplicationEvent.OperationType operation = tableEvent.getOperation();
        String tableName = tableEvent.getTableName();
        long id = tableEvent.getKey();
        if (isFine) {
            log.fine((Object)(fcn_name + (Object)((Object)operation) + " operation on table " + tableName + " with key " + id));
        }
        if (!this.getDependentTables().contains(tableName) || operation == null) {
            return;
        }
        boolean lockHeld = false;
        try {
            try {
                if (this.asmRemoteClientAddressMap != null) {
                    Set<Map.Entry<Long, AsmRemoteClientAddressParm>> set = this.asmRemoteClientAddressMap.entrySet();
                    Iterator<Map.Entry<Long, AsmRemoteClientAddressParm>> it = set.iterator();
                    this.lock.acquireWriteLock();
                    lockHeld = true;
                    while (it.hasNext()) {
                        Map.Entry<Long, AsmRemoteClientAddressParm> entry = it.next();
                        if (entry.getValue().getAddressMappingGroupId() != id) continue;
                        it.remove();
                    }
                } else {
                    log.warn((Object)("Null value in map for " + fcn_name + (Object)((Object)operation) + " operation on table " + tableName + " with key " + id));
                }
            }
            catch (Exception e) {
                if (lockHeld) {
                    this.lock.releaseWriteLock();
                    lockHeld = false;
                }
                log.error((Object)("Error updating " + fcn_name + (Object)((Object)operation) + " operation on table " + tableName + " with key " + id + "; re-initializing. e = "), (Throwable)e);
                this.reinit();
                if (!this.okay()) {
                    log.error((Object)(fcn_name + (Object)((Object)operation) + " operation on table " + tableName + " with key " + id + ". Reinit NOT successful!"));
                    if (lockHeld) {
                        this.lock.releaseWriteLock();
                    }
                    if (isFine) {
                        log.fine((Object)(fcn_name + " Successful"));
                    }
                    return;
                }
            }
        }
        finally {
            if (lockHeld) {
                this.lock.releaseWriteLock();
            }
            if (isFine) {
                log.fine((Object)(fcn_name + " Successful"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDAO(DAOTableEvent tableEvent) {
        String fcn_name = myClassSimpleName + ".updateDAO: ";
        boolean isFine = log.isFineEnabled();
        boolean isFiner = log.isFinerEnabled();
        DAOReplicationEvent.OperationType operation = tableEvent.getOperation();
        String tableName = tableEvent.getTableName();
        if (!this.getDependentTables().contains(tableName) || operation == null) {
            return;
        }
        long id = tableEvent.getKey();
        if (isFine) {
            log.fine((Object)this.logTag(operation, tableName, id));
        }
        AsmRemoteClientAddressParm addr = null;
        boolean lockHeld = false;
        try {
            if (operation != DAOReplicationEvent.OperationType.DELETE) {
                Object[] params = new Object[]{id};
                addr = (AsmRemoteClientAddressParm)this.dataSource.executeQuery(getAsmRemoteClientAddressById, params, AsmRemoteClientAddressDAO.getAsmRemoteClientAddressMapper());
            }
            this.lock.acquireWriteLock();
            lockHeld = true;
            if (this.asmRemoteClientAddressMap.remove(id) == null && operation == DAOReplicationEvent.OperationType.DELETE) {
                log.warn((Object)(fcn_name + "asmRemoteClientAddrParms was null for " + (Object)((Object)tableEvent.getOperation()) + " operation; we are probably out of sync"));
            }
            if (operation != DAOReplicationEvent.OperationType.DELETE && addr != null) {
                if (isFiner) {
                    log.finer((Object)(fcn_name + addr.toString()));
                }
                this.asmRemoteClientAddressMap.put(id, addr);
            }
        }
        catch (Exception e) {
            if (lockHeld) {
                this.lock.releaseWriteLock();
                lockHeld = false;
            }
            log.error((Object)("Error updating " + this.logTag(operation, tableName, id) + "; re-initializing, e = "), (Throwable)e);
            this.reinit();
            if (!this.okay()) {
                log.error((Object)(this.logTag(operation, tableName, id) + "Reinit NOT successful!"));
                return;
            }
        }
        finally {
            if (lockHeld) {
                this.lock.releaseWriteLock();
            }
            if (isFine) {
                log.fine((Object)(fcn_name + " Successful"));
            }
        }
    }

    @Override
    public List<String> getDependentTables() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("asm_remote_client_address");
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsmRemoteClientAddressParm getAsmRemoteClientAddressMapById(Long id) {
        String fcn_name = myClassSimpleName + ".get: AsmRemoteClientAddressMap" + id;
        try {
            this.lock.acquireReadLock();
            for (AsmRemoteClientAddressParm asmRCAP : this.asmRemoteClientAddressMap.values()) {
                if (asmRCAP.getId().longValue() != id.longValue()) continue;
                if (log.isFinerEnabled()) {
                    log.finer((Object)(fcn_name + " : Found Remote Client Address : " + this.asmRemoteClientAddressMap.get(asmRCAP.getId())));
                }
                AsmRemoteClientAddressParm asmRemoteClientAddressParm = this.asmRemoteClientAddressMap.get(asmRCAP.getId());
                return asmRemoteClientAddressParm;
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long isOrigAddressSBC(String originalAddress) {
        String fcn_name = myClassSimpleName + ": isOrigAddressSBC : " + originalAddress;
        try {
            this.lock.acquireReadLock();
            FQDNOrIpAddr origAddress = new FQDNOrIpAddr(originalAddress);
            for (AsmRemoteClientAddressParm asmRCAP : this.asmRemoteClientAddressMap.values()) {
                if (!origAddress.isEqualTo(asmRCAP.getPattern())) continue;
                if (log.isFinerEnabled()) {
                    log.finer((Object)(fcn_name + " : Found Original Address " + originalAddress + " in SBC list. "));
                }
                long l = asmRCAP.getAddressMappingGroupId();
                return l;
            }
            long l = -99L;
            return l;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAvayaSBC(String originalAddress) {
        String fcn_name = myClassSimpleName + ": isAvayaSBC : " + originalAddress;
        try {
            this.lock.acquireReadLock();
            FQDNOrIpAddr origAddress = new FQDNOrIpAddr(originalAddress);
            for (AsmRemoteClientAddressParm asmRCAP : this.asmRemoteClientAddressMap.values()) {
                if (!origAddress.isEqualTo(asmRCAP.getPattern()) || !asmRCAP.getProxyType().equals("Avaya_SBC")) continue;
                if (log.isFinerEnabled()) {
                    log.finer((Object)(fcn_name + " : Found Original Address SBC type is Avaya_SBC"));
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean isSecurable(String originalAddress) {
        String fcn_name = myClassSimpleName + ": isSecurable : " + originalAddress;
        try {
            this.lock.acquireReadLock();
            FQDNOrIpAddr origAddress = new FQDNOrIpAddr(originalAddress);
            for (AsmRemoteClientAddressParm asmRCAP : this.asmRemoteClientAddressMap.values()) {
                if (!origAddress.isEqualTo(asmRCAP.getPattern())) continue;
                if (asmRCAP.isSecurable()) {
                    if (log.isFinerEnabled()) {
                        log.finer((Object)(fcn_name + " : Found Original Address is securable"));
                    }
                    Boolean bl = true;
                    return bl;
                }
                if (log.isFinerEnabled()) {
                    log.finer((Object)(fcn_name + " : Found Original Address is not securable"));
                }
                Boolean bl = false;
                return bl;
            }
            if (log.isFinerEnabled()) {
                log.finer((Object)(fcn_name + " : Found Original Address is not an SBC"));
            }
            Iterator<AsmRemoteClientAddressParm> iterator = null;
            return iterator;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @Override
    public void objectChanged(Object oldObject, Object newObject) {
        if (log.isFinerEnabled()) {
            log.finer((Object)(myClassSimpleName + ".objectChanged: " + oldObject + " became " + newObject));
        }
        if (oldObject instanceof AsmAddressMappingGroupParm || newObject instanceof AsmAddressMappingGroupParm) {
            AsmAddressMappingGroupParm oldAsmAddressMappingGroupParm = (AsmAddressMappingGroupParm)oldObject;
            AsmAddressMappingGroupParm newAsmAddressMappingGroupParm = (AsmAddressMappingGroupParm)newObject;
            if (oldAsmAddressMappingGroupParm != null && newAsmAddressMappingGroupParm != null && oldAsmAddressMappingGroupParm.equals(newAsmAddressMappingGroupParm)) {
                if (log.isFinestEnabled()) {
                    log.finest((Object)(myClassSimpleName + ".objectChanged:  groupId CHANGED with same groupId - ignored"));
                }
                return;
            }
            if (oldObject != null && newObject == null) {
                if (log.isFinestEnabled()) {
                    log.finest((Object)(myClassSimpleName + ".objectChanged: group mapping with id " + oldAsmAddressMappingGroupParm.getId() + " DELETED"));
                }
                DAOTableEvent event = new DAOTableEvent("asm_remote_client_address", DAOReplicationEvent.OperationType.DELETE, oldAsmAddressMappingGroupParm.getId());
                this.cascadeDeleteDAO(event);
            }
            if (newObject != null && log.isFinestEnabled()) {
                log.finest((Object)(myClassSimpleName + ".objectChanged: receive event notify that a new group id " + newAsmAddressMappingGroupParm.getId().intValue() + " is added in asm_address_mapping_group table "));
            }
        }
    }
}

