/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmConstants;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DeviceSettingsDAO;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.AsmTerminalGroupParm;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CPDeviceSettingsDAO
extends DeviceSettingsDAO {
    private static final Logger log = AsmLogger.getLogger(CPDeviceSettingsDAO.class);
    protected Map<Long, Long> locationToTerminalGroup = new HashMap<Long, Long>();
    protected Long defaultGroupId = 0L;
    protected static final String GET_TERMINAL_GROUPS_TO_LOCATIONS = "SELECT asmterminalgroupparm_id, routingorigination_id FROM asmterminalgrouptoloc";
    protected static final ResultSetMapper locationToTerminalGroupMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            HashMap<Long, Long> locationsToTerminalGroup = new HashMap<Long, Long>();
            while (rs.next()) {
                Long terminalGroup = rs.getLong("asmterminalgroupparm_id");
                Long location = rs.getLong("routingorigination_id");
                locationsToTerminalGroup.put(location, terminalGroup);
            }
            return locationsToTerminalGroup;
        }
    };

    @Override
    public List<String> getDependentTables() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("asmterminalgroupparm");
        list.add("asmterminalgrouptoloc");
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        Map locationToTerminalGroupTMP;
        HashMap deviceSettingsMapTMP;
        String fcn_name = CPDeviceSettingsDAO.class.getSimpleName() + ".init: ";
        boolean isFine = log.isFineEnabled();
        if (isFine) {
            log.fine((Object)(fcn_name + "Enter"));
        }
        try {
            deviceSettingsMapTMP = (HashMap)this.dataSource.executeQuery("SELECT id, name, terminal_group_num, reg_expire_secs, reg_min_expire_secs, line_resv_secs, afs_sub_expire_secs, afs_sub_min_expire_secs,  ds_sub_expire_secs, ds_sub_min_expire_secs, mw_sub_expire_secs, mw_sub_min_expire_secs,  ppm_sub_expire_secs, ppm_sub_min_expire_secs, regev_sub_expire_secs, regev_sub_min_expire_secs,  ringer_volume, ringer_cadence, receiver_volume, speaker_volume, vmmserver_ipaddress,  vmmserver_port, vmmreport_period_secs, snmp_ipaddress, snmp_community, station_admin_password,  complex_password_salt, complex_password_algorithm, complex_password_hash,  quick_login_status, reactive_mon_intvl_secs, timer_b_secs, registration_policy, vlan_number,  call_control_phb, audio_phb, video_phb, call_control_802_priority, audio_802_priority, video_802_priority,  signaling_mode, media_mode, time_zone FROM asmterminalgroupparm", new Object[0], this.getDeviceSettingsMapper());
            locationToTerminalGroupTMP = (Map)this.dataSource.executeQuery(GET_TERMINAL_GROUPS_TO_LOCATIONS, new Object[0], locationToTerminalGroupMapper);
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            log.error((Object)("Error" + fcn_name), (Throwable)e);
            GenericAlarmHandler.handleFailureEvent(this, e);
            return;
        }
        if (this.okay()) {
            try {
                this.lock.acquireWriteLock();
                this.deviceSettingsMap = deviceSettingsMapTMP;
                for (AsmTerminalGroupParm termGroup : this.deviceSettingsMap.values()) {
                    if (!termGroup.getTerminalGroupName().equals("Default Group")) continue;
                    this.defaultGroupId = termGroup.getId();
                    break;
                }
                this.locationToTerminalGroup = locationToTerminalGroupTMP;
            }
            finally {
                this.lock.releaseWriteLock();
                if (log.isFinestEnabled()) {
                    log.finest((Object)("completing " + fcn_name + "deviceSettingsMap = " + this.deviceSettingsMap));
                    log.finest((Object)("locationToTerminalGroupMap = " + this.locationToTerminalGroup));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDAO(DAOTableEvent tableEvent) {
        String fcn_name = CPDeviceSettingsDAO.class.getSimpleName() + ".updateDAO: ";
        DAOReplicationEvent.OperationType operation = tableEvent.getOperation();
        String tableName = tableEvent.getTableName();
        if (!this.getDependentTables().contains(tableName) || operation == null) {
            return;
        }
        Long id = tableEvent.getKey();
        if (log.isFineEnabled()) {
            log.fine((Object)(fcn_name + (Object)((Object)operation) + " operation on table " + tableName + " with key " + id));
        }
        if ("asmterminalgroupparm".equals(tableName)) {
            super.updateDAO(tableEvent);
            return;
        }
        boolean locked = false;
        try {
            this.lock.acquireWriteLock();
            locked = true;
            try {
                this.locationToTerminalGroup = (Map)this.dataSource.executeQuery(GET_TERMINAL_GROUPS_TO_LOCATIONS, new Object[0], locationToTerminalGroupMapper);
                if (log.isFinestEnabled()) {
                    log.finest((Object)("completing " + fcn_name + "deviceSettingsMap = " + this.deviceSettingsMap));
                    log.finest((Object)("locationToTerminalGroup = " + this.locationToTerminalGroup));
                }
            }
            catch (Exception e) {
                if (locked) {
                    this.lock.releaseWriteLock();
                    locked = false;
                }
                log.error((Object)(fcn_name + " Error updating object; re-initializing"), (Throwable)e);
                this.reinit();
                if (!this.okay()) {
                    log.error((Object)(fcn_name + " NOT successful!"));
                    if (locked) {
                        this.lock.releaseWriteLock();
                        locked = false;
                    }
                    return;
                }
            }
        }
        finally {
            if (locked) {
                this.lock.releaseWriteLock();
                locked = false;
            }
        }
        if (log.isFineEnabled()) {
            log.fine((Object)(fcn_name + " Successful"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SMConsole(parameterNames={"locationID"}, description="Get the AsmTerminalGroupParm object for the given location ID.")
    public AsmTerminalGroupParm getSettingsForLocation(Long locationID) {
        String fcn_name = CPDeviceSettingsDAO.class.getSimpleName() + ".getSettingsForLocation: " + locationID;
        boolean isFiner = log.isFinerEnabled();
        boolean isFinest = log.isFinestEnabled();
        if (isFiner) {
            log.finer((Object)(fcn_name + " : Enter with locationID: " + locationID));
        }
        try {
            this.lock.acquireReadLock();
            Long terminalGroupID = this.locationToTerminalGroup.get(locationID);
            if (terminalGroupID == null) {
                if (this.defaultGroupId == 0L) {
                    AsmTerminalGroupParm asmTerminalGroupParm = null;
                    return asmTerminalGroupParm;
                }
                terminalGroupID = this.defaultGroupId;
            }
            if (isFinest) {
                log.finest((Object)(fcn_name + " : terminal group ID: " + terminalGroupID));
            }
            AsmTerminalGroupParm asmTerminalGroupParm = (AsmTerminalGroupParm)this.deviceSettingsMap.get(terminalGroupID);
            return asmTerminalGroupParm;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public int getMinRegistrationExpiration(Long locationId) {
        Integer expiresValue;
        AsmTerminalGroupParm deviceSettings = this.getSettingsForLocation(locationId);
        if (deviceSettings != null && (expiresValue = deviceSettings.getMinRegExpirationTimer()) != null) {
            return expiresValue;
        }
        return 60;
    }

    public int getMaxRegistrationExpiration(Long locationId) {
        Integer expiresValue;
        AsmTerminalGroupParm deviceSettings = this.getSettingsForLocation(locationId);
        if (deviceSettings != null && (expiresValue = deviceSettings.getMaxRegExpirationTimer()) != null) {
            return expiresValue;
        }
        return 86400;
    }

    public int getMinSubscriptionExpiration(Long locationId, String eventPackage) {
        Integer expiresValue;
        AsmTerminalGroupParm deviceSettings = this.getSettingsForLocation(locationId);
        if (deviceSettings != null && (expiresValue = deviceSettings.getMinSubscriptionExpiration(eventPackage)) != null) {
            return expiresValue;
        }
        return 60;
    }

    public int getMaxSubscriptionExpiration(Long locationId, String eventPackage) {
        Integer expiresValue;
        AsmTerminalGroupParm deviceSettings = this.getSettingsForLocation(locationId);
        if (deviceSettings != null && (expiresValue = deviceSettings.getMaxSubscriptionExpiration(eventPackage)) != null) {
            return expiresValue;
        }
        return 86400;
    }

    @SMConsole(description="Get the AsmTerminalGroupParm maps.")
    public String getDeviceSettingMaps() {
        try {
            this.lock.acquireReadLock();
            String string = this.locationToTerminalGroup + "\n" + this.deviceSettingsMap;
            return string;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public int getEndpointTimerB(Long locationId) {
        Integer endpointTimerB = AsmConstants.ENDPOINT_TIMER_B;
        AsmTerminalGroupParm deviceSettings = this.getSettingsForLocation(locationId);
        if (deviceSettings != null) {
            endpointTimerB = deviceSettings.getTimerb();
        }
        return endpointTimerB;
    }
}

