/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.LocationPatternStructure;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DigitMapDAO
extends DataAccessObject {
    private static final Logger log = AsmLogger.getLogger(DigitMapDAO.class);
    private Map<Long, LocationPatternStructure> emergencyDMMap = null;
    private ArrayList<LocationPatternStructure> emergencyDMMapValues = null;
    private Map<Long, ArrayList<LocationPatternStructure>> digitPatternsByLocationCache = new HashMap<Long, ArrayList<LocationPatternStructure>>();
    private Map<Long, ArrayList<Long>> emergencyLocationMap = null;
    private static final String queryDMs = "SELECT id, digitpattern, routingorigination_id, deny, emergency_desc, emergency_order, digitmap_origination_pattern_set_id FROM digitmap WHERE treatasemergency = 't'";
    private static final String queryDM = "SELECT id, digitpattern, routingorigination_id, deny, emergency_desc, emergency_order, digitmap_origination_pattern_set_id FROM digitmap WHERE treatasemergency = 't' AND id = ?";
    public static final Long Location_ALL = new Long(0L);
    private static final ResultSetMapper digitMapsMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            HashMap<Long, LocationPatternStructure> dmMap = new HashMap<Long, LocationPatternStructure>();
            while (rs.next()) {
                Long id = rs.getLong("id");
                dmMap.put(id, DigitMapDAO.retrieveMapperData(rs));
            }
            return dmMap;
        }
    };
    private static final ResultSetMapper digitMapMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            if (rs.next()) {
                return DigitMapDAO.retrieveMapperData(rs);
            }
            return null;
        }
    };

    public DigitMapDAO() {
        super(true);
        this.emergencyDMMap = new HashMap<Long, LocationPatternStructure>();
        this.emergencyDMMapValues = new ArrayList();
        this.emergencyLocationMap = new HashMap<Long, ArrayList<Long>>();
    }

    public static ResultSetMapper getDigitMapsMapper() {
        return digitMapsMapper;
    }

    public static ResultSetMapper getDigitMapMapper() {
        return digitMapMapper;
    }

    private static LocationPatternStructure retrieveMapperData(ResultSet rs) throws SQLException {
        String digitpattern = rs.getString("digitpattern");
        long routingorigination_id = rs.getLong("routingorigination_id");
        boolean deny = rs.getBoolean("deny");
        String emerDesc = rs.getString("emergency_desc");
        int emerOrder = rs.getInt("emergency_order");
        long origination_pattern_set_id = rs.getLong("digitmap_origination_pattern_set_id");
        return new LocationPatternStructure(routingorigination_id, digitpattern, deny, emerDesc, emerOrder, origination_pattern_set_id);
    }

    @Override
    public Object getMainCollection() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void init() {
        boolean isFineEnabled = log.isFineEnabled();
        if (isFineEnabled) {
            log.fine((Object)("Initializing " + DigitMapDAO.class.getSimpleName()));
        }
        Map digitMapTMP = null;
        HashMap<Long, LocationPatternStructure> emergencyDMMapTMP = null;
        ArrayList emergencyDMMapValuesTMP = null;
        HashMap<Long, ArrayList<Long>> emergencyLocationMapTMP = null;
        try {
            Object[] params = new Object[]{};
            digitMapTMP = (Map)this.dataSource.executeQuery(queryDMs, params, DigitMapDAO.getDigitMapsMapper());
            emergencyDMMapTMP = new HashMap<Long, LocationPatternStructure>();
            emergencyLocationMapTMP = new HashMap<Long, ArrayList<Long>>();
            this.initializeEmergencyMaps(digitMapTMP, emergencyDMMapTMP, emergencyLocationMapTMP);
            emergencyDMMapValuesTMP = new ArrayList(emergencyDMMapTMP.values());
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e2) {
            this.setStatus(DataMgr.Status.FAIL);
            log.error((Object)("Error initializing " + this.getClass().getSimpleName()), (Throwable)e2);
            GenericAlarmHandler.handleFailureEvent(this, e2);
        }
        try {
            this.lock.acquireWriteLock();
            this.emergencyDMMap = emergencyDMMapTMP;
            this.emergencyDMMapValues = emergencyDMMapValuesTMP;
            this.emergencyLocationMap = emergencyLocationMapTMP;
            this.digitPatternsByLocationCache.clear();
        }
        finally {
            this.lock.releaseWriteLock();
            if (log.isFineEnabled()) {
                log.fine((Object)"DigitMapDAO: completing init");
            }
        }
    }

    private void initializeEmergencyMaps(Map<Long, LocationPatternStructure> digitMapTMP, Map<Long, LocationPatternStructure> emergencyDMMapTMP, Map<Long, ArrayList<Long>> emergencyLocationMapTMP) {
        for (Map.Entry<Long, LocationPatternStructure> mapEntry : digitMapTMP.entrySet()) {
            long id = mapEntry.getKey();
            LocationPatternStructure locationPatternStruct = mapEntry.getValue();
            long locationId = locationPatternStruct.getLocationId();
            if (!emergencyDMMapTMP.containsKey(id)) {
                emergencyDMMapTMP.put(id, locationPatternStruct);
            } else {
                log.warn((Object)"DigitMapDAO - duplicate id in emergencyDM Map");
            }
            if (!emergencyLocationMapTMP.containsKey(locationId)) {
                emergencyLocationMapTMP.put(locationId, new ArrayList());
            }
            emergencyLocationMapTMP.get(locationId).add(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void updateDAO(DAOTableEvent event) {
        boolean isFineEnabled = log.isFineEnabled();
        boolean isFinerEnabled = log.isFinerEnabled();
        DAOReplicationEvent.OperationType operation = event.getOperation();
        String tableName = event.getTableName();
        if (!this.getDependentTables().contains(tableName) || operation == null) {
            return;
        }
        LocationPatternStructure locationPatternStructOld = null;
        long id = event.getKey();
        if (isFineEnabled) {
            log.fine((Object)(DigitMapDAO.class.getSimpleName() + ".updateDAO: " + (Object)((Object)operation) + " " + tableName + " " + id));
        }
        boolean locked = false;
        try {
            Object[] params;
            this.lock.acquireWriteLock();
            locked = true;
            locationPatternStructOld = this.emergencyDMMap.remove(id);
            this.digitPatternsByLocationCache.clear();
            if (locationPatternStructOld == null && operation == DAOReplicationEvent.OperationType.DELETE) {
                log.warn((Object)("emergencyDMMap was null for " + (Object)((Object)operation) + " operation; we are probably out of sync"));
            }
            Long locationIDToUpdate = null;
            ArrayList<Long> Ids = null;
            block5: for (Long locationId : this.emergencyLocationMap.keySet()) {
                if (locationIDToUpdate != null) break;
                Ids = this.emergencyLocationMap.get(locationId);
                for (Long perLocationId : Ids) {
                    if (perLocationId != id) continue;
                    locationIDToUpdate = locationId;
                    continue block5;
                }
            }
            if (locationIDToUpdate != null) {
                this.emergencyLocationMap.remove(locationIDToUpdate);
                if (Ids.size() > 1) {
                    Ids.remove(id);
                    this.emergencyLocationMap.put(locationIDToUpdate, Ids);
                }
            }
            LocationPatternStructure locationPatternStruct = null;
            if ((operation == DAOReplicationEvent.OperationType.UPDATE || operation == DAOReplicationEvent.OperationType.INSERT) && (locationPatternStruct = (LocationPatternStructure)this.dataSource.executeQuery(queryDM, params = new Object[]{id}, DigitMapDAO.getDigitMapMapper())) != null) {
                if (isFinerEnabled) {
                    log.finer((Object)("Retrieved  digit pattern " + locationPatternStruct.getDigitPattern() + " and " + locationPatternStruct.getLocationId() + " for id " + id));
                }
                Long locationId = locationPatternStruct.getLocationId();
                String digitsPattern = locationPatternStruct.getDigitPattern();
                if (digitsPattern != null) {
                    this.emergencyDMMap.put(id, locationPatternStruct);
                }
                if (locationId != null) {
                    Ids = this.emergencyLocationMap.get(locationId);
                    if (Ids == null) {
                        Ids = new ArrayList();
                    } else {
                        this.emergencyLocationMap.remove(locationId);
                    }
                    Ids.add(id);
                    this.emergencyLocationMap.put(locationId, Ids);
                }
            }
            this.emergencyDMMapValues = new ArrayList<LocationPatternStructure>(this.emergencyDMMap.values());
            this.updateListeners(locationPatternStructOld, locationPatternStruct);
        }
        catch (DMException e) {
            if (locked) {
                this.lock.releaseWriteLock();
                locked = false;
            }
            log.error((Object)("Error updating " + DigitMapDAO.class.getSimpleName() + " object; re-initializing"), (Throwable)e);
            this.reinit();
            if (!this.okay()) {
                log.finer((Object)"Update NOT successful.");
                return;
            }
        }
        finally {
            if (locked) {
                this.lock.releaseWriteLock();
            }
        }
        if (isFineEnabled) {
            log.fine((Object)(DigitMapDAO.class.getSimpleName() + " update successful"));
        }
    }

    @Override
    public List<String> getDependentTables() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("digitmap");
        return list;
    }

    public ArrayList<LocationPatternStructure> getDigitMaps() {
        ArrayList<LocationPatternStructure> dmList = null;
        try {
            this.lock.acquireReadLock();
            if (this.emergencyDMMapValues != null && !this.emergencyDMMapValues.isEmpty()) {
                dmList = this.emergencyDMMapValues;
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        return dmList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SMConsole(parameterNames={"routingOriginationId"}, description="Get the list of emergency numbers associated with the given location.")
    public ArrayList<LocationPatternStructure> getDigitMaps(Long routingOriginationId) {
        boolean isFiner = log.isFinerEnabled();
        boolean isFinest = log.isFinestEnabled();
        String fcn_name = "getDigitMaps";
        if (isFiner) {
            log.finer((Object)("getDigitMaps: enter, routingOriginationId=" + routingOriginationId));
        }
        ArrayList<LocationPatternStructure> dmLocationList = null;
        if (routingOriginationId != null) {
            try {
                this.lock.acquireReadLock();
                if (this.digitPatternsByLocationCache.containsKey(routingOriginationId)) {
                    dmLocationList = this.digitPatternsByLocationCache.get(routingOriginationId);
                    if (isFinest) {
                        log.finest((Object)("getDigitMaps: found dmLocationList.size=" + dmLocationList.size() + " in cache for routingOriginationId=" + routingOriginationId));
                    }
                } else {
                    ArrayList<Long> idsPerLocationList = this.emergencyLocationMap.get(routingOriginationId);
                    if (idsPerLocationList != null && !idsPerLocationList.isEmpty()) {
                        for (Long id : idsPerLocationList) {
                            LocationPatternStructure emergencyDigitPattern = this.emergencyDMMap.get(id);
                            if (emergencyDigitPattern != null) {
                                if (dmLocationList == null) {
                                    dmLocationList = new ArrayList();
                                }
                                dmLocationList.add(emergencyDigitPattern);
                                continue;
                            }
                            log.error((Object)("Error getting the corresponding emergency dial pattern for id=" + id + " Routing origination ID = " + routingOriginationId));
                        }
                        this.digitPatternsByLocationCache.put(routingOriginationId, dmLocationList);
                        if (log.isFinestEnabled()) {
                            log.finest((Object)("getDigitMaps: adding dmLocationList.size=" + dmLocationList.size() + " to cache for routingOriginationId=" + routingOriginationId));
                        }
                    }
                }
            }
            finally {
                this.lock.releaseReadLock();
            }
        }
        if (isFiner) {
            log.finer((Object)("getDigitMaps: leave, dmLocationList=" + dmLocationList));
        }
        return dmLocationList;
    }

    public ArrayList<LocationPatternStructure> getGeneralLocationDigitMaps() {
        ArrayList<LocationPatternStructure> lpsList = this.getDigitMaps(Location_ALL);
        return lpsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SMConsole(description="Get the contents of all internal storage related to IPTDigitMap.  This method exists for debugging the IptDigitMapDAO.")
    public StringBuffer getIptDigitMapData() {
        StringBuffer retData = new StringBuffer();
        try {
            this.lock.acquireReadLock();
            retData.append("emergencyDMMap (digitMap ID to digit pattern string, " + this.emergencyDMMap.size() + " entries\n");
            for (Map.Entry<Long, LocationPatternStructure> entry : this.emergencyDMMap.entrySet()) {
                retData.append(entry + "\n");
            }
            retData.append("\nemergencyLocationMap (routingOriginationId to list of ArrayList of digit map ids, " + this.emergencyLocationMap.size() + " entries\n");
            for (Map.Entry<Long, Object> entry : this.emergencyLocationMap.entrySet()) {
                retData.append("routingOriginationId " + entry.getKey() + ":\n");
                for (Long digits : (ArrayList)entry.getValue()) {
                    retData.append(digits.toString() + "\n");
                }
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        return retData;
    }
}

