/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class IsDeletedHandler
extends DataAccessObject {
    private static final Logger log = AsmLogger.getLogger(IsDeletedHandler.class);
    public static final String UserProfileJoinStatement = "FROM csuser u JOIN cscommprofileset set ON set.csuserid = u.id JOIN cscommprofile cs ON cs.cscommprofilesetid = set.id JOIN asmcommprofile asm ON asm.id = cs.id";
    protected boolean reinitedLately = false;
    protected String getIdsByUserId = "SELECT set.id, u.isdeleted FROM cscommprofileset set, csuser u WHERE set.csuserid=u.id AND u.id = ?";
    public static String isDeletedCommProfileSetId = "SELECT set.id FROM cscommprofileset set, csuser u WHERE set.csuserid=u.id AND u.isdeleted=true";
    public static String isDeletedCsUserId = "SELECT id FROM csuser WHERE isdeleted=true";
    protected static final ResultSetMapper userMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            HashMap<Long, Boolean> map = new HashMap<Long, Boolean>();
            while (rs.next()) {
                long id = rs.getLong("id");
                map.put(id, rs.getBoolean("isdeleted"));
            }
            return map;
        }
    };

    public IsDeletedHandler() {
    }

    public IsDeletedHandler(boolean supportsListeners) {
        super(supportsListeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void noteReinit() {
        IsDeletedHandler isDeletedHandler = this;
        synchronized (isDeletedHandler) {
            this.reinitedLately = true;
        }
    }

    @Override
    public DataMgr.Status reinit() {
        this.noteReinit();
        return super.reinit();
    }

    public abstract String getMainTable();

    @Override
    public List<String> getDependentTables() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.getMainTable());
        list.add("csuser");
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void updateDAO(DAOTableEvent event) {
        if (!"csuser".equals(event.getTableName())) {
            return;
        }
        DAOReplicationEvent.OperationType operation = event.getOperation();
        String tableName = event.getTableName();
        long id = event.getKey();
        Object[] params = new Object[]{id};
        try {
            if (operation != DAOReplicationEvent.OperationType.UPDATE) return;
            Map userMap = (Map)this.dataSource.executeQuery(this.getIdsByUserId, params, userMapper);
            if (log.isFinestEnabled()) {
                log.finest((Object)(this.logTag(operation, tableName, id) + "IDs for user " + id + " now have deleted state: " + userMap));
            }
            if (userMap.isEmpty()) return;
            DAOTableEvent newEvent = new DAOTableEvent(this.getMainTable(), (Boolean)userMap.values().iterator().next() != false ? DAOReplicationEvent.OperationType.DELETE : DAOReplicationEvent.OperationType.INSERT, 0L);
            IsDeletedHandler isDeletedHandler = this;
            synchronized (isDeletedHandler) {
                this.reinitedLately = false;
            }
            for (Long key : userMap.keySet()) {
                newEvent.setKey(key);
                this.updateDAO(newEvent);
                IsDeletedHandler isDeletedHandler2 = this;
                synchronized (isDeletedHandler2) {
                    if (this.reinitedLately) {
                        return;
                    }
                }
            }
            return;
        }
        catch (Exception e) {
            log.error((Object)(this.logTag(operation, tableName, id) + "Error updating " + this.getClass().getSimpleName() + " object; re-initializing"), (Throwable)e);
            this.reinit();
            if (this.okay()) return;
            log.error((Object)(this.logTag(operation, tableName, id) + "Reinit NOT successful!"));
        }
    }
}

