/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.UserCommunityDAO;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.RegionCommunityAssign;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class RegionCommunityDAO
extends DataAccessObject {
    private final Logger log = AsmLogger.getLogger(RegionCommunityDAO.class);
    private static final List<String> dependentTables = new ArrayList<String>();
    private Map<Long, RegionCommunityAssign> assignMap = new HashMap<Long, RegionCommunityAssign>();
    protected Map<Long, List<RegionCommunityAssign>> communityAssignMap = new HashMap<Long, List<RegionCommunityAssign>>();
    public static final String getRegionCommunityAssigns = "SELECT id, asm_storage_cluster_id, asm_region_community_id, priorityorder FROM asm_region_community_assign";
    public static final String getRegionCommunityAssign = "SELECT id, asm_storage_cluster_id, asm_region_community_id, priorityorder FROM asm_region_community_assign WHERE id = ?";
    protected static final ResultSetMapper regionCommunityAssignMapper;

    public RegionCommunityDAO() {
        super(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        HashMap<Long, List<RegionCommunityAssign>> communityAssignMapTMP;
        Map assignMapTMP;
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)("Initializing " + RegionCommunityDAO.class.getSimpleName()));
        }
        Object[] params = new Object[]{};
        try {
            assignMapTMP = (Map)this.dataSource.executeQuery(getRegionCommunityAssigns, params, regionCommunityAssignMapper);
            communityAssignMapTMP = new HashMap<Long, List<RegionCommunityAssign>>();
            for (RegionCommunityAssign assign : assignMapTMP.values()) {
                RegionCommunityAssign a;
                Long regionCommunityId = assign.getRegionCommunityId();
                if (!communityAssignMapTMP.containsKey(regionCommunityId)) {
                    communityAssignMapTMP.put(regionCommunityId, new ArrayList());
                }
                int idx = 0;
                List assigns = (List)communityAssignMapTMP.get(regionCommunityId);
                Iterator iterator = assigns.iterator();
                while (iterator.hasNext() && (a = (RegionCommunityAssign)iterator.next()).getPriorityOrder() < assign.getPriorityOrder()) {
                    ++idx;
                }
                assigns.add(idx, assign);
            }
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            this.log.error((Object)("Error initializing " + this.getClass().getSimpleName()), (Throwable)e);
            this.handleFailureEvent(e);
            return;
        }
        if (this.okay()) {
            try {
                this.lock.acquireWriteLock();
                this.assignMap = assignMapTMP;
                this.communityAssignMap = communityAssignMapTMP;
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDAO(DAOTableEvent event) {
        DAOReplicationEvent.OperationType operation = event.getOperation();
        boolean locked = false;
        String tableName = event.getTableName();
        if (!this.getDependentTables().contains(tableName) || operation == null) {
            return;
        }
        Long id = event.getKey();
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)(RegionCommunityDAO.class.getSimpleName() + ".updateDAO: " + (Object)((Object)operation) + " " + tableName + " " + id));
        }
        RegionCommunityAssign oldAssign = null;
        RegionCommunityAssign newAssign = null;
        try {
            this.lock.acquireWriteLock();
            locked = true;
            try {
                oldAssign = this.assignMap.remove(id);
                if (oldAssign != null) {
                    Long communityId = oldAssign.getRegionCommunityId();
                    List<RegionCommunityAssign> assigns = this.communityAssignMap.get(communityId);
                    assigns.remove(oldAssign);
                    if (assigns.isEmpty()) {
                        this.communityAssignMap.remove(communityId);
                    }
                } else if (operation != DAOReplicationEvent.OperationType.INSERT) {
                    this.log.warn((Object)("AssignList was null for " + (Object)((Object)operation) + "; we are probably out of sync"));
                }
                if (operation == DAOReplicationEvent.OperationType.INSERT || operation == DAOReplicationEvent.OperationType.UPDATE) {
                    Object[] params = new Object[]{id};
                    Map map = (Map)this.dataSource.executeQuery(getRegionCommunityAssign, params, regionCommunityAssignMapper);
                    newAssign = (RegionCommunityAssign)map.get(id);
                    if (newAssign == null) {
                        throw new DMException("Data does not exist for " + (Object)((Object)operation) + " event");
                    }
                    if (this.log.isFinerEnabled()) {
                        this.log.finer((Object)("Retrieved new community assignment " + newAssign));
                    }
                    this.assignMap.put(id, newAssign);
                    Long regionCommunityId = newAssign.getRegionCommunityId();
                    if (!this.communityAssignMap.containsKey(regionCommunityId)) {
                        this.communityAssignMap.put(regionCommunityId, new ArrayList());
                    }
                    this.communityAssignMap.get(regionCommunityId).add(newAssign);
                    Collections.sort(this.communityAssignMap.get(regionCommunityId), new RegionCommunityAssign.PriorityComparator());
                }
            }
            catch (DMException e) {
                if (locked) {
                    this.lock.releaseWriteLock();
                    locked = false;
                }
                this.log.error((Object)("Error updating " + UserCommunityDAO.class.getSimpleName() + " object; re-initializing"), (Throwable)e);
                this.reinit();
                if (!this.okay()) {
                    this.log.error((Object)(this.getClass().getSimpleName() + " Update NOT successful!"));
                    if (locked) {
                        this.lock.releaseWriteLock();
                        locked = false;
                    }
                    return;
                }
            }
        }
        finally {
            if (locked) {
                this.lock.releaseWriteLock();
                locked = false;
            }
        }
        if (oldAssign != null || newAssign != null) {
            this.updateListeners(oldAssign, newAssign);
        }
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)(RegionCommunityDAO.class.getSimpleName() + " update successful"));
        }
    }

    @Override
    public List<String> getDependentTables() {
        return dependentTables;
    }

    @Override
    protected Object getMainCollection() {
        return this.assignMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SMConsole(parameterNames={"regionCommunityId"}, description="Get the RegionCommunityAssign's in the given Region Community.")
    public List<RegionCommunityAssign> getRegionCommunityAssigns(Long regionCommunityId) {
        this.lock.acquireReadLock();
        try {
            List<RegionCommunityAssign> assigns = this.communityAssignMap.get(regionCommunityId);
            if (assigns != null) {
                List<RegionCommunityAssign> list = assigns;
                return list;
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        return new ArrayList<RegionCommunityAssign>();
    }

    protected void handleFailureEvent(Exception e) {
        GenericAlarmHandler.handleFailureEvent(this, e);
    }

    static {
        dependentTables.add("asm_region_community_assign");
        regionCommunityAssignMapper = new ResultSetMapper(){

            @Override
            public Object mapResults(ResultSet rs) throws SQLException {
                HashMap<Long, RegionCommunityAssign> map = new HashMap<Long, RegionCommunityAssign>();
                while (rs.next()) {
                    RegionCommunityAssign assign = new RegionCommunityAssign(rs.getLong("asm_storage_cluster_id"), rs.getLong("asm_region_community_id"), rs.getInt("priorityorder"));
                    map.put(rs.getLong("id"), assign);
                }
                return map;
            }
        };
    }
}

