/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.branch;

import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.dao.ConfFactoryDAO;
import com.avaya.asm.datamgr.dao.SIPEntityDAO;
import com.avaya.asm.datamgr.dao.branch.BranchFeatureServerDAO;
import com.avaya.asm.datamgr.dao.branch.BranchSIPEntityDAO;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.objectapi.ConfFactory;
import com.avaya.asm.datamgr.objectapi.IPAddress;
import com.avaya.asm.datamgr.objectapi.TransportAddress;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BranchConfFactoryDAO
extends ConfFactoryDAO {
    protected static final String getBranchConfFactories = "SELECT id, uri, sip_entity_id, accepts_audio, accepts_video, accepts_text, match_type, if_no_sdp, asm_conf_factory_set_id, priority_order FROM asm_conf_factory WHERE sip_entity_id=?";

    @Override
    protected Map<Long, ConfFactory> queryConfFactories() throws DMException {
        Long featureServerId;
        HashMap<Long, ConfFactory> confFactoryMapTMP = new HashMap<Long, ConfFactory>();
        String lspIpAddress = ((BranchSIPEntityDAO)this.getDataMgr(SIPEntityDAO.class)).getLSPAddress();
        if (lspIpAddress == null) {
            return confFactoryMapTMP;
        }
        Long trunkGatewayId = ((BranchSIPEntityDAO)this.getDataMgr(SIPEntityDAO.class)).getTrunkGatewayId();
        if (trunkGatewayId != null) {
            Object[] params = new Object[]{trunkGatewayId};
            confFactoryMapTMP.putAll((Map)this.dataSource.executeQuery(getBranchConfFactories, params, this.getConfFactoriesMapper()));
        }
        if ((featureServerId = ((BranchFeatureServerDAO)this.getDataMgr(BranchFeatureServerDAO.class)).getFeatureServerId()) != null) {
            Object[] params = new Object[]{featureServerId};
            confFactoryMapTMP.putAll((Map)this.dataSource.executeQuery(getBranchConfFactories, params, this.getConfFactoriesMapper()));
            List<Long> otherFeatureServerIds = ((BranchFeatureServerDAO)this.getDataMgr(BranchFeatureServerDAO.class)).getOtherFeatureServerIds();
            for (Long otherFeatureServerId : otherFeatureServerIds) {
                params = new Object[]{otherFeatureServerId};
                Map map = (Map)this.dataSource.executeQuery(getBranchConfFactories, params, this.getConfFactoriesMapper());
                for (Map.Entry entry : map.entrySet()) {
                    ConfFactory cf = (ConfFactory)entry.getValue();
                    cf.setSipEntityId(featureServerId);
                }
                confFactoryMapTMP.putAll(map);
            }
        }
        for (ConfFactory cf : confFactoryMapTMP.values()) {
            this.replaceHostUriWithLsp(cf, lspIpAddress);
        }
        return confFactoryMapTMP;
    }

    @Override
    protected ConfFactory queryConfFactory(Long id) throws DMException {
        String lspIpAddress;
        ConfFactory new_cf = super.queryConfFactory(id);
        if (new_cf == null) {
            return null;
        }
        long sipEntityId = new_cf.getSipEntityId();
        Long trunkGatewayId = ((BranchSIPEntityDAO)this.getDataMgr(SIPEntityDAO.class)).getTrunkGatewayId();
        if (trunkGatewayId == null || trunkGatewayId != sipEntityId) {
            Long featureServerId = ((BranchFeatureServerDAO)this.getDataMgr(BranchFeatureServerDAO.class)).getFeatureServerId();
            if (featureServerId == null) {
                return null;
            }
            if (featureServerId != sipEntityId) {
                List<Long> otherFeatureServerIds = ((BranchFeatureServerDAO)this.getDataMgr(BranchFeatureServerDAO.class)).getOtherFeatureServerIds();
                if (otherFeatureServerIds.contains(sipEntityId)) {
                    new_cf.setSipEntityId(featureServerId);
                } else {
                    return null;
                }
            }
        }
        if ((lspIpAddress = ((BranchSIPEntityDAO)this.getDataMgr(SIPEntityDAO.class)).getLSPAddress()) != null) {
            this.replaceHostUriWithLsp(new_cf, lspIpAddress);
        }
        return new_cf;
    }

    protected void replaceHostUriWithLsp(ConfFactory new_cf, String lspIpAddress) {
        TransportAddress hostAddr;
        if (new_cf == null) {
            return;
        }
        String uri = new_cf.getUri();
        int beginIndex = uri.indexOf(64) + 1;
        int endIndex = uri.length();
        for (int idx = beginIndex; idx < endIndex; ++idx) {
            char c = uri.charAt(idx);
            if (c == '[') {
                if ((idx = uri.indexOf(93, idx)) >= 0) continue;
                return;
            }
            if (c != ':' && c != ';' && c != ',' && c != '?') continue;
            endIndex = idx;
            break;
        }
        String host = uri.substring(beginIndex, endIndex);
        try {
            hostAddr = TransportAddress.fromString(host);
        }
        catch (ParseException e) {
            return;
        }
        if (IPAddress.isIPAddress(hostAddr.getFqdnOrIpAddress())) {
            new_cf.setUri(uri.replace(host, new TransportAddress(lspIpAddress, -1).toString()));
        }
    }

    @Override
    protected void handleNullQuery(DAOReplicationEvent.OperationType operation) throws DMException {
    }

    @Override
    protected void handleNullOldCf(DAOReplicationEvent.OperationType operation) {
    }
}

