/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.cassandra;

import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.dao.cassandra.PreparedStatements;
import com.avaya.asm.datamgr.dao.cassandra.PushNotificationPreparedStatementType;
import com.avaya.asm.datamgr.dao.cassandra.SessionDAO;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreKeyspaceBuilder;
import com.datastax.driver.core.PreparedStatement;

public class PushNotificationPreparedStatements
extends PreparedStatements<PushNotificationPreparedStatementType> {
    public static final String KEYSPACE = "global_user_dc";
    private static final String PUSH_NOTIFICATION_CF = "global_user_dc.pushnotification";
    private static final String PARTITION_KEY_FILTER = " WHERE bucketid=? AND commprofilesetid=?";
    private static final String PARTITION_KEY_AND_CLUSTER_FILTER = " WHERE bucketid=? AND commprofilesetid=? AND sipInstanceId=?";
    private static final String PARTITION_KEY_LOCAL_FILTER = " WHERE commprofilesetid IN ?";
    private static final String GET_NOTIFICATION = "SELECT commprofilesetid,pushNotificationServiceType, applicationType,applicationPushToken, applicationVoIPPushToken, sipInstanceId,delayedEC500Information_alternateNetworkType, delayedEC500Information_alterneteNetworkAddres,controls_enableIncomingCallNotification,controls_enableMessageWaitingIndication,controls_useVoIPPushNotificationChannelForIncomingCalls,controls_useDevelopmentPushNotificationNetwork,encryptionScheme, encryptionKey, activationTime FROM global_user_dc.pushnotification";
    private static final String SET_NOTIFICATION = "UPDATE global_user_dc.pushnotification set activationTime=?,applicationPushToken=?,applicationType=?,applicationVoIPPushToken=?,controls_enableIncomingCallNotification=?,controls_enableMessageWaitingIndication=?,controls_useDevelopmentPushNotificationNetwork=?,controls_useVoIPPushNotificationChannelForIncomingCalls=?,delayedEC500Information_alternateNetworkType=?,delayedEC500Information_alterneteNetworkAddres=?,encryptionKey=?,encryptionScheme=?,pushNotificationServiceType=? WHERE bucketid=? AND commprofilesetid=? AND sipInstanceId=?";
    private static final String SET_NOTIFICATION_UPDATE = "UPDATE global_user_dc.pushnotification set pushNotificationServiceType=?,applicationType=?,applicationPushToken=?,applicationVoIPPushToken=?,delayedEC500Information_alternateNetworkType=?,delayedEC500Information_alterneteNetworkAddres=?,controls_enableIncomingCallNotification=?,controls_enableMessageWaitingIndication=?,controls_useVoIPPushNotificationChannelForIncomingCalls=?,controls_useDevelopmentPushNotificationNetwork=?,encryptionScheme=?,encryptionKey=?,encryptionKeyTimeStamp=?,updateDateTime=? WHERE bucketid=? AND commprofilesetid=? AND sipInstanceId=?";
    private static final String DELETE_NOTIFICATION = "DELETE FROM global_user_dc.pushnotification WHERE bucketid=? AND commprofilesetid=? AND sipInstanceId=?";
    private static final String GET_ALL_NOTIFICATION = "SELECT commprofilesetid,pushNotificationServiceType, applicationType,applicationPushToken, applicationVoIPPushToken, sipInstanceId,delayedEC500Information_alternateNetworkType, delayedEC500Information_alterneteNetworkAddres,controls_enableIncomingCallNotification,controls_enableMessageWaitingIndication,controls_useVoIPPushNotificationChannelForIncomingCalls,controls_useDevelopmentPushNotificationNetwork,encryptionScheme, encryptionKey, activationTime FROM global_user_dc.pushnotification WHERE bucketid=? AND commprofilesetid=? LIMIT ? ALLOW FILTERING";
    private static final String GET_ALL_PN_BY_SIPINSTANCE_RANGE = "SELECT commprofilesetid,pushNotificationServiceType, applicationType,applicationPushToken, applicationVoIPPushToken, sipInstanceId,delayedEC500Information_alternateNetworkType, delayedEC500Information_alterneteNetworkAddres,controls_enableIncomingCallNotification,controls_enableMessageWaitingIndication,controls_useVoIPPushNotificationChannelForIncomingCalls,controls_useDevelopmentPushNotificationNetwork,encryptionScheme, encryptionKey, activationTime FROM global_user_dc.pushnotification WHERE bucketid=? AND commprofilesetid=? AND sipInstanceId > ? LIMIT ? ALLOW FILTERING";
    private static final String DELETE_ALL_NOTIFICATION = "DELETE FROM global_user_dc.pushnotification WHERE bucketid=? AND commprofilesetid=?";
    private static final String GET_ALL_LOCAL_NOTIFICATION = "SELECT commprofilesetid,pushNotificationServiceType, applicationType,applicationPushToken, applicationVoIPPushToken, sipInstanceId,delayedEC500Information_alternateNetworkType, delayedEC500Information_alterneteNetworkAddres,controls_enableIncomingCallNotification,controls_enableMessageWaitingIndication,controls_useVoIPPushNotificationChannelForIncomingCalls,controls_useDevelopmentPushNotificationNetwork,encryptionScheme, encryptionKey, activationTime FROM global_user_dc.pushnotification WHERE commprofilesetid IN ?";
    private static final String COMMPROFILESETID_BY_BUCKET = "SELECT commprofilesetid FROM global_user_dc.pushnotification WHERE bucketid = ? LIMIT ?";
    private static final String BULK_COMMPROFILESETID_BY_BUCKET = "SELECT commprofilesetid FROM global_user_dc.pushnotification WHERE bucketid = ? AND commprofilesetid > ? LIMIT ?";
    private static final String GET_ALL_NOTIFICATION_BY_BUCKET = "SELECT commprofilesetid,pushNotificationServiceType, applicationType,applicationPushToken, applicationVoIPPushToken, sipInstanceId,delayedEC500Information_alternateNetworkType, delayedEC500Information_alterneteNetworkAddres,controls_enableIncomingCallNotification,controls_enableMessageWaitingIndication,controls_useVoIPPushNotificationChannelForIncomingCalls,controls_useDevelopmentPushNotificationNetwork,encryptionScheme, encryptionKey, activationTime FROM global_user_dc.pushnotification WHERE bucketid=? AND commprofilesetid IN ? LIMIT ?";
    private static final String GET_NEXT_CHUNK_OF_ALL_NOTFICATION_BY_BUCKET = "SELECT commprofilesetid,pushNotificationServiceType, applicationType,applicationPushToken, applicationVoIPPushToken, sipInstanceId,delayedEC500Information_alternateNetworkType, delayedEC500Information_alterneteNetworkAddres,controls_enableIncomingCallNotification,controls_enableMessageWaitingIndication,controls_useVoIPPushNotificationChannelForIncomingCalls,controls_useDevelopmentPushNotificationNetwork,encryptionScheme, encryptionKey, activationTime FROM global_user_dc.pushnotification WHERE bucketid=? AND commprofilesetid IN ? AND sipInstanceId > ? LIMIT ?";

    public PushNotificationPreparedStatements(SessionDAO dao) {
        super(PushNotificationPreparedStatementType.class, dao);
    }

    @Override
    protected PreparedStatement prepareStatement(PushNotificationPreparedStatementType queryType, UserStoreKeyspaceBuilder keyspaceBuilder) throws DMException {
        StringBuilder query = new StringBuilder();
        switch (queryType) {
            case GET_NOTIFICATION: {
                query.append(GET_NOTIFICATION);
                query.append(PARTITION_KEY_AND_CLUSTER_FILTER);
                break;
            }
            case SET_NOTIFICATION: {
                query.append(SET_NOTIFICATION);
                break;
            }
            case SET_NOTIFICATION_UPDATE: {
                query.append(SET_NOTIFICATION_UPDATE);
                break;
            }
            case DELETE_NOTIFICATION: {
                query.append(DELETE_NOTIFICATION);
                break;
            }
            case GET_ALL_NOTIFICATION: {
                query.append(GET_ALL_NOTIFICATION);
                break;
            }
            case DELETE_ALL_NOTIFICATION: {
                query.append(DELETE_ALL_NOTIFICATION);
                break;
            }
            case GET_ALL_LOCAL_NOTIFICATION: {
                query.append(GET_ALL_LOCAL_NOTIFICATION);
                break;
            }
            case GET_ALL_PN_BY_SIPINSTANCE_RANGE: {
                query.append(GET_ALL_PN_BY_SIPINSTANCE_RANGE);
                break;
            }
            case COMMPROFILESETID_BY_BUCKET: {
                query.append(COMMPROFILESETID_BY_BUCKET);
                break;
            }
            case BULK_COMMPROFILESETID_BY_BUCKET: {
                query.append(BULK_COMMPROFILESETID_BY_BUCKET);
                break;
            }
            case GET_ALL_NOTIFICATION_BY_BUCKET: {
                query.append(GET_ALL_NOTIFICATION_BY_BUCKET);
                break;
            }
            case GET_NEXT_CHUNK_OF_ALL_NOTFICATION_BY_BUCKET: {
                query.append(GET_NEXT_CHUNK_OF_ALL_NOTFICATION_BY_BUCKET);
                break;
            }
        }
        return this.prepareQuery(query.toString(), keyspaceBuilder);
    }
}

