/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.datadistributionlayer;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.datamgr.DMFactory;
import com.avaya.asm.datamgr.DMListener;
import com.avaya.asm.datamgr.dao.AsmInstanceDAO;
import com.avaya.asm.datamgr.dao.GlobalDAO;
import com.avaya.asm.datamgr.datadistributionlayer.DDLInterClusterMember;
import com.avaya.asm.datamgr.datadistributionlayer.DDLInterClusterMemberHelperIntfc;
import com.avaya.asm.datamgr.datadistributionlayer.DDLInterClusterSecureIntfc;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerFactory;
import com.avaya.asm.datamgr.objectapi.AsmInstance;
import com.avaya.common.logging.client.Logger;
import java.util.Vector;

public class DDLInterClusterHelper
implements DDLInterClusterMemberHelperIntfc,
DDLInterClusterSecureIntfc,
DMListener {
    private static final Logger log = AsmLogger.getLogger(DDLInterClusterHelper.class);
    private GlobalDAO globalDAO = null;
    private AsmInstanceDAO instanceDAO = null;

    protected static DMFactory getDMFactory() {
        return DMFactory.getInstance();
    }

    protected static DataDistLayerFactory getDDLFactory() {
        return DataDistLayerFactory.getInstance();
    }

    protected GlobalDAO getGlobalDAO() {
        this.globalDAO = (GlobalDAO)DDLInterClusterHelper.getDMFactory().getDataMgr(GlobalDAO.class);
        return this.globalDAO;
    }

    protected AsmInstanceDAO getAsmInstanceDAO() {
        this.instanceDAO = (AsmInstanceDAO)DDLInterClusterHelper.getDMFactory().getDataMgr(AsmInstanceDAO.class);
        this.instanceDAO.registerListener(this);
        return this.instanceDAO;
    }

    @Override
    public String getKeyPassword() {
        String ret = (String)this.getGlobalDAO().getGlobalParameter("jgrppw", new String[0]);
        return ret == null ? "" : ret;
    }

    @Override
    public String getStorePassword() {
        return (String)this.getGlobalDAO().getGlobalParameter("jgrppw", new String[0]);
    }

    public String getMD5HashJGroupsKeyStore() {
        return this.getGlobalDAO().getMD5HashJGroupsKeyStore();
    }

    public String getMD5HashJGroupsKeyStore(KeystoreType keystore) {
        return this.getGlobalDAO().getMD5HashJGroupsKeyStore(keystore);
    }

    @Override
    public Vector<String> getInterClusterMemberIPs() {
        return this.getAsmInstanceDAO().getInterClusterMemberIPs();
    }

    @Override
    public String getMyIp() {
        return this.getAsmInstanceDAO().getMyIp();
    }

    @Override
    public void objectChanged(Object oldObject, Object newObject) {
        if (oldObject instanceof AsmInstance || newObject instanceof AsmInstance) {
            DDLInterClusterMember member = DataDistLayerFactory.getInstance().getInterClusterMember();
            if (member != null) {
                String oldIp = oldObject != null ? ((AsmInstance)oldObject).getManagementAccessPointHostName() : null;
                String newIp = newObject != null ? ((AsmInstance)newObject).getManagementAccessPointHostName() : null;
                member.updateForHost(oldIp, newIp);
            }
        } else {
            log.error((Object)("Unexpected type: " + (oldObject != null ? oldObject.getClass().getSimpleName() : (newObject != null ? newObject.getClass().getSimpleName() : null))));
        }
    }

    public static enum KeystoreType {
        WAS,
        JBOSS;

    }
}

