/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dynamic;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.AsmInstanceDAO;
import com.avaya.asm.datamgr.dao.LocationDAO;
import com.avaya.asm.datamgr.dynamic.DynamicDataMgr;
import com.avaya.asm.datamgr.objectapi.Location;
import com.avaya.asm.datamgr.objectapi.LocationRegionCommunity;
import com.avaya.asm.datamgr.objectapi.PerformanceMonitoringEvent;
import com.avaya.common.logging.client.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class PerformanceMonitoringDDM
extends DynamicDataMgr {
    private static final Logger log = AsmLogger.getLogger(PerformanceMonitoringDDM.class);
    protected Timer expirationTimer = new Timer(true);
    protected TimerTask purgeTask = null;
    protected Map<Long, List<PerformanceMonitoringEvent>> data;

    protected long getCurrentTime() {
        return System.currentTimeMillis() / 1000L;
    }

    protected AsmInstanceDAO getInstanceDAO() {
        return (AsmInstanceDAO)this.getDataMgr(AsmInstanceDAO.class);
    }

    @Override
    public void init() {
        try {
            this.lock.acquireWriteLock();
            this.data = new HashMap<Long, List<PerformanceMonitoringEvent>>();
        }
        finally {
            this.lock.releaseWriteLock();
        }
        this.getDataMgr(LocationDAO.class);
        if (this.purgeTask != null) {
            this.purgeTask.cancel();
        }
        this.purgeTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    PerformanceMonitoringDDM.this.purgeOldData();
                }
                catch (Exception e) {
                    log.error((Object)"Exception in task for expiring performance monitoring data", (Throwable)e);
                }
            }
        };
        this.expirationTimer.scheduleAtFixedRate(this.purgeTask, 2000L, 300000L);
        log.info((Object)"Created a periodic timer that fires every 300 seconds");
        this.setStatus(DataMgr.Status.OKAY);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.purgeTask.cancel();
        this.expirationTimer.cancel();
    }

    public void logLocationEvent(Long locationId, String event, int count) {
        this.updateDataMap(new PerformanceMonitoringEvent(PerformanceMonitoringEvent.KeyType.LOCATION, locationId, event), count);
    }

    public void logEntityEvent(Long entityId, String event, int count) {
        this.updateDataMap(new PerformanceMonitoringEvent(PerformanceMonitoringEvent.KeyType.SIP_ENTITY, entityId, event), count);
    }

    public void logSMEvent(Long asmId, String event, int count) {
        this.updateDataMap(new PerformanceMonitoringEvent(PerformanceMonitoringEvent.KeyType.SESSION_MANAGER, asmId, event), count);
    }

    public void logPushApplicationEvent(Long applicationId, String event, int count) {
        this.updateDataMap(new PerformanceMonitoringEvent(PerformanceMonitoringEvent.KeyType.PUSH_APPLICATION, applicationId, event), count);
    }

    public void logPushProviderEvent(Long providerId, String event, int count) {
        this.updateDataMap(new PerformanceMonitoringEvent(PerformanceMonitoringEvent.KeyType.PUSH_PROVIDER, providerId, event), count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDataMap(PerformanceMonitoringEvent key, int count) {
        try {
            List<PerformanceMonitoringEvent> eventList;
            int index;
            this.lock.acquireWriteLock();
            long time = this.getCurrentTime();
            if (!this.data.containsKey(time)) {
                this.data.put(time, new ArrayList());
            }
            if ((index = (eventList = this.data.get(time)).indexOf(key)) == -1) {
                key.setCount(count);
                eventList.add(key);
            } else {
                eventList.get(index).incrementCount(count);
            }
            if (log.isFinestEnabled()) {
                log.finest((Object)("Logged a performance monitoring event: " + eventList.get(eventList.indexOf(key)) + ", count=" + count));
            }
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    public int getCountForLocation(Long locationId, String event, long time) throws IllegalArgumentException {
        PerformanceMonitoringEvent key = new PerformanceMonitoringEvent(PerformanceMonitoringEvent.KeyType.LOCATION, locationId, event);
        return this.getCount(key, time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount(PerformanceMonitoringEvent key, long time) throws IllegalArgumentException {
        long currentTime = this.getCurrentTime();
        if (currentTime - time > 600L) {
            throw new IllegalArgumentException("Time is too far in the past; limit is 600 seconds ago.");
        }
        try {
            this.lock.acquireReadLock();
            int count = 0;
            for (long i = time; i <= currentTime; ++i) {
                List<PerformanceMonitoringEvent> eventList;
                int index;
                if (!this.data.containsKey(i) || (index = (eventList = this.data.get(i)).indexOf(key)) < 0) continue;
                count += eventList.get(index).getCount();
            }
            int n = count;
            return n;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PerformanceMonitoringEvent> getAllPerformanceMonitoringData(int numSeconds) throws IllegalArgumentException {
        ArrayList<PerformanceMonitoringEvent> retVal = new ArrayList<PerformanceMonitoringEvent>();
        long time = this.getCurrentTime() - (long)numSeconds;
        try {
            this.lock.acquireReadLock();
            for (Map.Entry<Long, List<PerformanceMonitoringEvent>> entry : this.data.entrySet()) {
                if (entry.getKey() < time) continue;
                for (PerformanceMonitoringEvent event : entry.getValue()) {
                    int index = retVal.indexOf(event);
                    if (index == -1) {
                        retVal.add(new PerformanceMonitoringEvent(event));
                        continue;
                    }
                    ((PerformanceMonitoringEvent)retVal.get(index)).setCount(((PerformanceMonitoringEvent)retVal.get(index)).getCount() + event.getCount());
                }
            }
            ArrayList<PerformanceMonitoringEvent> arrayList = retVal;
            return arrayList;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeOldData() {
        long expireTime = this.getCurrentTime() - 600L;
        ArrayList<Long> keysToDelete = new ArrayList<Long>();
        try {
            this.lock.acquireWriteLock();
            for (Long time : this.data.keySet()) {
                if (time >= expireTime) continue;
                keysToDelete.add(time);
            }
            for (Long time : keysToDelete) {
                this.data.remove(time);
            }
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void objectChanged(Object oldObject, Object newObject) {
        if (oldObject instanceof Location || newObject instanceof Location) {
            if (newObject == null) {
                Location deletedLocation = (Location)oldObject;
                try {
                    this.lock.acquireWriteLock();
                    for (Map.Entry<Long, List<PerformanceMonitoringEvent>> entry : this.data.entrySet()) {
                        ArrayList<PerformanceMonitoringEvent> keys = new ArrayList<PerformanceMonitoringEvent>();
                        for (PerformanceMonitoringEvent key : entry.getValue()) {
                            if (!PerformanceMonitoringEvent.KeyType.LOCATION.equals((Object)key.getKeyType()) || !deletedLocation.getId().equals(key.getKeyId())) continue;
                            keys.add(key);
                        }
                        for (PerformanceMonitoringEvent key : keys) {
                            entry.getValue().remove(key);
                        }
                    }
                }
                finally {
                    this.lock.releaseWriteLock();
                }
                if (log.isFineEnabled()) {
                    log.fine((Object)("Deleted data for deleted location: " + deletedLocation));
                }
            }
            return;
        }
        if (!(oldObject instanceof LocationRegionCommunity) && !(newObject instanceof LocationRegionCommunity)) {
            log.warn((Object)("Received unexpected change alert for " + oldObject + " changing to " + newObject + ". This should never happen! Adding Exception for stack trace"), (Throwable)new Exception());
        }
    }
}

