/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.helpers;

import com.avaya.asm.core.AsmLogger;
import com.avaya.common.logging.client.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class FlexCache<K, V>
implements Map<K, V> {
    private final Logger log = AsmLogger.getLogger(FlexCache.class);
    protected Map<K, V> map;
    private HashSet<EvictEntry<K, V>> evicted = new HashSet();
    private boolean isLinkedHashMap = false;
    private int capacity = -1;

    public FlexCache(int capacity, HashMap<K, V> map, boolean useReference) {
        if (map != null && !map.getClass().isAssignableFrom(HashMap.class)) {
            throw new IllegalArgumentException("Parameter 'map' must be a HashMap");
        }
        this.construct(capacity, map, useReference);
    }

    public FlexCache(int capacity) {
        this.construct(capacity, null, false);
    }

    public FlexCache() {
        this.construct(-1, null, false);
    }

    public FlexCache(HashMap<K, V> map, boolean useReference) {
        this(-1, map, useReference);
    }

    private void construct(int capacity, HashMap<K, V> map, boolean useReference) {
        this.capacity = capacity;
        if (capacity > 0) {
            this.isLinkedHashMap = true;
            this.map = new LinkedHashMap<K, V>(capacity, 0.75f, true){
                private static final long serialVersionUID = -5022033447219621256L;

                @Override
                protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                    return FlexCache.this.flexCacheRemoveEldestEntry(eldest);
                }
            };
            if (map != null) {
                this.map.putAll(map);
            }
        } else {
            this.map = map == null ? new HashMap() : (useReference ? map : new HashMap<K, V>(map));
        }
    }

    public int getCapacity() {
        return this.capacity;
    }

    public Set<EvictEntry<K, V>> reportEvictions() {
        if (this.isLinkedHashMap) {
            return this.reportEvictionsSynchronized();
        }
        return this.evicted;
    }

    private synchronized Set<EvictEntry<K, V>> reportEvictionsSynchronized() {
        return new HashSet<EvictEntry<K, V>>(this.evicted);
    }

    protected boolean flexCacheRemoveEldestEntry(Map.Entry<K, V> eldest) {
        int delta = this.size() - this.capacity;
        if (delta <= 0) {
            return false;
        }
        if (delta > 1 && this.log.isFineEnabled()) {
            this.log.fine((Object)("This FlexCache is unexpectedly large. The expected size is " + this.capacity + " entries but the actual size is " + this.size() + " entries"));
        }
        this.evicted.add(new EvictEntry<K, V>(eldest.getKey(), eldest.getValue()));
        return true;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.isLinkedHashMap) {
            return this.containsValueSynchronized(value);
        }
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        if (this.isLinkedHashMap) {
            return this.getSynchronized(key);
        }
        return this.map.get(key);
    }

    @Override
    public V put(K key, V value) {
        if (this.isLinkedHashMap) {
            return this.putSynchronized(key, value);
        }
        return this.map.put(key, value);
    }

    public final Set<EvictEntry<K, V>> putReportEviction(K key, V value) {
        if (this.isLinkedHashMap) {
            return this.putReportEvictionSynchronized(key, value);
        }
        this.map.put(key, value);
        return this.evicted;
    }

    @Override
    public V remove(Object key) {
        if (this.isLinkedHashMap) {
            return this.removeSynchronized(key);
        }
        return this.map.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        if (this.isLinkedHashMap) {
            this.putAllSynchronized(m);
            return;
        }
        this.map.putAll(m);
    }

    public final Set<EvictEntry<K, V>> putAllReportEvictions(Map<? extends K, ? extends V> m) {
        if (this.isLinkedHashMap) {
            return this.putAllReportEvictionsSynchronized(m);
        }
        this.map.putAll(m);
        return this.evicted;
    }

    @Override
    public void clear() {
        if (this.isLinkedHashMap) {
            this.clearSynchronized();
            return;
        }
        this.map.clear();
    }

    @Override
    public final Set<K> keySet() {
        if (this.isLinkedHashMap) {
            return this.keySetSynchronized();
        }
        return new HashSet<K>(this.map.keySet());
    }

    @Override
    public Collection<V> values() {
        if (this.isLinkedHashMap) {
            return this.valuesSynchronized();
        }
        return new ArrayList<V>(this.map.values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.isLinkedHashMap) {
            return this.entrySetSynchronized();
        }
        return new HashSet<Map.Entry<K, V>>(this.map.entrySet());
    }

    public String toString() {
        if (this.isLinkedHashMap) {
            return this.toStringSynchronized();
        }
        return this.map.toString();
    }

    private synchronized boolean containsValueSynchronized(Object value) {
        return this.map.containsValue(value);
    }

    private synchronized V getSynchronized(Object key) {
        return this.map.get(key);
    }

    private synchronized V putSynchronized(K key, V value) {
        return this.map.put(key, value);
    }

    private synchronized Set<EvictEntry<K, V>> putReportEvictionSynchronized(K key, V value) {
        this.evicted.clear();
        this.map.put(key, value);
        return new HashSet<EvictEntry<K, V>>(this.evicted);
    }

    private synchronized V removeSynchronized(Object key) {
        return this.map.remove(key);
    }

    private synchronized void putAllSynchronized(Map<? extends K, ? extends V> m) {
        this.map.putAll(m);
    }

    private synchronized Set<EvictEntry<K, V>> putAllReportEvictionsSynchronized(Map<? extends K, ? extends V> m) {
        this.evicted.clear();
        this.map.putAll(m);
        return new HashSet<EvictEntry<K, V>>(this.evicted);
    }

    private synchronized void clearSynchronized() {
        this.map.clear();
    }

    private synchronized Set<K> keySetSynchronized() {
        return new HashSet<K>(this.map.keySet());
    }

    private synchronized Collection<V> valuesSynchronized() {
        return new ArrayList<V>(this.map.values());
    }

    private synchronized Set<Map.Entry<K, V>> entrySetSynchronized() {
        return new HashSet<Map.Entry<K, V>>(this.map.entrySet());
    }

    private synchronized String toStringSynchronized() {
        return this.map.toString();
    }

    public Map<K, V> getCopyOfInternalMap() {
        if (this.isLinkedHashMap) {
            return this.getCopyOfInternalMapSynchronized();
        }
        return new HashMap<K, V>(this.map);
    }

    private synchronized Map<K, V> getCopyOfInternalMapSynchronized() {
        return new HashMap<K, V>(this.map);
    }

    public String getInternalMapClassName() {
        if (this.map instanceof LinkedHashMap) {
            return "LinkedHashMap";
        }
        return this.map.getClass().getSimpleName();
    }

    public static class EvictEntry<KK, VV> {
        private KK key;
        private VV value;

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EvictEntry other = (EvictEntry)obj;
            if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        public EvictEntry(KK key, VV value) {
            this.key = key;
            this.value = value;
        }

        public KK getKey() {
            return this.key;
        }

        public VV getValue() {
            return this.value;
        }

        public String toString() {
            return this.key.toString() + ", " + this.value.toString();
        }
    }
}

