/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.objectapi;

import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerMember;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerMemberAddr;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerMessage;
import com.avaya.asm.datamgr.objectapi.CallRoutingTestInput;
import com.avaya.asm.datamgr.objectapi.CallRoutingTestQueryIntf;
import com.avaya.asm.datamgr.objectapi.CallRoutingTestResult;
import com.avaya.asm.datamgr.objectapi.MonitorSummary;
import com.avaya.asm.datamgr.objectapi.MonitoredEntity;
import com.avaya.asm.datamgr.objectapi.SipMonitorQueryIntf;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CallProcQuery
implements SipMonitorQueryIntf,
CallRoutingTestQueryIntf {
    private final DataDistLayerMember ddlMember;

    public CallProcQuery(DataDistLayerMember member) {
        this.ddlMember = member;
    }

    @Override
    public List<MonitoredEntity> sipMonitorQueryDowns() {
        MonitorSummary summary = this.sipMonitorSummaryQuery();
        ArrayList<String> downList = new ArrayList<String>();
        downList.addAll(summary.getPartiallyUp());
        downList.addAll(summary.getDown());
        return this.sipMonitorQueryList(downList);
    }

    @Override
    public List<MonitoredEntity> sipMonitorQueryNotMonitored() {
        MonitorSummary summary = this.sipMonitorSummaryQuery();
        return this.sipMonitorQueryList(summary.getNotMonitored());
    }

    @Override
    public List<MonitoredEntity> sipMonitorQueryAll() {
        MonitorSummary summary = this.sipMonitorSummaryQuery();
        return this.sipMonitorQueryList(summary.getAll());
    }

    @Override
    public List<String> sipMonitorQueryAllEntityNamesOnly() {
        MonitorSummary summary = this.sipMonitorSummaryQuery();
        return summary.getAll();
    }

    @Override
    public List<MonitoredEntity> sipMonitorQueryList(List<String> entities) {
        ArrayList<MonitoredEntity> entityList = new ArrayList<MonitoredEntity>();
        for (String entityName : entities) {
            MonitoredEntity entity = this.retrieveMonitoredEntity(entityName);
            if (entity == null) continue;
            entityList.add(entity);
        }
        return entityList;
    }

    public List<String> sipMonitorLoadFactor(List<String> entities) {
        ArrayList<String> loadFactorList = new ArrayList<String>();
        for (String entityName : entities) {
            String entity = this.retrieveLoadFactor(entityName);
            if (entity == null) continue;
            loadFactorList.add(entity);
        }
        return loadFactorList;
    }

    @Override
    public String sipMonitorGetStatus(int max) {
        return "UP";
    }

    private MonitoredEntity retrieveMonitoredEntity(String entityName) {
        String[] payload = new String[]{"query entity", entityName};
        DataDistLayerMessage message = new DataDistLayerMessage(DataDistLayerMessage.TargetAppId.SIPMONITOR, 1, (Serializable)payload);
        Map<DataDistLayerMemberAddr, Object> responseMap = this.ddlMember.queryAllHosts(message);
        if (responseMap != null) {
            for (Object response : responseMap.values()) {
                if (!(response instanceof MonitoredEntity)) continue;
                return (MonitoredEntity)response;
            }
        }
        return null;
    }

    private String retrieveLoadFactor(String entityName) {
        String[] payload = new String[]{"query loadfactor", entityName};
        DataDistLayerMessage message = new DataDistLayerMessage(DataDistLayerMessage.TargetAppId.SIPMONITOR, 1, (Serializable)payload);
        Map<DataDistLayerMemberAddr, Object> responseMap = this.ddlMember.queryAllHosts(message);
        if (responseMap != null) {
            for (Object response : responseMap.values()) {
                if (!(response instanceof String)) continue;
                return (String)response;
            }
        }
        return null;
    }

    @Override
    public MonitorSummary sipMonitorSummaryQuery() {
        String[] payload = new String[]{"query summary"};
        DataDistLayerMessage message = new DataDistLayerMessage(DataDistLayerMessage.TargetAppId.SIPMONITOR, 1, (Serializable)payload);
        Map<DataDistLayerMemberAddr, Object> responseMap = this.ddlMember.queryAllHosts(message);
        if (responseMap != null) {
            for (Object response : responseMap.values()) {
                if (!(response instanceof MonitorSummary)) continue;
                return (MonitorSummary)response;
            }
        }
        return new MonitorSummary(null);
    }

    @Override
    public String demandTest(String entityName) {
        String[] payload = new String[]{"demand test", entityName};
        DataDistLayerMessage message = new DataDistLayerMessage(DataDistLayerMessage.TargetAppId.SIPMONITOR, 1, (Serializable)payload);
        Map<DataDistLayerMemberAddr, Object> responseMap = this.ddlMember.queryAllHosts(message);
        if (responseMap == null) {
            return "No response";
        }
        for (Object response : responseMap.values()) {
            if (!(response instanceof String)) continue;
            return (String)response;
        }
        return "No valid response";
    }

    @Override
    public CallRoutingTestResult doTestCall(CallRoutingTestInput callRoutingTestInput) {
        List<DataDistLayerMemberAddr> clusterMembers = this.ddlMember.getMembers();
        DataDistLayerMessage ddlMessage = new DataDistLayerMessage(DataDistLayerMessage.TargetAppId.ASM_CALL_PROC_SERVLET, 0, callRoutingTestInput);
        CallRoutingTestResult result = null;
        for (DataDistLayerMemberAddr hostId : clusterMembers) {
            result = (CallRoutingTestResult)this.ddlMember.queryHost(hostId, ddlMessage);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

