/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.objectapi;

import com.avaya.asm.core.AsmConstants;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DigitPattern {
    private final short min;
    private final short max;
    private final byte[] digits;
    private byte[] width = null;
    private final boolean isRange;

    public DigitPattern(short min, short max, String digits) {
        if (digits == null) {
            this.digits = null;
            this.min = 0;
            this.max = 0;
            this.isRange = false;
        } else {
            this.digits = digits.getBytes(AsmConstants.CHARSET);
            short length = (short)digits.indexOf(58);
            if (length == -1 || 2 * length + 1 != digits.length()) {
                this.min = min;
                this.max = max;
                this.isRange = false;
            } else {
                this.min = length;
                this.max = length;
                this.isRange = true;
            }
        }
    }

    public DigitPattern(short length, String digits) {
        this(length, length, digits);
    }

    public short getMin() {
        return this.min;
    }

    public short getMax() {
        return this.max;
    }

    public String getDigits() {
        return this.digits == null ? null : new String(this.digits, AsmConstants.CHARSET);
    }

    public boolean isRange() {
        return this.isRange;
    }

    public byte[] getWidth() {
        if (this.width == null) {
            if (!this.isRange) {
                int i;
                StringBuilder s = new StringBuilder("1");
                for (i = this.min; i < this.max; ++i) {
                    s.append("1");
                }
                for (i = this.digits.length; i < this.min; ++i) {
                    s.append("0");
                }
                for (i = 1; i < this.digits.length; ++i) {
                    if (this.digits[i] != 120 && this.digits[i] != 88) continue;
                    s.append("0");
                }
                BigInteger widthInt = new BigInteger(s.toString());
                if (this.digits[0] == 120 || this.digits[0] == 88) {
                    widthInt = widthInt.multiply(BigInteger.valueOf(12L));
                }
                this.width = widthInt.toByteArray();
            } else {
                int offset = this.digits[0] == 43 ? 1 : 0;
                int length = (this.digits.length - 1) / 2 - offset;
                BigInteger fromInt = new BigInteger(new String(this.digits, offset, length, AsmConstants.CHARSET));
                BigInteger widthInt = new BigInteger(new String(this.digits, offset * 2 + length + 1, length, AsmConstants.CHARSET));
                widthInt = widthInt.subtract(fromInt);
                widthInt = widthInt.add(BigInteger.valueOf(1L));
                this.width = widthInt.toByteArray();
            }
        }
        return this.width;
    }

    public int compareWidth(DigitPattern otherPattern) {
        int len;
        int diff;
        if (this.width == null) {
            this.getWidth();
        }
        if (otherPattern.width == null) {
            otherPattern.getWidth();
        }
        if ((diff = (len = this.width.length) - otherPattern.width.length) != 0) {
            return diff;
        }
        for (int i = 0; i < len; ++i) {
            diff = (this.width[i] & 0xFF) - (otherPattern.width[i] & 0xFF);
            if (diff == 0) continue;
            return diff;
        }
        return 0;
    }

    public List<DigitPattern> getSubPatterns() {
        ArrayList<DigitPattern> patterns = new ArrayList<DigitPattern>();
        if (this.isRange) {
            int diffIndex;
            int length = (this.digits.length - 1) / 2;
            String from = new String(this.digits, 0, length, AsmConstants.CHARSET);
            String to = new String(this.digits, length + 1, length, AsmConstants.CHARSET);
            for (diffIndex = 0; diffIndex < length && this.digits[diffIndex] == this.digits[diffIndex + length + 1]; ++diffIndex) {
            }
            this.expand(patterns, from, to, from.substring(0, diffIndex));
        } else {
            patterns.add(this);
        }
        return patterns;
    }

    private void expand(List<DigitPattern> patterns, String from, String to, String pattern) {
        short length = (short)from.length();
        if (length == pattern.length() || this.contains(from, to, pattern)) {
            DigitPattern subpattern = new DigitPattern(length, pattern);
            patterns.add(subpattern);
            return;
        }
        int lowDigit = from.startsWith(pattern) ? from.charAt(pattern.length()) - 48 : 0;
        int highDigit = to.startsWith(pattern) ? to.charAt(pattern.length()) - 48 : 9;
        for (int digit = lowDigit; digit <= highDigit; ++digit) {
            this.expand(patterns, from, to, pattern + digit);
        }
    }

    public boolean contains(String from, String to, String pattern) {
        int patternLength = pattern.length();
        int compare = pattern.compareTo(from.substring(0, patternLength));
        if (compare < 0) {
            return false;
        }
        if (compare == 0 && !from.substring(patternLength).matches("^0*$")) {
            return false;
        }
        compare = pattern.compareTo(to.substring(0, patternLength));
        if (compare > 0) {
            return false;
        }
        return compare != 0 || to.substring(patternLength).matches("^9*$");
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DigitPattern)) {
            return false;
        }
        DigitPattern other = (DigitPattern)object;
        if (this.digits.length != other.digits.length) {
            return false;
        }
        for (int i = 0; i < this.digits.length; ++i) {
            if (this.digits[i] == other.digits[i]) continue;
            return false;
        }
        return this.min == other.min && this.max == other.max;
    }

    public int hashCode() {
        int hash = 23;
        hash = hash * 37 + Arrays.hashCode(this.digits);
        hash = hash * 37 + this.min;
        hash = hash * 37 + this.max;
        return hash *= 37;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("\"");
        builder.append(new String(this.digits, AsmConstants.CHARSET));
        builder.append("\"");
        if (!this.isRange()) {
            if (this.min == this.max) {
                if (this.min > this.digits.length) {
                    builder.append(" (");
                    builder.append(this.min);
                    builder.append(" digits)");
                }
            } else {
                builder.append(" (");
                builder.append(this.min);
                builder.append("-");
                builder.append(this.max);
                builder.append(" digits)");
            }
        }
        return builder.toString();
    }
}

