/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.objectapi;

import com.avaya.asm.datamgr.objectapi.IPAddress;
import java.io.Serializable;

public class ListenPort
implements Serializable {
    private static final long serialVersionUID = -1051828784936191045L;
    private final long id;
    private final Long sipEntityId;
    private final int portNumber;
    private final String transportProtocol;
    private final Long sipDomainId;
    private final boolean endpoint;
    private IPAddrFamilyType ipAddrFamily;

    public ListenPort(long id, Long sipEntityId, int portNumber, String transportProtocol, Long sipDomainId, boolean endpoint, String ipaddr_family) {
        this.id = id;
        this.sipEntityId = sipEntityId;
        this.portNumber = portNumber;
        this.transportProtocol = transportProtocol;
        this.sipDomainId = sipDomainId == 0L ? null : sipDomainId;
        this.endpoint = endpoint;
        this.setIPAddrFamilyType(ipaddr_family);
    }

    public ListenPort(long id, Long sipEntityId, int portNumber, String transportProtocol, Long sipDomainId, boolean endpoint) {
        this.id = id;
        this.sipEntityId = sipEntityId;
        this.portNumber = portNumber;
        this.transportProtocol = transportProtocol;
        this.sipDomainId = sipDomainId == 0L ? null : sipDomainId;
        this.endpoint = endpoint;
        this.setIPAddrFamilyType(IPAddrFamilyType.IPv4.toString());
    }

    public ListenPort(long id, Long sipEntityId, int portNumber, String transportProtocol, Long sipDomainId) {
        this(id, sipEntityId, portNumber, transportProtocol, sipDomainId, true, IPAddrFamilyType.IPv4.toString());
    }

    public long getId() {
        return this.id;
    }

    public Long getSipEntityId() {
        return this.sipEntityId;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public String getTransportProtocol() {
        return this.transportProtocol;
    }

    public Long getSipDomainId() {
        return this.sipDomainId;
    }

    public boolean getEndpoint() {
        return this.endpoint;
    }

    public IPAddrFamilyType getIPAddrFamily() {
        return this.ipAddrFamily;
    }

    private void setIPAddrFamilyType(String ipaddr_family) {
        try {
            this.ipAddrFamily = IPAddrFamilyType.valueOf(ipaddr_family);
        }
        catch (Exception e) {
            this.ipAddrFamily = IPAddrFamilyType.IPv4;
        }
    }

    public boolean matches(Integer portNumber, String transportProtocol, IPAddress.IPAddressFamily ipAddressFamily, Boolean endpoint) {
        if (portNumber != null && portNumber != this.portNumber) {
            return false;
        }
        if (transportProtocol != null && !transportProtocol.equalsIgnoreCase(this.transportProtocol)) {
            return false;
        }
        if (ipAddressFamily != null && !this.appliesForAddressFamily(ipAddressFamily)) {
            return false;
        }
        return endpoint == null || endpoint == this.endpoint;
    }

    public boolean appliesForAddressFamily(IPAddress.IPAddressFamily ipAddressFamily) {
        if (this.ipAddrFamily == IPAddrFamilyType.IPv46) {
            return true;
        }
        if (this.ipAddrFamily == IPAddrFamilyType.IPv4 && ipAddressFamily == IPAddress.IPAddressFamily.IPV4) {
            return true;
        }
        return this.ipAddrFamily == IPAddrFamilyType.IPv6 && ipAddressFamily == IPAddress.IPAddressFamily.IPV6;
    }

    public String toString() {
        return "ListenPort[" + this.portNumber + "/" + (Object)((Object)this.ipAddrFamily) + "/" + this.transportProtocol + " domain=" + this.sipDomainId + " endpoint=" + this.endpoint + "]";
    }

    public static enum IPAddrFamilyType {
        IPv4,
        IPv6,
        IPv46;

    }
}

