/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.objectapi;

import com.avaya.asm.datamgr.objectapi.DigitPattern;
import java.util.List;

public class OriginationDigitPatternRow {
    private long id;
    private final DigitPattern digitPattern;
    private final Long sipDomainId;
    private final Long origPatternSetId;

    public OriginationDigitPatternRow(long id, short min, short max, String digits, Long sipDomainId, Long origPatternSetId) {
        this.id = id;
        this.digitPattern = new DigitPattern(min, max, digits);
        this.sipDomainId = sipDomainId;
        this.origPatternSetId = origPatternSetId;
    }

    public OriginationDigitPatternRow(short length, String digits, OriginationDigitPatternRow row) {
        this(row.getId(), length, length, digits, row.getSipDomainId(), row.origPatternSetId);
    }

    public long getId() {
        return this.id;
    }

    public DigitPattern getDigitPattern() {
        return this.digitPattern;
    }

    public Long getSipDomainId() {
        return this.sipDomainId;
    }

    public Long getOrigPatternSetId() {
        return this.origPatternSetId;
    }

    public boolean isRange() {
        return this.digitPattern.isRange();
    }

    public List<DigitPattern> getDigitPatterns() {
        return this.digitPattern.getSubPatterns();
    }

    public int compareWidth(OriginationDigitPatternRow other) {
        return this.digitPattern.compareWidth(other.digitPattern);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof OriginationDigitPatternRow)) {
            return false;
        }
        OriginationDigitPatternRow other = (OriginationDigitPatternRow)object;
        if (!this.digitPattern.equals(other.digitPattern)) {
            return false;
        }
        if (this.sipDomainId != null && !this.sipDomainId.equals(other.sipDomainId) || this.sipDomainId == null && other.sipDomainId != null) {
            return false;
        }
        return (this.origPatternSetId == null || this.origPatternSetId.equals(other.origPatternSetId)) && (this.origPatternSetId != null || other.origPatternSetId == null);
    }

    public int hashCode() {
        int hash = 23;
        hash = hash * 37 + this.digitPattern.hashCode();
        hash = hash * 37 + (this.sipDomainId == null ? 0 : (int)(this.sipDomainId ^ this.sipDomainId >>> 32));
        hash = hash * 37 + (this.origPatternSetId == null ? 0 : (int)(this.origPatternSetId ^ this.origPatternSetId >>> 32));
        return hash;
    }

    public String toString() {
        return "OriginationDigitPatternRow[id=" + this.getId() + ": " + this.digitPattern + " dom=" + this.getSipDomainId() + " oset=" + this.origPatternSetId + "]";
    }
}

