/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.ondemand;

import com.avaya.asm.datamgr.objectapi.CsHandle;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CsHandleDAO_cache {
    private Map<Long, CsHandle> handleByIdMap = new HashMap<Long, CsHandle>();
    private Map<Long, Map<String, CsHandle>> handleMap = new HashMap<Long, Map<String, CsHandle>>();
    private Map<Long, Set<CsHandle>> commProfileSetMap = new HashMap<Long, Set<CsHandle>>();

    public boolean existsHandleByHandleDomain(String handle, long domainId) {
        if (!this.handleMap.containsKey(domainId)) {
            return false;
        }
        Map<String, CsHandle> map = this.handleMap.get(domainId);
        return map.containsKey(handle);
    }

    public boolean existsHandleById(Long csHandleId) {
        return this.handleByIdMap.containsKey(csHandleId);
    }

    public boolean existsHandleByCommProfileSetId(long csCommProfSetId) {
        return this.commProfileSetMap.containsKey(csCommProfSetId);
    }

    public CsHandle getHandleByHandleDomain(String handle, long domainId) {
        Map<String, CsHandle> map = this.handleMap.get(domainId);
        if (map != null) {
            return map.get(handle);
        }
        return null;
    }

    public CsHandle getHandleById(Long csHandleId) {
        return this.handleByIdMap.get(csHandleId);
    }

    public Set<CsHandle> getHandlesByCommProfileSetId(long csCommProfSetId) {
        if (this.existsHandleByCommProfileSetId(csCommProfSetId)) {
            return this.commProfileSetMap.get(csCommProfSetId);
        }
        return new HashSet<CsHandle>();
    }

    public void addHandle(CsHandle handle) {
        this.addHandleByHandleDomain(handle.getHandle(), handle.getCsDomainId(), handle);
        this.addHandleById(handle.getId(), handle);
        this.addHandleByCommProfileSetId(handle.getCsCommProfileSetId(), handle);
    }

    public void addHandleByHandleDomain(String handle, long domainId, CsHandle csHandle) {
        Map<String, CsHandle> map = this.handleMap.get(domainId);
        if (map == null) {
            map = new HashMap<String, CsHandle>();
        }
        map.put(handle, csHandle);
        this.handleMap.put(domainId, map);
    }

    public void addHandleById(Long csHandleId, CsHandle csHandle) {
        if (csHandleId != null) {
            this.handleByIdMap.put(csHandleId, csHandle);
        }
    }

    public void addHandleByCommProfileSetId(long csCommProfSetId, CsHandle handle) {
        Set<CsHandle> set = this.existsHandleByCommProfileSetId(csCommProfSetId) ? this.getHandlesByCommProfileSetId(csCommProfSetId) : new HashSet<CsHandle>();
        set.add(handle);
        this.commProfileSetMap.put(csCommProfSetId, set);
    }

    public void addHandlesByCommProfileSetId(long csCommProfSetId, Set<CsHandle> handles) {
        if (this.existsHandleByCommProfileSetId(csCommProfSetId)) {
            Set<CsHandle> set = this.getHandlesByCommProfileSetId(csCommProfSetId);
            for (CsHandle handle : handles) {
                set.add(handle);
            }
            this.commProfileSetMap.put(csCommProfSetId, set);
        } else {
            this.commProfileSetMap.put(csCommProfSetId, handles);
        }
    }

    public void clearAll() {
        this.handleByIdMap.clear();
        this.handleMap.clear();
        this.commProfileSetMap.clear();
    }
}

