/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.jni;

import com.avaya.asm.core.AsmLogger;
import com.avaya.common.logging.client.Logger;

public class OperatingSystemMXBean {
    private static final Logger log = AsmLogger.getLogger(OperatingSystemMXBean.class);
    private static int _SC_NPROCESSORS_ONLN;

    private native void sysinfo(SysInfo var1) throws ErrnoException;

    private native long sysconf(int var1) throws ErrnoException;

    private static native int _SC_NPROCESSORS_ONLN();

    public Long getTotalPhysicalMemorySize() {
        String fcn_name = "getTotalPhysicalMemorySize";
        SysInfo sysInfo = new SysInfo();
        Long fcn_rc = null;
        try {
            this.sysinfo(sysInfo);
            fcn_rc = sysInfo.totalram;
        }
        catch (ErrnoException e) {
            int errno = e.getErrno();
            String msg = e.getMessage();
            log.error((Object)("getTotalPhysicalMemorySize: sysinfo() failed, errno=" + errno + ", message=" + msg));
        }
        return fcn_rc;
    }

    public Long getFreePhysicalMemorySize() {
        String fcn_name = "getFreePhysicalMemorySize";
        SysInfo sysInfo = new SysInfo();
        Long fcn_rc = null;
        try {
            this.sysinfo(sysInfo);
            fcn_rc = sysInfo.freeram;
        }
        catch (ErrnoException e) {
            int errno = e.getErrno();
            String msg = e.getMessage();
            log.error((Object)("getFreePhysicalMemorySize: sysinfo() failed, errno=" + errno + ", message=" + msg));
        }
        return fcn_rc;
    }

    public Long getSharedMemorySize() {
        String fcn_name = "getSharedMemorySize";
        SysInfo sysInfo = new SysInfo();
        Long fcn_rc = null;
        try {
            this.sysinfo(sysInfo);
            fcn_rc = sysInfo.sharedram;
        }
        catch (ErrnoException e) {
            int errno = e.getErrno();
            String msg = e.getMessage();
            log.error((Object)("getSharedMemorySize: sysinfo() failed, errno=" + errno + ", message=" + msg));
        }
        return fcn_rc;
    }

    public Long getBufferMemorySize() {
        String fcn_name = "getBufferMemorySize";
        SysInfo sysInfo = new SysInfo();
        Long fcn_rc = null;
        try {
            this.sysinfo(sysInfo);
            fcn_rc = sysInfo.bufferram;
        }
        catch (ErrnoException e) {
            int errno = e.getErrno();
            String msg = e.getMessage();
            log.error((Object)("getBufferMemorySize: sysinfo() failed, errno=" + errno + ", message=" + msg));
        }
        return fcn_rc;
    }

    public Long getTotalSwapSpaceSize() {
        String fcn_name = "getTotalSwapSpaceSize";
        SysInfo sysInfo = new SysInfo();
        Long fcn_rc = null;
        try {
            this.sysinfo(sysInfo);
            fcn_rc = sysInfo.totalswap;
        }
        catch (ErrnoException e) {
            int errno = e.getErrno();
            String msg = e.getMessage();
            log.error((Object)("getTotalSwapSpaceSize: sysinfo() failed, errno=" + errno + ", message=" + msg));
        }
        return fcn_rc;
    }

    public Long getFreeSwapSpaceSize() {
        String fcn_name = "getFreeSwapSpaceSize";
        SysInfo sysInfo = new SysInfo();
        Long fcn_rc = null;
        try {
            this.sysinfo(sysInfo);
            fcn_rc = sysInfo.freeswap;
        }
        catch (ErrnoException e) {
            int errno = e.getErrno();
            String msg = e.getMessage();
            log.error((Object)("getFreeSwapSpaceSize: sysinfo() failed, errno=" + errno + ", message=" + msg));
        }
        return fcn_rc;
    }

    public Long getUptime() {
        String fcn_name = "getUptime";
        SysInfo sysInfo = new SysInfo();
        Long fcn_rc = null;
        try {
            this.sysinfo(sysInfo);
            fcn_rc = sysInfo.uptime;
        }
        catch (ErrnoException e) {
            int errno = e.getErrno();
            String msg = e.getMessage();
            log.error((Object)("getUptime: sysinfo() failed, errno=" + errno + ", message=" + msg));
        }
        return fcn_rc;
    }

    public long[] getLoads() {
        String fcn_name = "getLoads";
        SysInfo sysInfo = new SysInfo();
        long[] fcn_rc = null;
        try {
            this.sysinfo(sysInfo);
            fcn_rc = sysInfo.loads;
        }
        catch (ErrnoException e) {
            int errno = e.getErrno();
            String msg = e.getMessage();
            log.error((Object)("getLoads: sysinfo() failed, errno=" + errno + ", message=" + msg));
        }
        return fcn_rc;
    }

    public Short getNumProcesses() {
        String fcn_name = "getNumProcesses";
        SysInfo sysInfo = new SysInfo();
        Short fcn_rc = null;
        try {
            this.sysinfo(sysInfo);
            fcn_rc = sysInfo.procs;
        }
        catch (ErrnoException e) {
            int errno = e.getErrno();
            String msg = e.getMessage();
            log.error((Object)("getNumProcesses: sysinfo() failed, errno=" + errno + ", message=" + msg));
        }
        return fcn_rc;
    }

    public Integer getAvailableProcessors() {
        String fcn_name = "getAvailableProcessors";
        Integer numAvailableProcessors = null;
        try {
            numAvailableProcessors = (int)this.sysconf(_SC_NPROCESSORS_ONLN);
        }
        catch (ErrnoException e) {
            int errno = e.getErrno();
            String msg = e.getMessage();
            log.error((Object)("getAvailableProcessors: sysconf(_SC_NPROCESSORS_ONLN) failed, errno=" + errno + ", message=" + msg));
        }
        return numAvailableProcessors;
    }

    static {
        System.loadLibrary("JniExec");
        _SC_NPROCESSORS_ONLN = OperatingSystemMXBean._SC_NPROCESSORS_ONLN();
    }

    private class ErrnoException
    extends Exception {
        private static final long serialVersionUID = -1474981368145915159L;
        private int errno;

        public ErrnoException(int errno, String msg) {
            super(msg);
            this.errno = errno;
        }

        public int getErrno() {
            return this.errno;
        }
    }

    private class SysInfo {
        long uptime = 1L;
        long[] loads;
        long totalram;
        long freeram;
        long sharedram;
        long bufferram;
        long totalswap;
        long freeswap;
        short procs;

        private SysInfo() {
        }
    }
}

