/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.ppm.mega.model;

import com.avaya.asm.ppm.mega.common.MegaPPMUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.ArrayList;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DeviceDataIdentityFields {
    private String vendor;
    private String model;
    private String timestamp;
    @JsonIgnore
    private Long timestampAsEpochMS;
    private ArrayList<DeviceSetting> configurations = null;

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
        this.timestampAsEpochMS = MegaPPMUtils.posixTimeToEpochMS(timestamp);
    }

    public Long getTimestampAsEpochMS() {
        return this.timestampAsEpochMS;
    }

    public void setTimestampAsEpochMS(Long timestampAsEpochMS) {
        this.timestampAsEpochMS = timestampAsEpochMS;
        this.timestamp = MegaPPMUtils.epochTimestampToPosix(timestampAsEpochMS);
    }

    public ArrayList<DeviceSetting> getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(ArrayList<DeviceSetting> configurations) {
        this.configurations = configurations;
    }

    public String toString() {
        return "DeviceDataIdentityFields [vendor=" + this.vendor + ", model=" + this.model + ", timestamp=" + this.timestamp + ", timeStampAsEpochMS=" + this.timestampAsEpochMS + ", configuration=" + this.configurations + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.configurations == null ? 0 : this.configurations.hashCode());
        result = 31 * result + (this.model == null ? 0 : this.model.hashCode());
        result = 31 * result + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        result = 31 * result + (int)(this.timestampAsEpochMS ^ this.timestampAsEpochMS >>> 32);
        result = 31 * result + (this.vendor == null ? 0 : this.vendor.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeviceDataIdentityFields other = (DeviceDataIdentityFields)obj;
        if (this.configurations == null ? other.configurations != null : !this.configurations.equals(other.configurations)) {
            return false;
        }
        if (this.model == null ? other.model != null : !this.model.equals(other.model)) {
            return false;
        }
        if (this.timestamp == null ? other.timestamp != null : !this.timestamp.equals(other.timestamp)) {
            return false;
        }
        if (this.timestampAsEpochMS != other.timestampAsEpochMS) {
            return false;
        }
        return !(this.vendor == null ? other.vendor != null : !this.vendor.equals(other.vendor));
    }

    public static class DeviceSetting {
        private String name;
        private String value;
        private ArrayList<VendorModelTag> vendorModelTag = null;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value == null ? "" : value;
        }

        public ArrayList<VendorModelTag> getVendorModelTag() {
            return this.vendorModelTag;
        }

        public void setVendorModelTag(ArrayList<VendorModelTag> vendorModelTag) {
            this.vendorModelTag = vendorModelTag;
        }

        public String toString() {
            return "DeviceSetting [name=" + this.name + ", value=" + this.value + ", vendorModelTag=" + this.vendorModelTag + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            result = 31 * result + (this.vendorModelTag == null ? 0 : this.vendorModelTag.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DeviceSetting other = (DeviceSetting)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
                return false;
            }
            return !(this.vendorModelTag == null ? other.vendorModelTag != null : !this.vendorModelTag.equals(other.vendorModelTag));
        }
    }

    public static class VendorModelTag {
        private String tag;

        public String getTag() {
            return this.tag;
        }

        public void setTag(String tag) {
            this.tag = tag;
        }

        public String toString() {
            return "VendorModelTag [tag=" + this.tag + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.tag == null ? 0 : this.tag.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            VendorModelTag other = (VendorModelTag)obj;
            return !(this.tag == null ? other.tag != null : !this.tag.equals(other.tag));
        }
    }
}

