/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.trustmgmt;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.trustmgmt.IBMTrustMgmtUtil;
import com.avaya.common.logging.client.Logger;
import javax.net.ssl.SSLContext;

public class PushTrustMgmtUtil
extends IBMTrustMgmtUtil {
    private static Logger log = AsmLogger.getLogger(PushTrustMgmtUtil.class);
    private static volatile PushTrustMgmtUtil instance = null;
    protected static final String IBM_SYSTEM_PARAM_ENABLE_CRLDP = "com.ibm.security.enableCRLDP";
    protected static final String SYSTEM_PARAM_ASM_PUSH_HOSTNAME_VERIFIER = "com.avaya.asm.trustmgmt.pushHostnameVerifier";

    private PushTrustMgmtUtil() {
        String functionName = "PushTrustMgmtUtil";
        boolean isFinerEnabled = log.isFinerEnabled();
        String hostnameVerifier = System.getProperty(SYSTEM_PARAM_ASM_PUSH_HOSTNAME_VERIFIER, "DEFAULT");
        this.setHostnameVerifier(hostnameVerifier);
        if (isFinerEnabled) {
            log.finer((Object)"PushTrustMgmtUtil: leave. instantiated.");
        }
    }

    public static synchronized PushTrustMgmtUtil getInstance() {
        if (instance == null) {
            instance = new PushTrustMgmtUtil();
        }
        return instance;
    }

    @Override
    protected void initSystemParameters() {
        String functionName = "initSystemParameters";
        boolean isFinerEnabled = log.isFinerEnabled();
        if (isFinerEnabled) {
            log.finer((Object)"initSystemParameters: entered.");
        }
        super.initSystemParameters();
        String enableCRLDP = System.getProperty("com.sun.security.enableCRLDP", "true");
        if (enableCRLDP != null) {
            this.setSystemProperty(IBM_SYSTEM_PARAM_ENABLE_CRLDP, enableCRLDP);
        }
        if (isFinerEnabled) {
            log.finer((Object)"initSystemParameters: leave.");
        }
    }

    @Override
    public SSLContext getSSLContext() {
        boolean useRevocationAwareSSLContext = true;
        return this.createSSLContext(true);
    }

    @Override
    public String getSecuritySystemParametersAsString() {
        return this.getSystemParameterAsString(IBM_SYSTEM_PARAM_ENABLE_CRLDP) + ", " + super.getSecuritySystemParametersAsString();
    }
}

