/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.trustmgmt;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.WaitStatus;
import com.avaya.asm.trustmgmt.AsmHostnameVerifier;
import com.avaya.asm.trustmgmt.TrustKeyManagerFactorySupplier;
import com.avaya.common.logging.client.Logger;
import com.avaya.ustore.CassandraSSLOptions;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;

public class TrustMgmtUtil {
    private static Logger log = AsmLogger.getLogger(TrustMgmtUtil.class);
    protected static final String SYSTEM_PARAM_KEY_MANAGER_FACTORY_ALGORITHM = "ssl.KeyManagerFactory.algorithm";
    protected static final String SYSTEM_PARAM_KEY_STORE = "javax.net.ssl.keyStore";
    protected static final String SYSTEM_PARAM_KEY_STORE_PASSWORD = "javax.net.ssl.keyStorePassword";
    protected static final String SYSTEM_PARAM_KEY_STORE_PROVIDER = "javax.net.ssl.keyStoreProvider";
    protected static final String SYSTEM_PARAM_KEY_STORE_TYPE = "javax.net.ssl.keyStoreType";
    protected static final String SYSTEM_PARAM_TRUST_MANAGER_FACTORY_ALGORITHM = "ssl.TrustManagerFactory.algorithm";
    protected static final String SYSTEM_PARAM_TRUST_STORE = "javax.net.ssl.trustStore";
    protected static final String SYSTEM_PARAM_TRUST_STORE_PASSWORD = "javax.net.ssl.trustStorePassword";
    protected static final String SYSTEM_PARAM_TRUST_STORE_PROVIDER = "javax.net.ssl.trustStoreProvider";
    protected static final String SYSTEM_PARAM_TRUST_STORE_TYPE = "javax.net.ssl.trustStoreType";
    protected static final String SYSTEM_PARAM_TLS_EPHEMERAL_DH_KEY_SIZE = "jdk.tls.ephemeralDHKeySize";
    protected static final String SYSTEM_PARAM_PREFER_IPV4_STACK = "java.net.preferIPv4Stack";
    protected static final String SYSTEM_PARAM_TLS_CLIENT_PROTOCOLS = "jdk.tls.client.protocols";
    protected static final String SYSTEM_PARAM_TLS_SERVER_PROTOCOLS = "jdk.tls.server.protocols";
    protected static final String SYSTEM_PARAM_TLS_CLIENT_CIPHER_SUITES = "jdk.tls.client.cipherSuites";
    protected static final String SYSTEM_PARAM_TLS_SERVER_CIPHER_SUITES = "jdk.tls.server.cipherSuites";
    protected static final String SUN_SYSTEM_PARAM_ENABLE_CRLDP = "com.sun.security.enableCRLDP";
    protected static final String SUN_SYSTEM_PARAM_CHECK_REVOCATION = "com.sun.net.ssl.checkRevocation";
    protected static final String SYSTEM_PARAM_TRUST_KEY_MANAGER_FACTORY_SUPPLIER = "com.avaya.mgmt.trust.TrustKeyManagerFactorySupplier";
    protected static final String SYSTEM_PARAM_TLS_VERSION = "com.avaya.asm.trustmgmt.tlsVersion";
    protected static final String DEFAULT_TLS_EPHEMERAL_DH_KEY_SIZE = "2048";
    protected static final String DEFAULT_ENABLE_CRLDP = "true";
    protected static final String DEFAULT_TLS_VERSION = "TLSv1.2";
    protected static final String SYSTEM_PARAM_JAVAX_NET_DEBUG = "javax.net.debug";
    protected static final String SYSTEM_PARAM_JAVA_SECURITY_DEBUG = "java.security.debug";
    protected static final String SYSTEM_PARAM_ASM_TM_HOSTNAME_VERIFIER = "com.avaya.asm.trustmgmt.tmHostnameVerifier";
    private static final String idFile = "/proc/sys/kernel/random/boot_id";
    private static final String GETKEY_COMMAND = "/usr/bin/sudo /opt/Avaya/Session_Manager/bin/TMClient.sh getKey";
    private static volatile TrustMgmtUtil instance = null;
    protected String sslContextProvider = null;
    protected String tlsVersion = System.getProperty("com.avaya.asm.trustmgmt.tlsVersion", "TLSv1.2");
    protected String hostnameVerifier = null;

    protected TrustMgmtUtil() {
        String functionName = "TrustMgmtUtil";
        boolean isFinerEnabled = log.isFinerEnabled();
        this.initSystemParameters();
        String hostnameVerifier = System.getProperty(SYSTEM_PARAM_ASM_TM_HOSTNAME_VERIFIER, "DEFAULT");
        this.setHostnameVerifier(hostnameVerifier);
        if (isFinerEnabled) {
            log.finer((Object)"TrustMgmtUtil: leave. instantiated. ");
        }
    }

    public static synchronized TrustMgmtUtil getInstance() {
        if (instance == null) {
            instance = new TrustMgmtUtil();
        }
        return instance;
    }

    protected void initSystemParameters() {
        String functionName = "initSystemParameters";
        boolean isFinerEnabled = log.isFinerEnabled();
        if (isFinerEnabled) {
            log.finer((Object)"initSystemParameters: entered.");
        }
        this.setSystemPropertyIfNull(SYSTEM_PARAM_TLS_EPHEMERAL_DH_KEY_SIZE, DEFAULT_TLS_EPHEMERAL_DH_KEY_SIZE);
        this.setSystemPropertyIfNull(SUN_SYSTEM_PARAM_ENABLE_CRLDP, DEFAULT_ENABLE_CRLDP);
        if (isFinerEnabled) {
            log.finer((Object)"initSystemParameters: leave.");
        }
    }

    protected String getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    protected void setHostnameVerifier(String hostnameVerifier) {
        String functionName = "setHostnameVerifier";
        boolean isFinerEnabled = log.isFinerEnabled();
        boolean validVerifier = true;
        if (hostnameVerifier.equalsIgnoreCase("ASM")) {
            HttpsURLConnection.setDefaultHostnameVerifier(new AsmHostnameVerifier());
        } else if (hostnameVerifier.equalsIgnoreCase("NONE")) {
            this.hostnameVerifier = hostnameVerifier;
            HostnameVerifier allHostsValid = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    log.info((Object)("allHostValid HostnameVerifier called. hostname=" + hostname));
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
        } else if (!hostnameVerifier.equalsIgnoreCase("DEFAULT")) {
            validVerifier = false;
        }
        if (validVerifier) {
            this.hostnameVerifier = hostnameVerifier;
        } else {
            log.error((Object)("setHostnameVerifier: Ignored unsupported hostnameVerifier=" + hostnameVerifier));
        }
        if (isFinerEnabled) {
            log.finer((Object)("setHostnameVerifier: hostnameVerifier=" + this.getHostnameVerifier()));
        }
    }

    public Cipher getCipher() throws NoSuchAlgorithmException, NoSuchPaddingException {
        Cipher result = Cipher.getInstance("AES/CBC/PKCS5Padding", (Provider)new BouncyCastleFipsProvider());
        return result;
    }

    public byte[] crypto(byte[] ksPassword, boolean isEncrypt) throws Exception {
        String functionName = "crypto";
        boolean isFinerEnabled = log.isFinerEnabled();
        File bootId = new File(idFile);
        String keyString = null;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(bootId));
            keyString = reader.readLine();
        }
        catch (Exception e) {
            System.err.println("crypto: Unable to find key file!");
            throw e;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (keyString == null) {
            throw new Exception("crypto: Unable to read key file!");
        }
        Mac sha256hmac = Mac.getInstance("HmacSHA256");
        SecretKeySpec secretKey = new SecretKeySpec(keyString.replace("-", "").getBytes("UTF-8"), "HmacSHA256");
        sha256hmac.init(secretKey);
        byte[] bootIdBytes = new byte[keyString.getBytes().length + 1];
        System.arraycopy(keyString.getBytes("UTF-8"), 0, bootIdBytes, 0, keyString.getBytes().length);
        bootIdBytes[keyString.getBytes().length] = 10;
        byte[] key = sha256hmac.doFinal(bootIdBytes);
        int len = bootIdBytes.length * 2;
        byte[] bootIdBytesForIV = new byte[len];
        System.arraycopy(bootIdBytes, 0, bootIdBytesForIV, 0, bootIdBytes.length);
        System.arraycopy(bootIdBytes, 0, bootIdBytesForIV, bootIdBytes.length, bootIdBytes.length);
        byte[] bootIdForIVHash = sha256hmac.doFinal(bootIdBytesForIV);
        byte[] iv = new byte[16];
        System.arraycopy(bootIdForIVHash, 0, iv, 0, iv.length);
        Cipher cipher = this.getCipher();
        SecretKeySpec keySpec = new SecretKeySpec(key, "AES");
        if (isEncrypt) {
            cipher.init(1, (Key)keySpec, new IvParameterSpec(iv));
        } else {
            cipher.init(2, (Key)keySpec, new IvParameterSpec(iv));
        }
        byte[] encryptedData = cipher.doFinal(ksPassword);
        if (isFinerEnabled) {
            log.finer((Object)("crypto: leave. returning encryptedData.length" + encryptedData.length + ", ksPassword.length=" + ksPassword.length + ", isEncrypt=" + isEncrypt));
        }
        return encryptedData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getStoreString() throws IOException, InterruptedException {
        String functionName = "getStoreString";
        boolean isFinerEnabled = log.isFinerEnabled();
        byte[] result = null;
        InputStream inputStream = null;
        Process process = null;
        process = Runtime.getRuntime().exec(GETKEY_COMMAND);
        try {
            inputStream = process.getInputStream();
            result = this.streamToByteArray(inputStream);
        }
        finally {
            inputStream.close();
        }
        int wStatus = process.waitFor();
        if (!WaitStatus.WIFEXITED(wStatus) || WaitStatus.WEXITSTATUS(wStatus) != 0) {
            String msg = "getStoreString: Command \"/usr/bin/sudo /opt/Avaya/Session_Manager/bin/TMClient.sh getKey\" did not execute properly, status=" + WaitStatus.asString(wStatus);
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        if (isFinerEnabled) {
            if (result != null) {
                log.finer((Object)("getStoreString: leave. result.length=" + result.length));
            } else {
                log.finer((Object)"getStoreString: leave .result=null");
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] streamToByteArray(InputStream stream) throws IOException {
        String functionName = "streamToByteArray";
        boolean isFinestEnabled = log.isFinestEnabled();
        try (ByteArrayOutputStream os = null;){
            byte[] buffer = new byte[1024];
            os = new ByteArrayOutputStream();
            int line = 0;
            while ((line = stream.read(buffer)) != -1) {
                os.write(buffer, 0, line);
            }
            os.flush();
        }
        if (isFinestEnabled) {
            log.finest((Object)("streamToByteArray: leave. os.size()=" + os.size()));
        }
        return os.toByteArray();
    }

    protected byte[] getStoragePassword() {
        String functionName = "getStoragePassword";
        boolean isFinerEnabled = log.isFinerEnabled();
        byte[] result = null;
        try {
            result = this.crypto(this.getStoreString(), false);
        }
        catch (IOException ioe) {
            log.error((Object)"getStoragePassword: crypto failed to access the file!", (Throwable)ioe);
        }
        catch (InterruptedException ie) {
            log.error((Object)"getStoragePassword: Interrupted while accessing the file!", (Throwable)ie);
        }
        catch (Exception e) {
            log.error((Object)"getStoragePassword: Exception while accessing the file!", (Throwable)e);
        }
        if (result == null) {
            log.error((Object)"getStoragePassword: leave. result=null");
        } else if (isFinerEnabled) {
            log.finer((Object)("getStoragePassword: leave. result.length=" + result.length));
        }
        return result;
    }

    protected String getStoragePasswordAsString() {
        String functionName = "getStoragePasswordAsString";
        boolean isFinerEnabled = log.isFinerEnabled();
        String result = null;
        byte[] decryptedData = this.getStoragePassword();
        if (decryptedData != null) {
            try {
                result = new String(decryptedData, "UTF-8").trim();
            }
            catch (UnsupportedEncodingException uee) {
                log.error((Object)"getStoragePasswordAsString: Cannot convert", (Throwable)uee);
            }
            for (int j = 0; j < decryptedData.length; ++j) {
                decryptedData[j] = 0;
            }
        }
        if (isFinerEnabled) {
            if (result != null) {
                log.finer((Object)("getStoragePasswordAsString: leave. result.length()=" + result.length()));
            } else {
                log.finer((Object)"getStoragePasswordAsString: leave. result=null");
            }
        }
        return result;
    }

    protected SSLContext getSSLContext() {
        boolean useRevocationAwareSSLContext = false;
        return this.createSSLContext(false);
    }

    public String getKeyManagerFactoryAlgorithm() {
        String result = System.getProperty(SYSTEM_PARAM_KEY_MANAGER_FACTORY_ALGORITHM, KeyManagerFactory.getDefaultAlgorithm());
        return result;
    }

    protected String getKeyStorePassword() {
        String result = System.getProperty(SYSTEM_PARAM_KEY_STORE_PASSWORD, this.getStoragePasswordAsString());
        return result;
    }

    public String getKeyStorePath() {
        String result = System.getProperty(SYSTEM_PARAM_KEY_STORE, null);
        return result;
    }

    public String getKeyStoreProvider() {
        String result = System.getProperty(SYSTEM_PARAM_KEY_STORE_PROVIDER, null);
        return result;
    }

    public String getKeyStoreType() {
        String result = System.getProperty(SYSTEM_PARAM_KEY_STORE_TYPE, KeyStore.getDefaultType());
        return result;
    }

    public void setTlsVersion(String tlsVersion) {
        this.tlsVersion = tlsVersion;
    }

    public String getTlsVersion() {
        return this.tlsVersion;
    }

    public String getTrustManagerFactoryAlgorithm() {
        String result = System.getProperty(SYSTEM_PARAM_TRUST_MANAGER_FACTORY_ALGORITHM, TrustManagerFactory.getDefaultAlgorithm());
        return result;
    }

    protected String getTrustStorePassword() {
        String result = System.getProperty(SYSTEM_PARAM_TRUST_STORE_PASSWORD, this.getStoragePasswordAsString());
        return result;
    }

    public String getTrustStorePath() {
        String result = System.getProperty(SYSTEM_PARAM_TRUST_STORE, null);
        return result;
    }

    public String getTrustStoreProvider() {
        String result = System.getProperty(SYSTEM_PARAM_TRUST_STORE_PROVIDER, null);
        return result;
    }

    public String getTrustStoreType() {
        String result = System.getProperty(SYSTEM_PARAM_TRUST_STORE_TYPE, KeyStore.getDefaultType());
        return result;
    }

    public String getSSLContextProvider() {
        return this.sslContextProvider;
    }

    public CassandraSSLOptions getSSLOptions() {
        boolean useRevocationAwareSSLContext = false;
        return this.getSSLOptions(false);
    }

    public CassandraSSLOptions getSSLOptions(boolean useRevocationAwareSSLContext) {
        String functionName = "getSSLOptions";
        boolean isFinerEnabled = log.isFinerEnabled();
        SSLContext sslContext = this.createSSLContext(useRevocationAwareSSLContext);
        CassandraSSLOptions sslOptions = null;
        if (sslContext != null) {
            SSLContext.setDefault(sslContext);
            sslOptions = new CassandraSSLOptions(sslContext);
            if (isFinerEnabled) {
                log.finer((Object)("getSSLOptions: leave. Created CassandraSSLOptions. useRevocationAwareSSLContext=" + useRevocationAwareSSLContext + ", sslOptions=" + sslOptions));
            }
        } else {
            log.error((Object)("getSSLOptions: leave. Could not Create CassandraSSLOptions. useRevocationAwareSSLContext=" + useRevocationAwareSSLContext));
        }
        return sslOptions;
    }

    public SSLContext createDefaultSSLContext() {
        SSLContext sslContext;
        String functionName = "createDefaultSSLContext";
        boolean isFinerEnabled = log.isFinerEnabled();
        if (isFinerEnabled) {
            log.finer((Object)"createDefaultSSLContext: entered.");
        }
        if ((sslContext = this.getSSLContext()) != null) {
            SSLContext.setDefault(sslContext);
            if (isFinerEnabled) {
                log.finer((Object)("createDefaultSSLContext: leave. Created Default SSLContext., sslContext=" + sslContext));
            }
        } else {
            log.error((Object)("createDefaultSSLContext: Error creating Default SSLContext. " + this.toString()));
        }
        return sslContext;
    }

    public SSLContext createDefaultSSLContext(boolean useRevocationAwareSSLContext) {
        SSLContext sslContext;
        String functionName = "createDefaultSSLContext";
        boolean isFinerEnabled = log.isFinerEnabled();
        if (isFinerEnabled) {
            log.finer((Object)("createDefaultSSLContext: entered. useRevocationAwareSSLContext=" + useRevocationAwareSSLContext));
        }
        if ((sslContext = this.createSSLContext(useRevocationAwareSSLContext)) != null) {
            SSLContext.setDefault(sslContext);
            if (isFinerEnabled) {
                log.finer((Object)("createDefaultSSLContext: leave. Created Default SSLContext. useRevocationAwareSSLContext=" + useRevocationAwareSSLContext + ", sslContext=" + sslContext));
            }
        } else {
            log.error((Object)("createDefaultSSLContext: leave. Error creating Default SSLContext. useRevocationAwareSSLContext=" + useRevocationAwareSSLContext));
        }
        return sslContext;
    }

    public SSLContext createDefaultSSLContext(String trustStorePath, String trustStoreType, String trustStoreProvider, String trustStorePassword, boolean useRevocationAwareSSLContext) {
        SSLContext sslContext;
        String functionName = "createDefaultSSLContext";
        boolean isFinerEnabled = log.isFinerEnabled();
        if (isFinerEnabled) {
            log.finer((Object)("createDefaultSSLContext: entered. trustStorePath=" + trustStorePath + ", trustStoreType=" + trustStoreType + ", trustStoreProvider=" + trustStoreProvider + ", useRevocationAwareSSLContext=" + useRevocationAwareSSLContext));
        }
        if ((sslContext = this.createSSLContext(trustStorePath, trustStoreType, trustStoreProvider, trustStorePassword, useRevocationAwareSSLContext)) != null) {
            SSLContext.setDefault(sslContext);
            if (isFinerEnabled) {
                log.finer((Object)("createDefaultSSLContext: leave. Created Default SSLContext. trustStorePath=" + trustStorePath + ", trustStoreType=" + trustStoreType + ", trustStoreProvider=" + trustStoreProvider + ", useRevocationAwareSSLContext=" + useRevocationAwareSSLContext + ", sslContext=" + sslContext));
            }
        } else {
            log.error((Object)("createDefaultSSLContext: leave. Error creating Default SSLContext. trustStorePath=" + trustStorePath + ", trustStoreType=" + trustStoreType + ", trustStoreProvider=" + trustStoreProvider + ", useRevocationAwareSSLContext=" + useRevocationAwareSSLContext));
        }
        return sslContext;
    }

    public SSLContext createDefaultSSLContext(String trustStorePath, String trustStoreType, String trustStoreProvider, String trustStorePassword, String keyStorePath, String keyStoreType, String keyStoreProvider, String keyStorePassword, boolean useRevocationAwareSSLContext) {
        SSLContext sslContext;
        String functionName = "createDefaultSSLContext";
        boolean isFinerEnabled = log.isFinerEnabled();
        if (isFinerEnabled) {
            log.finer((Object)("createDefaultSSLContext: entered. trustStorePath=" + trustStorePath + ", trustStoreType=" + trustStoreType + ", trustStoreProvider=" + trustStoreProvider + ", keyStorePath=" + keyStorePath + ", keyStoreType=" + keyStoreType + ", keyStoreProvider=" + keyStoreProvider + ", useRevocationAwareSSLContext=" + useRevocationAwareSSLContext));
        }
        if ((sslContext = this.createSSLContext(trustStorePath, trustStoreType, trustStoreProvider, trustStorePassword, keyStorePath, keyStoreType, keyStoreProvider, keyStorePassword, useRevocationAwareSSLContext)) != null) {
            SSLContext.setDefault(sslContext);
            if (isFinerEnabled) {
                log.finer((Object)("createDefaultSSLContext: leave. Created Default SSLContext. trustStorePath=" + trustStorePath + ", trustStoreType=" + trustStoreType + ", trustStoreProvider=" + trustStoreProvider + ", keyStorePath=" + keyStorePath + ", keyStoreType=" + keyStoreType + ", keyStoreProvider=" + keyStoreProvider + ", useRevocationAwareSSLContext=" + useRevocationAwareSSLContext + ", sslContext=" + sslContext));
            }
        } else {
            log.error((Object)("createDefaultSSLContext: leave. Error creating Default SSLContext. trustStorePath=" + trustStorePath + ", trustStoreType=" + trustStoreType + ", trustStoreProvider=" + trustStoreProvider + ", keyStorePath=" + keyStorePath + ", keyStoreType=" + keyStoreType + ", keyStoreProvider=" + keyStoreProvider + ", useRevocationAwareSSLContext=" + useRevocationAwareSSLContext));
        }
        return sslContext;
    }

    public SSLContext createSSLContext(boolean useRevocationAwareSSLContext) {
        String functionName = "createSSLContext";
        boolean isFinerEnabled = log.isFinerEnabled();
        if (isFinerEnabled) {
            log.finer((Object)("createSSLContext: entered. useRevocationAwareSSLContext=" + useRevocationAwareSSLContext));
        }
        String trustStorePath = this.getTrustStorePath();
        String trustStoreType = this.getTrustStoreType();
        String trustStoreProvider = this.getTrustStoreProvider();
        String trustStorePassword = this.getTrustStorePassword();
        String keyStorePath = this.getKeyStorePath();
        String keyStoreType = this.getKeyStoreType();
        String keyStoreProvider = this.getKeyStoreProvider();
        String keyStorePassword = this.getKeyStorePassword();
        SSLContext sslContext = this.createSSLContext(trustStorePath, trustStoreType, trustStoreProvider, trustStorePassword, keyStorePath, keyStoreType, keyStoreProvider, keyStorePassword, useRevocationAwareSSLContext);
        return sslContext;
    }

    public SSLContext createSSLContext(String trustStorePath, String trustStoreType, String trustStoreProvider, String trustStorePassword, boolean useRevocationAwareSSLContext) {
        String functionName = "createSSLContext";
        boolean isFinerEnabled = log.isFinerEnabled();
        if (isFinerEnabled) {
            log.finer((Object)("createSSLContext: entered. trustStorePath=" + trustStorePath + ", trustStoreType=" + trustStoreType + ", trustStoreProvider=" + trustStoreProvider + ", trustStorePassword<hidden>, useRevocationAwareSSLContext=" + useRevocationAwareSSLContext));
        }
        String keyStorePath = null;
        String keyStoreType = null;
        String keyStoreProvider = null;
        String keyStorePassword = null;
        return this.createSSLContext(trustStorePath, trustStoreType, trustStoreProvider, trustStorePassword, keyStorePath, keyStoreType, keyStoreProvider, keyStorePassword, useRevocationAwareSSLContext);
    }

    public SSLContext createSSLContext(String trustStorePath, String trustStoreType, String trustStoreProvider, String trustStorePassword, String keyStorePath, String keyStoreType, String keyStoreProvider, String keyStorePassword, boolean useRevocationAwareSSLContext) {
        String functionName = "createSSLContext";
        boolean isFinerEnabled = log.isFinerEnabled();
        if (isFinerEnabled) {
            log.finer((Object)("createSSLContext: entered. trustStorePath=" + trustStorePath + ", trustStoreType=" + trustStoreType + ", trustStoreProvider=" + trustStoreProvider + ", trustStorePassword=<hidden>, keyStorePath=" + keyStorePath + ", keyStoreType=" + keyStoreType + ", keyStoreProvider=" + keyStoreProvider + ", keyStorePassword=<hidden>, useRevocationAwareSSLContext=" + useRevocationAwareSSLContext));
        }
        String trustManagerFactoryAlgorithm = this.getTrustManagerFactoryAlgorithm();
        String keyManagerFactoryAlgorithm = this.getKeyManagerFactoryAlgorithm();
        String tlsVersion = this.getTlsVersion();
        String sslContextProvider = this.getSSLContextProvider();
        return this.createSSLContext(trustStorePath, trustStoreType, trustStoreProvider, trustStorePassword, trustManagerFactoryAlgorithm, keyStorePath, keyStoreType, keyStoreProvider, keyStorePassword, keyManagerFactoryAlgorithm, tlsVersion, sslContextProvider, useRevocationAwareSSLContext);
    }

    public SSLContext createSSLContext(String trustStorePath, String trustStoreType, String trustStoreProvider, String trustStorePassword, String trustManagerFactoryAlgorithm, String keyStorePath, String keyStoreType, String keyStoreProvider, String keyStorePassword, String keyManagerFactoryAlgorithm, String tlsVersion, String sslContextProvider, boolean useRevocationAwareSSLContext) {
        String functionName = "createSSLContext";
        boolean isFinerEnabled = log.isFinerEnabled();
        if (isFinerEnabled) {
            log.finer((Object)("createSSLContext: entered. trustStorePath=" + trustStorePath + ", trustStoreType=" + trustStoreType + ", trustStoreProvider=" + trustStoreProvider + ", trustStorePassword=<hidden>, trustManagerFactoryAlgorithm=" + trustManagerFactoryAlgorithm + ", keyStorePath=" + keyStorePath + ", keyStoreType=" + keyStoreType + ", keyStoreProvider=" + keyStoreProvider + ", keyStorePassword=<hidden>, keyManagerFactoryAlgorithm=" + keyManagerFactoryAlgorithm + ", tlsVersion=" + tlsVersion + ", sslContextProvider=" + sslContextProvider + ", useRevocationAwareSSLContext=" + useRevocationAwareSSLContext));
        }
        SSLContext sslContext = null;
        try {
            TrustKeyManagerFactorySupplier tkfs = new TrustKeyManagerFactorySupplier();
            TrustManagerFactory tmf = null;
            KeyManagerFactory kmf = null;
            if (trustStorePath != null) {
                tmf = tkfs.getTrustMgrFactory(trustStorePath, trustStoreType, trustStoreProvider, trustStorePassword, trustManagerFactoryAlgorithm, useRevocationAwareSSLContext);
            }
            if (keyStorePath != null) {
                kmf = tkfs.getKeyMgrFactory(keyStorePath, keyStoreType, keyStoreProvider, keyStorePassword, keyManagerFactoryAlgorithm);
            }
            sslContext = this.createSSLContext(tmf, kmf, tlsVersion, sslContextProvider);
        }
        catch (Exception e) {
            log.error((Object)("createSSLContext: Error creating SSLContext. trustStorePath=" + trustStorePath + ", trustStoreType=" + trustStoreType + ", trustStoreProvider=" + trustStoreProvider + ", trustStorePassword=<hidden>, trustManagerFactoryAlgorithm=" + trustManagerFactoryAlgorithm + ", keyStorePath=" + keyStorePath + ", keyStoreType=" + keyStoreType + ", keyStoreProvider=" + keyStoreProvider + ", keyStorePassword=<hidden>, keyManagerFactoryAlgorithm=" + keyManagerFactoryAlgorithm + ", tlsVersion=" + tlsVersion + ", sslContextProvider=" + sslContextProvider + ", useRevocationAwareSSLContext=" + useRevocationAwareSSLContext + "," + this.toString() + ", exception=" + e), (Throwable)e);
        }
        return sslContext;
    }

    public SSLContext createSSLContext(TrustManagerFactory trustManagerFactory, KeyManagerFactory keyManagerFactory, String tlsVersion, String sslContextProvider) throws NoSuchProviderException, KeyManagementException, NoSuchAlgorithmException {
        String functionName = "createSSLContext";
        boolean isFinerEnabled = log.isFinerEnabled();
        if (isFinerEnabled) {
            log.finer((Object)("createSSLContext: entered. trustManagerFactory=" + trustManagerFactory + ", keyManagerFactory=" + keyManagerFactory + ", tlsVersion=" + tlsVersion + ", contextProvider=" + sslContextProvider));
        }
        if (tlsVersion == null) {
            tlsVersion = this.getTlsVersion();
        }
        SSLContext sslContext = null;
        KeyManager[] keyManagers = null;
        TrustManager[] trustManagers = null;
        try {
            sslContext = sslContextProvider == null ? SSLContext.getInstance(tlsVersion) : SSLContext.getInstance(tlsVersion, sslContextProvider);
            if (keyManagerFactory != null) {
                keyManagers = keyManagerFactory.getKeyManagers();
            }
            if (trustManagerFactory != null) {
                trustManagers = trustManagerFactory.getTrustManagers();
            }
            SecureRandom secureRandom = this.getSecureRandom();
            sslContext.init(keyManagers, trustManagers, secureRandom);
            if (isFinerEnabled) {
                String secureRandomAlgorithm = null;
                if (secureRandom != null) {
                    secureRandomAlgorithm = secureRandom.getAlgorithm();
                }
                log.finer((Object)("createSSLContext: leave. Created SSLContext. tlsVersion=" + tlsVersion + ", keyManagers=" + keyManagers + ", trustManagers=" + trustManagers + ", provider=" + sslContext.getProvider() + ", protocol=" + sslContext.getProtocol() + ", defaultProtocols=" + Arrays.toString(sslContext.getDefaultSSLParameters().getProtocols()) + ", supportedProtocols=" + Arrays.toString(sslContext.getSupportedSSLParameters().getProtocols()) + ", secureRandom=" + secureRandom + ", secureRandomAlgorithm=" + secureRandomAlgorithm + ", sslContext=" + sslContext));
            }
        }
        catch (KeyManagementException | NoSuchAlgorithmException | NoSuchProviderException e) {
            log.error((Object)("createSSLContext: Error creating SSLContext. tlsVersion=" + tlsVersion + ", sslContextProvider=" + sslContextProvider + ", " + this.toString() + ", Exception=" + e), (Throwable)e);
            throw e;
        }
        return sslContext;
    }

    protected void setSystemPropertyIfNull(String parameterName, String parameterValue) {
        String functionName = "setSystemPropertyIfNull";
        boolean isFinerEnabled = log.isFinerEnabled();
        if (parameterName == null || parameterValue == null) {
            log.error((Object)("setSystemPropertyIfNull: ERROR parameterName=" + parameterName + ", parameterValue" + parameterValue));
            return;
        }
        if (System.getProperty(parameterName) == null) {
            System.setProperty(parameterName, parameterValue);
            if (isFinerEnabled) {
                log.finer((Object)("setSystemPropertyIfNull: set " + parameterName + "=" + parameterValue));
            }
        }
    }

    protected void setSystemProperty(String parameterName, String parameterValue) {
        String functionName = "setSystemParameter";
        boolean isFinerEnabled = log.isFinerEnabled();
        if (parameterName == null || parameterValue == null) {
            log.error((Object)("setSystemParameter: ERROR parameterName=" + parameterName + ", parameterValue" + parameterValue));
            return;
        }
        System.setProperty(parameterName, parameterValue);
        if (isFinerEnabled) {
            log.finer((Object)("setSystemParameter: set " + parameterName + "=" + parameterValue));
        }
    }

    public void setSSLSystemParameters() {
        String functionName = "setSSLSystemParameters";
        boolean isFinerEnabled = log.isFinerEnabled();
        if (isFinerEnabled) {
            log.finer((Object)"setSSLSystemParameters: entered.");
        }
        String trustStorePath = this.getTrustStorePath();
        String trustStoreType = this.getTrustStoreType();
        String trustStorePassword = this.getTrustStorePassword();
        String trustManagerFactoryAlgorithm = this.getTrustManagerFactoryAlgorithm();
        String keyStorePath = this.getKeyStorePath();
        String keyStoreType = this.getKeyStoreType();
        String keyStorePassword = this.getKeyStorePassword();
        String keyManagerFactoryAlgorithm = this.getKeyManagerFactoryAlgorithm();
        if (trustStorePath != null) {
            this.setSystemProperty(SYSTEM_PARAM_TRUST_STORE, trustStorePath);
        }
        if (trustStoreType != null) {
            this.setSystemProperty(SYSTEM_PARAM_TRUST_STORE_TYPE, trustStoreType);
        }
        if (trustStorePassword != null) {
            this.setSystemProperty(SYSTEM_PARAM_TRUST_STORE_PASSWORD, trustStorePassword);
        }
        if (trustManagerFactoryAlgorithm != null) {
            this.setSystemProperty(SYSTEM_PARAM_TRUST_MANAGER_FACTORY_ALGORITHM, trustManagerFactoryAlgorithm);
        }
        if (keyStorePath != null) {
            this.setSystemProperty(SYSTEM_PARAM_KEY_STORE, keyStorePath);
        }
        if (keyStoreType != null) {
            this.setSystemProperty(SYSTEM_PARAM_KEY_STORE_TYPE, keyStoreType);
        }
        if (keyStorePassword != null) {
            this.setSystemProperty(SYSTEM_PARAM_KEY_STORE_PASSWORD, keyStorePassword);
        }
        if (keyManagerFactoryAlgorithm != null) {
            this.setSystemProperty(SYSTEM_PARAM_KEY_MANAGER_FACTORY_ALGORITHM, keyManagerFactoryAlgorithm);
        }
        if (isFinerEnabled) {
            log.finer((Object)("setSSLSystemParameters: leaving. " + this.toString()));
        }
    }

    protected SecureRandom getSecureRandom() throws NoSuchAlgorithmException {
        return new SecureRandom();
    }

    public String getSystemParameterAsString(String systemParameter) {
        return systemParameter + "=" + System.getProperty(systemParameter);
    }

    public String getSecuritySystemParametersAsString() {
        return this.getSystemParameterAsString(SUN_SYSTEM_PARAM_CHECK_REVOCATION) + ", " + this.getSystemParameterAsString(SUN_SYSTEM_PARAM_ENABLE_CRLDP) + ", " + this.getSystemParameterAsString(SYSTEM_PARAM_KEY_MANAGER_FACTORY_ALGORITHM) + ", " + this.getSystemParameterAsString(SYSTEM_PARAM_KEY_STORE) + ", " + SYSTEM_PARAM_KEY_STORE_PASSWORD + "=<hidden>, " + this.getSystemParameterAsString(SYSTEM_PARAM_KEY_STORE_PROVIDER) + ", " + this.getSystemParameterAsString(SYSTEM_PARAM_KEY_STORE_TYPE) + ", " + this.getSystemParameterAsString(SYSTEM_PARAM_TRUST_MANAGER_FACTORY_ALGORITHM) + ", " + this.getSystemParameterAsString(SYSTEM_PARAM_TRUST_STORE) + ", " + SYSTEM_PARAM_TRUST_STORE_PASSWORD + "=<hidden>, " + this.getSystemParameterAsString(SYSTEM_PARAM_TRUST_STORE_PROVIDER) + ", " + this.getSystemParameterAsString(SYSTEM_PARAM_TRUST_STORE_TYPE) + ", " + this.getSystemParameterAsString(SYSTEM_PARAM_TLS_EPHEMERAL_DH_KEY_SIZE) + ", " + this.getSystemParameterAsString(SYSTEM_PARAM_PREFER_IPV4_STACK) + ", " + this.getSystemParameterAsString(SYSTEM_PARAM_TLS_CLIENT_PROTOCOLS) + ", " + this.getSystemParameterAsString(SYSTEM_PARAM_TLS_SERVER_PROTOCOLS) + ", " + this.getSystemParameterAsString(SYSTEM_PARAM_TLS_CLIENT_CIPHER_SUITES) + ", " + this.getSystemParameterAsString(SYSTEM_PARAM_TLS_SERVER_CIPHER_SUITES) + ", " + this.getSystemParameterAsString(SYSTEM_PARAM_JAVAX_NET_DEBUG) + ", " + this.getSystemParameterAsString(SYSTEM_PARAM_JAVA_SECURITY_DEBUG) + ", KeyManagerFactory.getDefaultAlgorithm()=" + KeyManagerFactory.getDefaultAlgorithm() + ", TrustManagerFactory.getDefaultAlgorithm()=" + TrustManagerFactory.getDefaultAlgorithm() + ", KeyStore.getDefaultType()=" + KeyStore.getDefaultType() + ", securityProviders=" + Arrays.toString(Security.getProviders());
    }

    public String toString() {
        Runtime rt = Runtime.getRuntime();
        return "[tlsVersion=" + this.getTlsVersion() + "hostnameVerifier=" + this.getHostnameVerifier() + ", keyManagerFactoryAlgorithm=" + this.getKeyManagerFactoryAlgorithm() + ", keyStorePassword=<hidden>, keyStorePath=" + this.getKeyStorePath() + ", keyStoreProvider=" + this.getKeyStoreProvider() + ", keyStoreType=" + this.getKeyStoreType() + ", trustManagerFactoryAlgorithm=" + this.getTrustManagerFactoryAlgorithm() + ", trustStorePassword=<hidden>, trustStorePath=" + this.getTrustStorePath() + ", trustStoreProvider=" + this.getTrustStoreProvider() + ", trustStoreType=" + this.getTrustStoreType() + ", systemParameters=[" + this.getSecuritySystemParametersAsString() + "], heapSize=" + rt.totalMemory() + ", heapMaxSize=" + rt.maxMemory() + ", heapFreeSize=" + rt.freeMemory() + "]";
    }
}

