/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ustore;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.datamgr.DMUtilities;
import com.avaya.common.logging.client.Logger;
import com.avaya.ustore.AADSInfoUtils;
import com.avaya.ustore.UStoreCommonConstants;
import com.avaya.ustore.VersionHelper;

public class AADSVersionChecker {
    private final Logger log = AsmLogger.getLogger(AADSVersionChecker.class);
    protected AADSInfoUtils aadsInfoUtils = new AADSInfoUtils();
    protected boolean minVersionCheck = false;
    protected static boolean isMega = DMUtilities.propertyFileExists() && DMUtilities.isMegaSM();

    public AADSVersionChecker() {
        if (isMega) {
            this.minVersionCheck = true;
        }
    }

    public Boolean checkMinimumAADSVersions() {
        boolean isFiner = this.log.isFinerEnabled();
        String fcn_name = "checkMinimumAADSVersions";
        if (isFiner) {
            this.log.finer((Object)("checkMinimumAADSVersions: enter, minVersionCheck = " + this.minVersionCheck));
        }
        if (this.minVersionCheck) {
            return true;
        }
        VersionHelper minAADSVersion = this.aadsInfoUtils.getMinAADSVersion();
        if (minAADSVersion == null) {
            if (isFiner) {
                this.log.finer((Object)"checkMinimumAADSVersions: leave, cannot get Minumum AADS Version, returning null.");
            }
            return null;
        }
        if (minAADSVersion.equals(UStoreCommonConstants.VALID_AADS_VERSION)) {
            this.minVersionCheck = true;
        }
        if (isFiner) {
            this.log.finer((Object)("checkMinimumAADSVersions: leave , minVersionCheck = " + this.minVersionCheck));
        }
        return this.minVersionCheck;
    }
}

