/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.eclipse.plugin.job;

import com.avaya.eclipse.plugin.Activator;
import com.avaya.eclipse.plugin.CEProjectModel;
import com.avaya.eclipse.plugin.PluginUtilities;
import com.avaya.eclipse.plugin.model.ElementInfo;
import com.avaya.eclipse.plugin.operation.CEOperation;
import com.avaya.ssh.SSHConnectionGroup;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class CEJobObject
extends WorkspaceJob {
    private IProject ceProject;
    private String actionType;
    private String serviceName;
    private CEProjectModel ceProjectModel;

    public CEJobObject(IProject ceProject, String actionType) {
        super("");
        this.ceProject = ceProject;
        this.actionType = actionType;
    }

    public CEJobObject(IProject ceProject, String actionType, String desc, String serviceName) {
        super(desc);
        this.ceProject = ceProject;
        this.actionType = actionType;
        this.serviceName = serviceName;
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        IStatus status = Status.OK_STATUS;
        CEOperation ceOperation = CEOperation.getOperation(this.actionType, this.serviceName);
        ceOperation.setProject(this.ceProject);
        try {
            status = ceOperation.execute(monitor);
        }
        catch (Exception e) {
            Activator.log(4, 0, "Error running job", e);
        }
        return status;
    }

    protected void canceling() {
        this.getThread().interrupt();
        if (this.ceProjectModel != null) {
            List<ElementInfo> smgrList = this.ceProjectModel.getAssociatedElements();
            for (ElementInfo elem : smgrList) {
                SSHConnectionGroup sshce = new SSHConnectionGroup(elem.getAssociatedElements());
                sshce.disConnectAll();
            }
        }
    }

    public CEProjectModel getCeProjectModel() {
        return this.ceProjectModel;
    }

    public void setCeProjectModel(CEProjectModel ceProjectModel) {
        this.ceProjectModel = ceProjectModel;
    }

    public void executeSchedule() {
        if (PluginUtilities.getInstance().isDemoMode()) {
            try {
                this.runInWorkspace(PluginUtilities.getInstance().getIprojectMonitor());
            }
            catch (CoreException coreException) {}
        } else {
            this.schedule();
        }
    }
}

