/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.eclipse.plugin.operation;

import com.avaya.eclipse.plugin.Activator;
import com.avaya.eclipse.plugin.CEProjectModel;
import com.avaya.eclipse.plugin.CEProjectUtils;
import com.avaya.eclipse.plugin.PropertyWindowEditor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import org.eclipse.core.resources.IProject;

public class FileChecksumStatus {
    public static final String PROPERTIES_MD5 = "propertiesmd5";
    public static final String ALARMS_MD5 = "alarmsmd5";
    public IProject project = null;
    public CEProjectModel ceModelP = null;
    public String projectName = null;

    public FileChecksumStatus(IProject project) {
        this.project = project;
        this.projectName = project.getName();
        this.ceModelP = CEProjectUtils.evaluateAsCEProject(project.getLocation().toFile());
    }

    public boolean isChecksumChangedForPropertyOrAlarm() {
        boolean checksumStatus = this.isPropertiesFileChecksumChanged();
        if (checksumStatus) {
            this.isAlarmFileChecksumChanged();
        } else {
            checksumStatus = this.isAlarmFileChecksumChanged();
        }
        return checksumStatus;
    }

    public boolean isPropertiesFileChecksumChanged() {
        String oldFileChecksum = this.getPropertyValue(this.projectName + PROPERTIES_MD5);
        Activator.log(1, "Old " + this.projectName + PROPERTIES_MD5 + " MD5 checksum : " + oldFileChecksum);
        String filePath = this.ceModelP.getAbsolutePathToProperties();
        boolean isChecksumChanged = this.isFileChecksumChanged(oldFileChecksum, filePath);
        if (isChecksumChanged) {
            this.updatePropertyValue(this.projectName + PROPERTIES_MD5, this.getFileChecksum(filePath));
        }
        return isChecksumChanged;
    }

    public boolean isAlarmFileChecksumChanged() {
        String oldFileChecksum = this.getPropertyValue(this.projectName + ALARMS_MD5);
        Activator.log(1, "Old " + this.projectName + ALARMS_MD5 + " MD5 checksum : " + oldFileChecksum);
        String filePath = this.ceModelP.getAbsolutePathToAlarms();
        boolean isChecksumChanged = this.isFileChecksumChanged(oldFileChecksum, filePath);
        if (isChecksumChanged) {
            this.updatePropertyValue(this.projectName + ALARMS_MD5, this.getFileChecksum(filePath));
        }
        return isChecksumChanged;
    }

    public String getPropertyValue(String property) {
        Properties serverConf = PropertyWindowEditor.getServerConfProperties();
        if (serverConf != null) {
            return serverConf.getProperty(property);
        }
        return null;
    }

    public void updatePropertyValue(String property, String value) {
        Properties serverConf = PropertyWindowEditor.getServerConfProperties();
        if (serverConf != null) {
            serverConf.put(property, value);
        }
    }

    public void updatePropertyValue() {
        PropertyWindowEditor.updateProperties();
    }

    public boolean isFileChecksumChanged(String oldChecksum, String filePath) {
        String fileChecksum;
        boolean isChecksumChanged = false;
        if (oldChecksum == null || "".equals(oldChecksum.trim())) {
            if (filePath != null && !"".equals(filePath.trim())) {
                isChecksumChanged = true;
            }
        } else if (filePath != null && !"".equals(filePath.trim()) && (fileChecksum = this.getFileChecksum(filePath)) != null && !oldChecksum.trim().equals(fileChecksum.trim())) {
            isChecksumChanged = true;
        }
        return isChecksumChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFileChecksum(String filePath) {
        String fileChecksum = null;
        if (filePath != null) {
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(filePath);
                fileChecksum = this.getFileChecksum(inputStream);
            }
            catch (IOException ex) {
                Activator.log(4, 0, "Error getting file checksum", ex);
            }
            finally {
                if (inputStream != null) {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (IOException e) {
                        Activator.log(4, 0, "Error closing input stream", e);
                    }
                }
            }
        }
        return fileChecksum;
    }

    public String getFileChecksum(InputStream inputStream) {
        String fileChecksum = null;
        if (inputStream != null) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                byte[] buffer = new byte[1024];
                int numOfBytes = 0;
                while ((numOfBytes = inputStream.read(buffer)) > 0) {
                    messageDigest.update(buffer, 0, numOfBytes);
                }
                byte[] hashByte = messageDigest.digest();
                if (hashByte != null && hashByte.length > 0) {
                    fileChecksum = new BigInteger(1, hashByte).toString(hashByte.length);
                }
            }
            catch (IOException ex) {
                Activator.log(4, 0, "Error getting file checksum", ex);
            }
            catch (NoSuchAlgorithmException ex) {
                Activator.log(4, 0, "Error: MD5 not supported!", ex);
            }
        }
        return fileChecksum;
    }
}

