/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ssh;

import com.avaya.eclipse.plugin.Activator;
import com.avaya.eclipse.plugin.model.ElementInfo;
import com.avaya.ssh.SSHConnection;
import com.avaya.ssh.SSHConnectionFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SSHConnector {
    public static final Map<String, SSHConnection> sshConnectionMap = new HashMap<String, SSHConnection>();
    public static final Map<String, SSHConnection> continuousSSHConnectionMap = new HashMap<String, SSHConnection>();
    private static SSHConnector sshc = null;
    private static SSHConnectionFactory connectionFactory = new SSHConnectionFactory();

    public static void setSshc(SSHConnector sshc) {
        SSHConnector.sshc = sshc;
    }

    public static SSHConnector getInstance() {
        if (sshc == null) {
            sshc = new SSHConnector();
        }
        return sshc;
    }

    public static void setConnectionFactory(SSHConnectionFactory factory) {
        connectionFactory = factory;
    }

    public static void resetConnectionFactory() {
        connectionFactory = new SSHConnectionFactory();
    }

    public final SSHConnection getSSHConnection(ElementInfo ei) throws IOException {
        SSHConnection ssh;
        if (sshConnectionMap.containsKey(ei.getIp())) {
            SSHConnection sshconn = sshConnectionMap.get(ei.getIp());
            if (sshconn.isConnected()) {
                return sshConnectionMap.get(ei.getIp());
            }
            sshconn.disconnect();
            sshConnectionMap.remove(ei.getIp());
        }
        if ((ssh = connectionFactory.createSSHConnection(ei)).isConnected()) {
            sshConnectionMap.put(ei.getIp(), ssh);
        }
        return ssh;
    }

    public final SSHConnection getContinuousSSHConnection(ElementInfo ei) throws IOException {
        return this.getContinuousSSHConnection(ei, false);
    }

    public final SSHConnection getContinuousSSHConnection(ElementInfo ei, boolean isCached) throws IOException {
        SSHConnection ssh;
        if (continuousSSHConnectionMap.containsKey(ei.getIp())) {
            if (!isCached) {
                continuousSSHConnectionMap.get(ei.getIp()).disconnect();
            } else {
                return continuousSSHConnectionMap.get(ei.getIp());
            }
        }
        if ((ssh = connectionFactory.createSSHConnection(ei)).isConnected()) {
            continuousSSHConnectionMap.put(ei.getIp(), ssh);
        }
        return ssh;
    }

    public final void disconnectAll() {
        try {
            Iterator<SSHConnection> itr = sshConnectionMap.values().iterator();
            while (itr.hasNext()) {
                SSHConnection sshconn = itr.next();
                if (sshconn != null) {
                    sshconn.disconnect();
                }
                itr.remove();
            }
            Iterator<SSHConnection> itrC = continuousSSHConnectionMap.values().iterator();
            while (itrC.hasNext()) {
                SSHConnection sshconn = itrC.next();
                if (sshconn != null) {
                    sshconn.disconnect();
                }
                itrC.remove();
            }
        }
        catch (Exception e) {
            Activator.log(4, 0, "Error disconnecting all", e);
        }
    }
}

