/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.eclipse.plugin;

import com.avaya.eclipse.plugin.CEDeploymentWindow;
import com.avaya.eclipse.plugin.ServerTreeView;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.IRSECoreRegistry;
import org.eclipse.rse.core.PasswordPersistenceManager;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.model.SystemSignonInformation;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.terminals.ui.TerminalServiceHelper;
import org.eclipse.rse.internal.terminals.ui.views.TerminalViewer;
import org.eclipse.rse.internal.terminals.ui.views.TerminalsUI;
import org.eclipse.rse.subsystems.shells.core.subsystems.servicesubsystem.IShellServiceSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.servicesubsystem.ShellServiceSubSystem;
import org.eclipse.rse.subsystems.terminals.core.ITerminalServiceSubSystem;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.internal.Workbench;

public final class PluginUtilities {
    private boolean isDemoMode = false;
    private IWorkspace workspace = null;
    private ISystemRegistry registry = null;
    private IRSECoreRegistry coreRegistry = null;
    private IProject project = null;
    private ITerminalServiceSubSystem itSub;
    private static PluginUtilities instance;

    public boolean isDemoMode() {
        return this.isDemoMode;
    }

    public void setDemoMode(boolean isDemoMode) {
        this.isDemoMode = isDemoMode;
    }

    public void setRegistry(ISystemRegistry registry) {
        this.registry = registry;
    }

    public void setCoreRegistry(IRSECoreRegistry coreRegistry) {
        this.coreRegistry = coreRegistry;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public void setItSub(ITerminalServiceSubSystem itSub) {
        this.itSub = itSub;
    }

    public void setWorkspace(IWorkspace workspace) {
        this.workspace = workspace;
    }

    private PluginUtilities() {
    }

    public static PluginUtilities getInstance() {
        if (instance == null) {
            instance = new PluginUtilities();
        }
        return instance;
    }

    public IShellServiceSubSystem getShellServiceSubSystem(IHost iHost) {
        ISubSystem[] subsystems = this.getTheSystemRegistry().getSubSystems(iHost);
        ShellServiceSubSystem shellServiceSubSystem = null;
        for (int i = 0; i < subsystems.length; ++i) {
            if (this.isDemoMode) {
                if (!"ssh.shells".equals(subsystems[i].getConfigurationId())) continue;
                shellServiceSubSystem = (ShellServiceSubSystem)subsystems[i];
                break;
            }
            if (!"ssh.shells".equals(subsystems[i].getSubSystemConfiguration().getId())) continue;
            shellServiceSubSystem = (ShellServiceSubSystem)subsystems[i];
            break;
        }
        return shellServiceSubSystem;
    }

    public IWorkspace getWorkspace() {
        if (this.isDemoMode) {
            return this.workspace;
        }
        return ResourcesPlugin.getWorkspace();
    }

    public ISystemRegistry getTheSystemRegistry() {
        if (this.isDemoMode) {
            return this.registry;
        }
        return RSECorePlugin.getTheSystemRegistry();
    }

    public IRSECoreRegistry getRSECoreRegistry() {
        if (this.isDemoMode) {
            return this.coreRegistry;
        }
        return RSECorePlugin.getTheCoreRegistry();
    }

    public void addToPasswordPersistenceManager(SystemSignonInformation info, boolean b, boolean c) {
        if (!this.isDemoMode) {
            PasswordPersistenceManager.getInstance().add(info, b, c);
        }
    }

    public void openInformation(Shell shell, String headingUpdate, String status) {
        if (!this.isDemoMode) {
            MessageDialog.openInformation((Shell)shell, (String)"Save", (String)"Properties Updated Successfully");
        }
    }

    public TerminalViewer getTerminalViewer() {
        if (this.isDemoMode) {
            return null;
        }
        return TerminalsUI.getInstance().activateTerminalsView();
    }

    public void openError(Shell shell, String string, Exception e) {
        if (this.isDemoMode) {
            e.getMessage();
        } else {
            MessageDialog.openError((Shell)shell, (String)"Error", (String)e.getMessage());
        }
    }

    public void openError(final Shell shell, final String string, final String message) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)shell, (String)string, (String)message);
            }
        });
    }

    public static void getLogger() {
    }

    public String getProjectLocation() {
        if (this.isDemoMode) {
            return "";
        }
        return Platform.getInstallLocation().getURL().getPath();
    }

    public IProject getCurrentProject() {
        if (this.isDemoMode) {
            return this.project;
        }
        ISelectionService selectionService = Workbench.getInstance().getActiveWorkbenchWindow().getSelectionService();
        ISelection selection = selectionService.getSelection();
        IProject iProject = null;
        if (selection instanceof IStructuredSelection) {
            Object firstElement = ((IStructuredSelection)selection).getFirstElement();
            if (firstElement instanceof IResource) {
                iProject = ((IResource)firstElement).getProject();
            } else if (firstElement instanceof IAdaptable) {
                iProject = (IProject)((IAdaptable)firstElement).getAdapter(IProject.class);
            }
        }
        return iProject;
    }

    public ITerminalServiceSubSystem getTerminalSubSystem(IHost ih) {
        if (this.isDemoMode) {
            return this.itSub;
        }
        return TerminalServiceHelper.getTerminalSubSystem((IHost)ih);
    }

    public String readJavaHome() {
        if (this.isDemoMode) {
            return "c:/";
        }
        InputDialog d = new InputDialog(null, "Configure JAVA HOME", "JAVA HOME Directory", "", null);
        d.open();
        return d.getValue();
    }

    public Menu hookContextMenu(MenuManager menuMgr, CheckboxTreeViewer viewer) {
        if (this.isDemoMode) {
            return null;
        }
        return menuMgr.createContextMenu(viewer.getControl());
    }

    public void openWindow(CEDeploymentWindow ceDeploymentWindow) {
        if (!this.isDemoMode) {
            ceDeploymentWindow.open();
        }
    }

    public void setInput(CheckboxTreeViewer viewer, ServerTreeView.Node node) {
        if (!this.isDemoMode) {
            viewer.setInput((Object)node);
        }
    }

    public int openMessageDialog(String input) {
        if (this.isDemoMode) {
            return -1;
        }
        MessageDialog messageDialog = new MessageDialog(null, "Are your sure?", null, "Are you sure you want to remove this System Manager - " + input + "?", 5, new String[]{"Yes", "No"}, 1);
        return messageDialog.open();
    }

    public int openMessageDeleteDialog() {
        if (this.isDemoMode) {
            return 0;
        }
        MessageDialog messageDialog = new MessageDialog(null, "Are your sure?", null, "This operation will un-install snap-in from all the clusters across all the selected System Manager and delete snap-in from all selected System Manager. Are you sure you want to delete this snap-in?", 5, new String[]{"Yes", "No"}, 1);
        return messageDialog.open();
    }

    public IProgressMonitor getIprojectMonitor() {
        IProgressMonitor ipm = new IProgressMonitor(){

            public void worked(int arg0) {
            }

            public void subTask(String arg0) {
            }

            public void setTaskName(String arg0) {
            }

            public void setCanceled(boolean arg0) {
            }

            public boolean isCanceled() {
                return false;
            }

            public void internalWorked(double arg0) {
            }

            public void done() {
            }

            public void beginTask(String arg0, int arg1) {
            }
        };
        return ipm;
    }
}

