/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.eclipse.plugin.operation;

import com.avaya.eclipse.plugin.Activator;
import com.avaya.eclipse.plugin.CEProjectModel;
import com.avaya.eclipse.plugin.CEProjectUtils;
import com.avaya.eclipse.plugin.model.ElementInfo;
import com.avaya.eclipse.plugin.operation.CEOperation;
import com.avaya.ssh.SSHConnectionGroup;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class CEDisableWatchServiceLogOperation
extends CEOperation {
    private boolean isServiceSpecific;

    public CEDisableWatchServiceLogOperation(IProject project) {
        this.project = project;
    }

    public CEDisableWatchServiceLogOperation() {
        this(null);
    }

    public CEDisableWatchServiceLogOperation(boolean b) {
        this.isServiceSpecific = b;
    }

    @Override
    public IStatus execute(IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        CEProjectModel ceModelP = null;
        if (this.project != null) {
            ceModelP = CEProjectUtils.evaluateAsCEProject(this.project.getLocation().toFile());
        } else {
            ceModelP = new CEProjectModel();
            CEProjectUtils.setAssociatedElements(ceModelP);
        }
        if (this.isServiceSpecific) {
            this.setMessageConsoleStream("ServiceLogs");
            this.stopOperation(ceModelP);
        } else {
            this.setMessageConsoleStream();
            this.stopOperationLoggingAll(ceModelP);
        }
        return status;
    }

    public void stopOperation(CEProjectModel cep) {
        this.stopOperationLoggingAll(cep);
    }

    public void stopOperationLoggingAll(CEProjectModel cep) {
        try {
            List<ElementInfo> smgrList = cep.getAssociatedElements();
            if (smgrList != null && smgrList.size() == 0) {
                CEOperation.openErrorDialog("Operation disable watch log failure", "Please select at least one Avaya Breeze\u00ae node to proceed with Avaya Breeze\u00ae Eclipse plug-in action.");
                return;
            }
            if (smgrList != null && smgrList.size() > 0) {
                for (ElementInfo elem : smgrList) {
                    SSHConnectionGroup sshce = new SSHConnectionGroup(elem.getAssociatedElements());
                    sshce.disConnectAll();
                }
            }
            this.logConsole("Operation disable watch log finished Successfully", "");
        }
        catch (Exception e) {
            Activator.log(4, 0, "Error disabling log watch op", e);
            CEOperation.openDialog("Disable Watch Log Execution Failure", e.getMessage());
        }
    }
}

